/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.config.serverbeans.LbConfigs;
import com.sun.enterprise.config.serverbeans.LoadBalancer;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.glassfish.loadbalancer.admin.cli.CreateHTTPHealthCheckerCommand;
import org.glassfish.loadbalancer.admin.cli.EnableHTTPLBApplicationCommand;
import org.glassfish.loadbalancer.admin.cli.EnableHTTPLBServerCommand;
import org.glassfish.loadbalancer.admin.cli.LBCommandsBase;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-http-lb-ref")
@Scoped(value=PerLookup.class)
@I18n(value="create.http.lb.ref")
@TargetType(value={CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@Cluster(value={RuntimeType.DAS})
public final class CreateHTTPLBRefCommand
extends LBCommandsBase
implements AdminCommand {
    @Param(optional=true)
    String config;
    @Param(optional=true)
    String lbname;
    @Param(optional=true)
    String lbpolicy;
    @Param(optional=true)
    String lbpolicymodule;
    @Param(optional=true, defaultValue="/")
    String healthcheckerurl;
    @Param(optional=true, defaultValue="30")
    String healthcheckerinterval;
    @Param(optional=true, defaultValue="10")
    String healthcheckertimeout;
    @Param(optional=true)
    String lbenableallapplications;
    @Param(optional=true)
    String lbenableallinstances;
    @Param(optional=true)
    String lbweight;
    @Param(primary=true)
    String target;
    @Inject
    LbConfigs lbconfigs;
    @Inject
    Target tgt;
    @Inject
    Logger logger;
    @Inject
    CommandRunner runner;
    @Inject
    Applications applications;
    private ActionReport report;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateHTTPLBRefCommand.class);

    public void execute(AdminCommandContext context) {
        List appRefs;
        String msg;
        Object command;
        boolean isCluster;
        this.report = context.getActionReport();
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        boolean bl = isCluster = this.target != null ? this.tgt.isCluster(this.target) : false;
        if (this.config != null && this.lbname != null) {
            String msg2 = localStrings.getLocalString("EitherConfigOrLBName", "Either LB name or LB config name, not both");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg2);
            return;
        }
        if (this.config == null && this.lbname == null) {
            String msg3 = localStrings.getLocalString("SpecifyConfigOrLBName", "Please specify either LB name or LB config name.");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg3);
            return;
        }
        if (this.config != null) {
            if (this.lbconfigs.getLbConfig(this.config) == null) {
                String msg4 = localStrings.getLocalString("LbConfigDoesNotExist", "Specified LB config {0} does not exist", new Object[]{this.config});
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg4);
                return;
            }
        } else if (this.lbname != null) {
            LoadBalancer lb = this.domain.getLoadBalancers().getLoadBalancer(this.lbname);
            if (lb == null) {
                String msg5 = localStrings.getLocalString("LoadBalancerConfigNotDefined", "Load balancer configuration [{0}] not found.", new Object[]{this.lbname});
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg5);
                return;
            }
            this.config = lb.getLbConfigName();
        }
        if (!(this.lbpolicy == null && this.lbpolicymodule == null || isCluster)) {
            String msg6 = localStrings.getLocalString("NotCluster", "{0} not a cluster", new Object[]{this.target});
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg6);
            return;
        }
        com.sun.enterprise.config.serverbeans.Cluster c = null;
        Server s = null;
        if (isCluster) {
            c = this.domain.getClusterNamed(this.target);
            if (c == null) {
                String msg7 = localStrings.getLocalString("ClusterNotDefined", "Cluster {0} cannot be used as target", new Object[]{this.target});
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg7);
                return;
            }
        } else {
            s = this.domain.getServerNamed(this.target);
            if (s == null) {
                String msg8 = localStrings.getLocalString("ServerNotDefined", "Server {0} cannot be used as target", new Object[]{this.target});
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg8);
                return;
            }
        }
        try {
            this.createLBRef(this.target, this.config);
        }
        catch (CommandException ce) {
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(ce.getMessage());
            this.report.setFailureCause((Throwable)ce);
            return;
        }
        if (this.healthcheckerurl != null) {
            try {
                command = (CreateHTTPHealthCheckerCommand)this.runner.getCommand("create-http-health-checker", this.report, context.getLogger());
                ((CreateHTTPHealthCheckerCommand)command).url = this.healthcheckerurl;
                ((CreateHTTPHealthCheckerCommand)command).interval = this.healthcheckerinterval;
                ((CreateHTTPHealthCheckerCommand)command).timeout = this.healthcheckertimeout;
                ((CreateHTTPHealthCheckerCommand)command).config = this.config;
                ((CreateHTTPHealthCheckerCommand)command).target = this.target;
                ((CreateHTTPHealthCheckerCommand)command).execute(context);
                this.checkCommandStatus(context);
            }
            catch (CommandException e) {
                msg = e.getLocalizedMessage();
                this.logger.warning(msg);
            }
        }
        if (Boolean.parseBoolean(this.lbenableallinstances)) {
            try {
                command = (EnableHTTPLBServerCommand)this.runner.getCommand("enable-http-lb-server", this.report, context.getLogger());
                ((EnableHTTPLBServerCommand)command).target = this.target;
                ((EnableHTTPLBServerCommand)command).execute(context);
                this.checkCommandStatus(context);
            }
            catch (CommandException e) {
                msg = e.getLocalizedMessage();
                this.logger.warning(msg);
            }
        }
        if (Boolean.parseBoolean(this.lbenableallapplications) && (appRefs = this.domain.getApplicationRefsInTarget(this.target)).size() > 0 && Boolean.parseBoolean(this.lbenableallapplications)) {
            for (ApplicationRef ref : appRefs) {
                if (!this.isUserApp(ref.getRef())) continue;
                this.enableApp(context, ref.getRef());
            }
        }
    }

    public void createLBRef(String target, String configName) throws CommandException {
        this.logger.fine("[LB-ADMIN] createLBRef called for target " + target);
        if (this.tgt.isCluster(target)) {
            this.addClusterToLbConfig(configName, target);
            this.logger.info(localStrings.getLocalString("http_lb_admin.AddClusterToConfig", "Added cluster {0} to load balancer {1}", new Object[]{target, configName}));
        } else if (this.domain.isServer(target)) {
            this.addServerToLBConfig(configName, target);
            this.logger.info(localStrings.getLocalString("http_lb_admin.AddServerToConfig", "Added server {0} to load balancer {1}", new Object[]{target, configName}));
        } else {
            String msg = localStrings.getLocalString("InvalidTarget", "Invalid target", new Object[]{target});
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
    }

    private void addServerToLBConfig(String configName, final String serverName) throws CommandException {
        boolean isStandAlone;
        LbConfig lbConfig = this.lbconfigs.getLbConfig(configName);
        ServerRef sRef = (ServerRef)lbConfig.getRefByRef(ServerRef.class, serverName);
        if (sRef != null) {
            String msg = localStrings.getLocalString("LBServerRefExists", "LB config already contains a server-ref for target {0}", new Object[]{this.target});
            throw new CommandException(msg);
        }
        Server server = this.domain.getServerNamed(serverName);
        boolean bl = isStandAlone = server.getCluster() == null && server.isInstance();
        if (!isStandAlone) {
            String msg = localStrings.getLocalString("NotStandAloneInstance", "[{0}] is not a stand alone instance. Only stand alone instance can be added to a load balancer.", new Object[]{serverName});
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<LbConfig>(){

                public Object run(LbConfig param) throws PropertyVetoException, TransactionFailure {
                    ServerRef ref = (ServerRef)param.createChild(ServerRef.class);
                    ref.setRef(serverName);
                    param.getClusterRefOrServerRef().add(ref);
                    return Boolean.TRUE;
                }
            }, (ConfigBeanProxy)lbConfig);
        }
        catch (TransactionFailure ex) {
            String msg = localStrings.getLocalString("FailedToAddServerRef", "Failed to add server-ref");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            this.report.setFailureCause((Throwable)ex);
            return;
        }
    }

    private void addClusterToLbConfig(String configName, final String clusterName) throws CommandException {
        LbConfig lbConfig = this.lbconfigs.getLbConfig(configName);
        ClusterRef cRef = (ClusterRef)lbConfig.getRefByRef(ClusterRef.class, clusterName);
        if (cRef != null) {
            String msg = localStrings.getLocalString("LBClusterRefExists", "LB config already contains a cluster-ref for target {0}", new Object[]{this.target});
            throw new CommandException(msg);
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<LbConfig>(){

                public Object run(LbConfig param) throws PropertyVetoException, TransactionFailure {
                    ClusterRef ref = (ClusterRef)param.createChild(ClusterRef.class);
                    ref.setRef(clusterName);
                    if (CreateHTTPLBRefCommand.this.lbpolicy != null) {
                        ref.setLbPolicy(CreateHTTPLBRefCommand.this.lbpolicy);
                    }
                    if (CreateHTTPLBRefCommand.this.lbpolicymodule != null) {
                        ref.setLbPolicyModule(CreateHTTPLBRefCommand.this.lbpolicymodule);
                    }
                    param.getClusterRefOrServerRef().add(ref);
                    return Boolean.TRUE;
                }
            }, (ConfigBeanProxy)lbConfig);
        }
        catch (TransactionFailure ex) {
            String msg = localStrings.getLocalString("FailedToAddClusterRef", "Failed to add cluster-ref");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            this.report.setFailureCause((Throwable)ex);
            return;
        }
    }

    private void enableApp(AdminCommandContext context, String appName) {
        try {
            EnableHTTPLBApplicationCommand command = (EnableHTTPLBApplicationCommand)this.runner.getCommand("enable-http-lb-application", this.report, context.getLogger());
            command.target = this.target;
            command.name = appName;
            command.execute(context);
            this.checkCommandStatus(context);
        }
        catch (CommandException e) {
            String msg = e.getLocalizedMessage();
            this.logger.warning(msg);
        }
    }

    private boolean isUserApp(String id) {
        return this.applications.getApplication(id).getObjectType().equals("user");
    }
}

