/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.File;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_validate-node")
@I18n(value="validate.node")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS})
public class ValidateNodeCommand
implements AdminCommand {
    @Inject
    private Nodes nodes;
    @Inject
    private CommandRunner cr;
    @Param(name="name", primary=true)
    private String name;
    @Param(name="nodedir", optional=true)
    private String nodedir;
    @Param(name="nodehost", optional=true)
    private String nodehost;
    @Param(name="installdir", optional=true)
    private String installdir;
    @Param(name="sshport", optional=true)
    private String sshport;
    @Param(name="sshuser", optional=true)
    private String sshuser;
    @Param(name="sshnodehost", optional=true)
    private String sshnodehost;
    @Param(name="sshkeyfile", optional=true)
    private String sshkeyfile;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.logger;
        logger.fine(Strings.get("Validating node {0}", this.name));
        Node node = this.nodes.getNode(this.name);
        if (node == null) {
            String msg = Strings.get("noSuchNode", this.name);
            logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        try {
            this.validateNode(node);
        }
        catch (CommandValidationException e) {
            logger.warning(e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
            return;
        }
        logger.fine(Strings.get("Node {0} is valid. Updating if needed", this.name));
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_update-node", report);
        ParameterMap map = new ParameterMap();
        map.add((Object)"DEFAULT", (Object)this.name);
        map.add((Object)"installdir", (Object)this.installdir);
        map.add((Object)"nodehost", (Object)this.nodehost);
        map.add((Object)"nodedir", (Object)this.nodedir);
        map.add((Object)"sshport", (Object)this.sshport);
        map.add((Object)"sshuser", (Object)this.sshuser);
        map.add((Object)"sshkeyfile", (Object)this.sshkeyfile);
        ci.parameters(map);
        ci.execute();
    }

    public void validateNode(Node node) throws CommandValidationException {
        String value = null;
        value = node.getNodeDir();
        this.validatePath("nodedir", this.nodedir, value);
        value = node.getNodeHost();
        this.validateHostname("nodehost", this.nodehost, value);
        value = node.getInstallDir();
        this.validatePath("installdir", this.installdir, value);
        SshConnector sshc = node.getSshConnector();
        if (sshc == null) {
            return;
        }
        value = sshc.getSshPort();
        this.validateString("sshport", this.sshport, value, false);
        value = sshc.getSshHost();
        this.validateHostname("sshnodehost", this.sshnodehost, value);
        SshAuth ssha = sshc.getSshAuth();
        if (ssha == null) {
            return;
        }
        value = ssha.getUserName();
        this.validateString("sshuser", this.sshuser, value, false);
        value = ssha.getKeyfile();
        this.validatePath("sshkeyfile", this.sshkeyfile, value);
    }

    private void validatePath(String propname, String value, String configValue) throws CommandValidationException {
        if (!StringUtils.ok((String)value) || !StringUtils.ok((String)configValue)) {
            return;
        }
        File valueFile = new File(value);
        File configValueFile = new File(configValue);
        if (!valueFile.equals(configValueFile)) {
            throw new CommandValidationException(Strings.get("attribute.mismatch", propname, value, configValue));
        }
    }

    private void validateHostname(String propname, String value, String configValue) throws CommandValidationException {
        try {
            this.validateString(propname, value, configValue, true);
            return;
        }
        catch (CommandValidationException e) {
            if (!NetUtils.isEqual((String)value, (String)configValue)) {
                throw new CommandValidationException(Strings.get("attribute.mismatch", propname, value, configValue));
            }
            return;
        }
    }

    private void validateString(String propname, String value, String configValue, boolean ignorecase) throws CommandValidationException {
        if (!StringUtils.ok((String)value) || !StringUtils.ok((String)configValue)) {
            return;
        }
        boolean match = false;
        match = ignorecase ? value.equalsIgnoreCase(configValue) : value.equals(configValue);
        if (!match) {
            throw new CommandValidationException(Strings.get("attribute.mismatch", propname, value, configValue));
        }
    }
}

