/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.ee.cms.core.AliveAndReadyView;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.FailureRecoveryActionFactory;
import com.sun.enterprise.ee.cms.core.FailureSuspectedActionFactory;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.MessageActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.client.FailureNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.FailureRecoveryActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.FailureSuspectedActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.GroupLeadershipNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinedAndReadyNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.MessageActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.PlannedShutdownActionFactoryImpl;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.ee.cms.spi.MemberStates;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyConfigConstants;
import com.sun.logging.LogDomains;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.HealthHistory;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.types.Property;

@Scoped(value=PerLookup.class)
@Service
public class GMSAdapterImpl
implements GMSAdapter,
PostConstruct,
CallBack {
    private static final Logger logger = LogDomains.getLogger(GMSAdapterImpl.class, (String)"javax.org.glassfish.gms");
    private Level gmsLogLevel = Level.CONFIG;
    private static final String BEGINS_WITH = "^";
    private static final String GMS_PROPERTY_PREFIX = "GMS_";
    private static final String GMS_PROPERTY_PREFIX_REGEXP = "^GMS_";
    private GroupManagementService gms;
    private static final String INSTANCE_NAME = "INSTANCE_NAME";
    private static final String CLUSTER_NAME = "CLUSTER_NAME";
    private static final String CORE = "CORE";
    private static final String SPECTATOR = "SPECTATOR";
    private static final String MEMBERTYPE_STRING = "MEMBER_TYPE";
    private String instanceName = null;
    private boolean isDas = false;
    private Cluster cluster = null;
    private String clusterName = null;
    private Config clusterConfig = null;
    private long joinTime = 0L;
    private ConcurrentHashMap<CallBack, JoinNotificationActionFactory> callbackJoinActionFactoryMapping = new ConcurrentHashMap();
    private ConcurrentHashMap<CallBack, JoinedAndReadyNotificationActionFactory> callbackJoinedAndReadyActionFactoryMapping = new ConcurrentHashMap();
    private ConcurrentHashMap<CallBack, FailureNotificationActionFactory> callbackFailureActionFactoryMapping = new ConcurrentHashMap();
    private ConcurrentHashMap<CallBack, FailureSuspectedActionFactory> callbackFailureSuspectedActionFactoryMapping = new ConcurrentHashMap();
    private ConcurrentHashMap<CallBack, GroupLeadershipNotificationActionFactory> callbackGroupLeadershipActionFactoryMapping = new ConcurrentHashMap();
    private ConcurrentHashMap<CallBack, PlannedShutdownActionFactory> callbackPlannedShutdownActionFactoryMapping = new ConcurrentHashMap();
    private EventListener glassfishEventListener = null;
    private boolean aliveAndReadyLoggingEnabled = false;
    @Inject
    Events events;
    @Inject
    ServerEnvironment env;
    @Inject(name="default-instance-name")
    Server server;
    @Inject
    Habitat habitat;
    @Inject
    Clusters clusters;
    private HealthHistory hHistory;
    AtomicBoolean initialized = new AtomicBoolean(false);
    AtomicBoolean initializationComplete = new AtomicBoolean(false);

    public void postConstruct() {
        logger.setLevel(Level.CONFIG);
        logger.log(Level.CONFIG, "gmsservice.postconstruct");
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public boolean initialize(String clusterName) {
        if (this.initialized.compareAndSet(false, true)) {
            this.clusterName = clusterName;
            if (clusterName == null) {
                logger.log(Level.SEVERE, "no clustername to lookup");
                return false;
            }
            try {
                this.gms = GMSFactory.getGMSModule((String)clusterName);
            }
            catch (GMSException ge) {
                // empty catch block
            }
            if (this.gms != null) {
                logger.log(Level.SEVERE, "multiple gms-adapter service for cluster " + clusterName);
                return false;
            }
            Domain domain = (Domain)this.habitat.getComponent(Domain.class);
            this.instanceName = this.env.getInstanceName();
            this.isDas = this.env.isDas();
            if (this.isDas) {
                for (Cluster clusterI : this.clusters.getCluster()) {
                    if (clusterName.compareTo(clusterI.getName()) != 0) continue;
                    this.cluster = clusterI;
                    break;
                }
                this.initializeHealthHistory(this.cluster);
            } else {
                this.cluster = this.server.getCluster();
                assert (clusterName.equals(this.cluster.getName()));
            }
            if (this.cluster == null) {
                logger.log(Level.WARNING, "gmsservice.nocluster.warning");
                return false;
            }
            this.clusterConfig = domain.getConfigNamed(clusterName + "-config");
            if (logger.isLoggable(Level.CONFIG)) {
                logger.config("clusterName=" + clusterName + " clusterConfig=" + this.clusterConfig);
            }
            try {
                this.initializeGMS();
            }
            catch (GMSException e) {
                logger.log(Level.WARNING, "gmsexception.occurred", e);
            }
            this.initializationComplete.set(true);
        }
        return this.initialized.get();
    }

    public void complete() {
        this.initialized.compareAndSet(true, false);
        this.initializationComplete.compareAndSet(true, false);
        this.gms = null;
        GMSFactory.removeGMSModule((String)this.clusterName);
    }

    public HealthHistory getHealthHistory() {
        this.checkInitialized();
        return this.hHistory;
    }

    private void initializeHealthHistory(Cluster cluster) {
        try {
            this.hHistory = new HealthHistory(cluster.getInstances());
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "new HealthHistory(List)", t);
        }
    }

    private void readGMSConfigProps(Properties configProps) {
        GrizzlyConfigConstants key;
        String value;
        String name;
        configProps.put(MEMBERTYPE_STRING, this.isDas ? SPECTATOR : CORE);
        block20: for (ServiceProviderConfigurationKeys key2 : ServiceProviderConfigurationKeys.values()) {
            String keyName = key2.toString();
            try {
                switch (key2) {
                    case MULTICASTADDRESS: {
                        if (this.cluster == null) break;
                        configProps.put(keyName, this.cluster.getGmsMulticastAddress());
                        break;
                    }
                    case MULTICASTPORT: {
                        if (this.cluster == null) break;
                        configProps.put(keyName, this.cluster.getGmsMulticastPort());
                        break;
                    }
                    case FAILURE_DETECTION_TIMEOUT: {
                        if (this.clusterConfig == null) break;
                        String value2 = this.clusterConfig.getGroupManagementService().getFailureDetection().getHeartbeatFrequencyInMillis();
                        configProps.put(keyName, value2);
                        break;
                    }
                    case FAILURE_DETECTION_RETRIES: {
                        if (this.clusterConfig == null) break;
                        String value2 = this.clusterConfig.getGroupManagementService().getFailureDetection().getMaxMissedHeartbeats();
                        configProps.put(keyName, value2);
                        break;
                    }
                    case FAILURE_VERIFICATION_TIMEOUT: {
                        if (this.clusterConfig == null) break;
                        String value2 = this.clusterConfig.getGroupManagementService().getFailureDetection().getVerifyFailureWaittimeInMillis();
                        configProps.put(keyName, value2);
                        break;
                    }
                    case DISCOVERY_TIMEOUT: {
                        if (this.clusterConfig == null) break;
                        String value2 = this.clusterConfig.getGroupManagementService().getGroupDiscoveryTimeoutInMillis();
                        configProps.put(keyName, value2);
                        break;
                    }
                    case IS_BOOTSTRAPPING_NODE: {
                        configProps.put(keyName, this.isDas ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                        break;
                    }
                    case VIRTUAL_MULTICAST_URI_LIST: {
                        break;
                    }
                    case BIND_INTERFACE_ADDRESS: {
                        if (this.cluster == null) break;
                        String value2 = this.cluster.getGmsBindInterfaceAddress().trim();
                        if (value2 == null || value2.length() <= 1 || value2.charAt(0) == '$') continue block20;
                        configProps.put(keyName, value2);
                        break;
                    }
                    case FAILURE_DETECTION_TCP_RETRANSMIT_TIMEOUT: {
                        if (this.clusterConfig == null) break;
                        String value2 = this.clusterConfig.getGroupManagementService().getFailureDetection().getVerifyFailureConnectTimeoutInMillis();
                        configProps.put(keyName, value2);
                        break;
                    }
                    case MULTICAST_POOLSIZE: 
                    case INCOMING_MESSAGE_QUEUE_SIZE: 
                    case FAILURE_DETECTION_TCP_RETRANSMIT_PORT: {
                        if (this.clusterConfig == null) break;
                        Property prop = this.clusterConfig.getGroupManagementService().getProperty(keyName);
                        if (prop == null) {
                            if (!logger.isLoggable(Level.FINE)) break;
                            logger.fine(String.format("No config property found for %s", keyName));
                            break;
                        }
                        String value3 = prop.getValue().trim();
                        configProps.put(keyName, value3);
                        break;
                    }
                    case LOOPBACK: {
                        break;
                    }
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "gmsexception.processing.config.props", t);
            }
        }
        List props = null;
        if (this.clusterConfig != null) {
            props = this.clusterConfig.getGroupManagementService().getProperty();
            for (Property prop : props) {
                name = prop.getName().trim();
                value = prop.getValue().trim();
                logger.config("processing group-management-service property name=" + name + " value= " + value);
                if (value.startsWith("${")) {
                    logger.config("skipping group-management-service property name=" + name + " since value is unresolved symbolic token=" + value);
                    continue;
                }
                if (name == null) continue;
                try {
                    logger.config("processing group-management-service property name=" + name + " value= " + value);
                    if (name.startsWith(GMS_PROPERTY_PREFIX)) {
                        name = name.replaceFirst(GMS_PROPERTY_PREFIX_REGEXP, "");
                    }
                    key = GrizzlyConfigConstants.valueOf((String)name);
                    configProps.put(name, value);
                }
                catch (IllegalArgumentException iae) {
                    logger.warning("ignoring group-management-service property " + name + " with value of " + value + " due to " + iae.getLocalizedMessage());
                }
            }
        }
        if (this.cluster != null) {
            props = this.cluster.getProperty();
            for (Property prop : props) {
                name = prop.getName().trim();
                value = prop.getValue().trim();
                logger.config("processing cluster property name=" + name + " value= " + value);
                if (value.startsWith("${")) {
                    logger.config("skipping cluster property name=" + name + " since value is unresolved symbolic token=" + value);
                    continue;
                }
                if (name == null) continue;
                try {
                    if (name.startsWith(GMS_PROPERTY_PREFIX)) {
                        name = name.replaceFirst(GMS_PROPERTY_PREFIX_REGEXP, "");
                    }
                    if (name.compareTo("ALIVEANDREADY_LOGGING") == 0) {
                        this.aliveAndReadyLoggingEnabled = Boolean.parseBoolean(value);
                        continue;
                    }
                    if (name.compareTo("LISTENER_PORT") == 0) {
                        configProps.put(GrizzlyConfigConstants.TCPSTARTPORT.toString(), value);
                        configProps.put(GrizzlyConfigConstants.TCPENDPORT.toString(), value);
                        continue;
                    }
                    key = GrizzlyConfigConstants.valueOf((String)name);
                    configProps.put(name, value);
                }
                catch (Throwable t) {
                    logger.warning("error processing cluster property:" + name + " value:" + value + " due to exception " + t.getLocalizedMessage());
                }
            }
        }
    }

    private void initializeGMS() throws GMSException {
        Properties configProps = new Properties();
        int HA_MAX_GMS_MESSAGE_LENGTH = 0x400800;
        configProps.put(ServiceProviderConfigurationKeys.MAX_MESSAGE_LENGTH.toString(), Integer.toString(HA_MAX_GMS_MESSAGE_LENGTH));
        this.readGMSConfigProps(configProps);
        this.printProps(configProps);
        String memberType = (String)configProps.get(MEMBERTYPE_STRING);
        this.gms = (GroupManagementService)GMSFactory.startGMSModule((String)this.instanceName, (String)this.clusterName, (GroupManagementService.MemberType)GroupManagementService.MemberType.valueOf((String)memberType), (Properties)configProps);
        GMSFactory.setGMSEnabledState((String)this.clusterName, (Boolean)Boolean.TRUE);
        GMSLogDomain.getLogger((String)"ShoalLogger").setLevel(Level.CONFIG);
        if (this.gms != null) {
            try {
                this.registerJoinedAndReadyNotificationListener(this);
                this.registerJoinNotificationListener(this);
                this.registerFailureNotificationListener(this);
                this.registerPlannedShutdownListener(this);
                this.registerFailureSuspectedListener(this);
                this.registerFailureRecoveryListener("GlassfishV31", this);
                this.glassfishEventListener = new EventListener(){

                    public void event(EventListener.Event event) {
                        if (GMSAdapterImpl.this.gms == null) {
                            return;
                        }
                        if (event.is(EventTypes.SERVER_SHUTDOWN)) {
                            logger.fine("Calling gms.shutdown()...");
                            GMSAdapterImpl.this.removeJoinedAndReadyNotificationListener(GMSAdapterImpl.this);
                            GMSAdapterImpl.this.removeJoinNotificationListener(GMSAdapterImpl.this);
                            GMSAdapterImpl.this.removeFailureNotificationListener(GMSAdapterImpl.this);
                            GMSAdapterImpl.this.removeFailureSuspectedListener(GMSAdapterImpl.this);
                            GMSAdapterImpl.this.gms.shutdown(GMSConstants.shutdownType.INSTANCE_SHUTDOWN);
                            GMSAdapterImpl.this.removePlannedShutdownListener(GMSAdapterImpl.this);
                            GMSAdapterImpl.this.events.unregister(GMSAdapterImpl.this.glassfishEventListener);
                        } else if (event.is(EventTypes.SERVER_READY)) {
                            GMSAdapterImpl.this.gms.reportJoinedAndReadyState(GMSAdapterImpl.this.clusterName);
                        }
                    }
                };
                this.events.register(this.glassfishEventListener);
                this.gms.join();
                this.joinTime = System.currentTimeMillis();
                logger.info("member " + this.instanceName + " joined group " + this.clusterName);
            }
            catch (GMSException e) {
                this.events.unregister(this.glassfishEventListener);
                logger.log(Level.WARNING, "gmsexception.occurred", e.getLocalizedMessage());
            }
        } else {
            throw new GMSException("gms object is null.");
        }
        logger.log(Level.CONFIG, "gmsservice.started ", new Object[]{this.instanceName, this.clusterName});
    }

    private void validateCoreMembers() {
        List currentCoreMembers = this.gms.getGroupHandle().getCurrentCoreMembers();
        TreeSet<String> unknownMembers = new TreeSet<String>();
        for (String member : currentCoreMembers) {
            MemberStates state = this.gms.getGroupHandle().getMemberState(member, 10000L, 0L);
            if (state != MemberStates.UNKNOWN) continue;
            unknownMembers.add(member);
        }
        if (unknownMembers.size() > 0) {
            logger.log(Level.INFO, "aliveAndReady monitoring: joinedAndReady memberState is UNKNOWN for core members:" + unknownMembers);
        }
    }

    private void printProps(Properties prop) {
        if (!logger.isLoggable(Level.CONFIG)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String key : prop.stringPropertyNames()) {
            sb.append(key).append(" = ").append(prop.get(key)).append("  ");
        }
        logger.log(Level.CONFIG, "gmsservice.print.properties", sb.toString());
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    private void checkInitialized() {
        if (!this.initialized.get() || !this.initializationComplete.get()) {
            throw new IllegalStateException("GMSAdapter not properly initialized.");
        }
    }

    public GroupManagementService getModule() {
        this.checkInitialized();
        return this.gms;
    }

    public GroupManagementService getGMS(String groupName) {
        try {
            return GMSFactory.getGMSModule((String)groupName);
        }
        catch (GMSException e) {
            logger.log(Level.SEVERE, "Exception in getting GMS module for group " + groupName, e.getLocalizedMessage());
            return null;
        }
    }

    public void processNotification(Signal signal) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "gmsservice.processNotification", signal.getClass().getName());
        }
        try {
            if (this.hHistory != null) {
                this.hHistory.updateHealth(signal);
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "HealthHistory is null in processNotification");
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "hHistory.updateHealth(signal)", t);
        }
        if (this.aliveAndReadyLoggingEnabled && (signal instanceof JoinedAndReadyNotificationSignal || signal instanceof FailureNotificationSignal || signal instanceof PlannedShutdownSignal)) {
            PlannedShutdownSignal pssig;
            String signalSubevent = "";
            if (signal instanceof JoinedAndReadyNotificationSignal) {
                JoinedAndReadyNotificationSignal jrsig = (JoinedAndReadyNotificationSignal)signal;
                if (jrsig.getEventSubType() == GMSConstants.startupType.GROUP_STARTUP) {
                    signalSubevent = " Subevent: " + GMSConstants.startupType.GROUP_STARTUP;
                } else if (jrsig.getRejoinSubevent() != null) {
                    signalSubevent = " Subevent: " + jrsig.getRejoinSubevent();
                }
            }
            if (signal instanceof PlannedShutdownSignal && (pssig = (PlannedShutdownSignal)signal).getEventSubType() == GMSConstants.shutdownType.GROUP_SHUTDOWN) {
                signalSubevent = " Subevent:" + GMSConstants.shutdownType.GROUP_SHUTDOWN.toString();
            }
            AliveAndReadyView current = this.gms.getGroupHandle().getCurrentAliveAndReadyCoreView();
            AliveAndReadyView previous = this.gms.getGroupHandle().getPreviousAliveAndReadyCoreView();
            logger.info("AliveAndReady for signal: " + signal.getClass().getSimpleName() + signalSubevent + " for member: " + signal.getMemberToken() + " of group: " + signal.getGroupName() + " current:[" + current + "] previous:[" + previous + "]");
        }
    }

    public void registerJoinNotificationListener(CallBack callback) {
        if (this.gms != null && callback != null) {
            JoinNotificationActionFactoryImpl jnaf = new JoinNotificationActionFactoryImpl(callback);
            this.gms.addActionFactory((JoinNotificationActionFactory)jnaf);
            this.callbackJoinActionFactoryMapping.put(callback, (JoinNotificationActionFactory)jnaf);
        }
    }

    public void registerJoinedAndReadyNotificationListener(CallBack callback) {
        if (this.gms != null && callback != null) {
            JoinedAndReadyNotificationActionFactoryImpl jnaf = new JoinedAndReadyNotificationActionFactoryImpl(callback);
            this.gms.addActionFactory((JoinedAndReadyNotificationActionFactory)jnaf);
            this.callbackJoinedAndReadyActionFactoryMapping.put(callback, (JoinedAndReadyNotificationActionFactory)jnaf);
        }
    }

    public void registerMemberLeavingListener(CallBack callback) {
        if (this.gms != null && callback != null) {
            this.registerFailureNotificationListener(callback);
            this.registerPlannedShutdownListener(callback);
            this.registerJoinNotificationListener(callback);
        }
    }

    public void registerPlannedShutdownListener(CallBack callback) {
        if (this.gms != null && callback != null) {
            PlannedShutdownActionFactoryImpl psaf = new PlannedShutdownActionFactoryImpl(callback);
            this.callbackPlannedShutdownActionFactoryMapping.put(callback, (PlannedShutdownActionFactory)psaf);
            this.gms.addActionFactory((PlannedShutdownActionFactory)psaf);
        }
    }

    public void registerFailureSuspectedListener(CallBack callback) {
        if (this.gms != null) {
            FailureSuspectedActionFactoryImpl fsaf = new FailureSuspectedActionFactoryImpl(callback);
            this.callbackFailureSuspectedActionFactoryMapping.put(callback, (FailureSuspectedActionFactory)fsaf);
            this.gms.addActionFactory((FailureSuspectedActionFactory)fsaf);
        }
    }

    public void registerFailureNotificationListener(CallBack callback) {
        if (this.gms != null) {
            FailureNotificationActionFactoryImpl fnaf = new FailureNotificationActionFactoryImpl(callback);
            this.callbackFailureActionFactoryMapping.put(callback, (FailureNotificationActionFactory)fnaf);
            this.gms.addActionFactory((FailureNotificationActionFactory)fnaf);
        }
    }

    public void registerFailureRecoveryListener(String componentName, CallBack callback) {
        if (this.gms != null) {
            this.gms.addActionFactory(componentName, (FailureRecoveryActionFactory)new FailureRecoveryActionFactoryImpl(callback));
        }
    }

    public void registerMessageListener(String componentName, CallBack messageListener) {
        if (this.gms != null) {
            this.gms.addActionFactory((MessageActionFactory)new MessageActionFactoryImpl(messageListener), componentName);
        }
    }

    public void registerGroupLeadershipNotificationListener(CallBack callback) {
        if (this.gms != null) {
            this.gms.addActionFactory((GroupLeadershipNotificationActionFactory)new GroupLeadershipNotificationActionFactoryImpl(callback));
        }
    }

    public void removeFailureRecoveryListener(String componentName) {
        if (this.gms != null) {
            this.gms.removeFailureRecoveryActionFactory(componentName);
        }
    }

    public void removeMessageListener(String componentName) {
        if (this.gms != null) {
            this.gms.removeMessageActionFactory(componentName);
        }
    }

    public void removeFailureNotificationListener(CallBack callback) {
        FailureNotificationActionFactory fnaf;
        if (this.gms != null && (fnaf = this.callbackFailureActionFactoryMapping.remove(callback)) != null) {
            this.gms.removeActionFactory(fnaf);
        }
    }

    public void removeFailureSuspectedListener(CallBack callback) {
        FailureSuspectedActionFactory fsaf;
        if (this.gms != null && (fsaf = this.callbackFailureSuspectedActionFactoryMapping.remove(callback)) != null) {
            this.gms.removeFailureSuspectedActionFactory(fsaf);
        }
    }

    public void removeJoinNotificationListener(CallBack callback) {
        JoinNotificationActionFactory jaf;
        if (this.gms != null && (jaf = this.callbackJoinActionFactoryMapping.get(callback)) != null) {
            this.gms.removeActionFactory(jaf);
        }
    }

    public void removeJoinedAndReadyNotificationListener(CallBack callback) {
        JoinedAndReadyNotificationActionFactory jaf;
        if (this.gms != null && (jaf = this.callbackJoinedAndReadyActionFactoryMapping.get(callback)) != null) {
            this.gms.removeActionFactory(jaf);
        }
    }

    public void removePlannedShutdownListener(CallBack callback) {
        PlannedShutdownActionFactory psaf;
        if (this.gms != null && (psaf = this.callbackPlannedShutdownActionFactoryMapping.remove(callback)) != null) {
            this.gms.removeActionFactory(psaf);
        }
    }

    public void removeGroupLeadershipLNotificationistener(CallBack callback) {
        GroupLeadershipNotificationActionFactory glnf;
        if (this.gms != null && (glnf = this.callbackGroupLeadershipActionFactoryMapping.get(callback)) != null) {
            this.gms.removeActionFactory(glnf);
        }
    }

    public void removeMemberLeavingListener(CallBack callback) {
        this.removePlannedShutdownListener(callback);
        this.removeFailureNotificationListener(callback);
        this.removeJoinNotificationListener(callback);
    }
}

