/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms.bootstrap.admin;

import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.gms.bootstrap.admin.GMSAnnounceSupplementalInfo;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_gmsAnnounceAfterStopClusterCommand")
@Supplemental(value="stop-cluster", on=Supplemental.Timing.After, ifFailure=FailurePolicy.Warn)
@Scoped(value=PerLookup.class)
public class GMSAnnounceAfterStopClusterCommand
implements AdminCommand {
    static final Logger logger = LogDomains.getLogger(GMSAnnounceAfterStopClusterCommand.class, (String)"javax.enterprise.system.core");
    @Param(optional=false, primary=true)
    private String clusterName;
    @Param(optional=true, defaultValue="false")
    private boolean verbose;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        GMSAnnounceAfterStopClusterCommand.announceGMSGroupStopComplete(this.clusterName, report, logger);
    }

    public static void announceGMSGroupStopComplete(String clusterName, ActionReport report, Logger logger) {
        GMSAnnounceSupplementalInfo gmsInfo;
        if (report != null && (gmsInfo = (GMSAnnounceSupplementalInfo)report.getResultType(GMSAnnounceSupplementalInfo.class)) != null && gmsInfo.gmsInitiated) {
            GMSConstants.shutdownState groupShutdownState = GMSConstants.shutdownState.COMPLETED;
            try {
                if (gmsInfo.gms != null) {
                    gmsInfo.gms.announceGroupShutdown(clusterName, groupShutdownState);
                }
            }
            catch (Throwable t) {
                logger.warning(t.getLocalizedMessage());
            }
        }
    }
}

