/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLILogger;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.net.NetUtils;
import org.glassfish.api.admin.CommandException;

public class PortBaseHelper {
    public static final int PORT_MAX_VAL = 65535;
    public static final int PORTBASE_ADMINPORT_SUFFIX = 48;
    public static final int PORTBASE_HTTPSSL_SUFFIX = 81;
    public static final int PORTBASE_IIOPSSL_SUFFIX = 38;
    public static final int PORTBASE_IIOPMUTUALAUTH_SUFFIX = 39;
    public static final int PORTBASE_INSTANCE_SUFFIX = 80;
    public static final int PORTBASE_JMS_SUFFIX = 76;
    public static final int PORTBASE_IIOP_SUFFIX = 37;
    public static final int PORTBASE_JMX_SUFFIX = 86;
    public static final String ADMIN = "ASADMIN_LISTENER_PORT";
    public static final String HTTP = "HTTP_LISTENER_PORT";
    public static final String HTTPS = "HTTP_SSL_LISTENER_PORT";
    public static final String IIOP = "IIOP_LISTENER_PORT";
    public static final String IIOPM = "IIOP_SSL_MUTUALAUTH_PORT";
    public static final String IIOPS = "IIOP_SSL_LISTENER_PORT";
    public static final String JMS = "JMS_PROVIDER_PORT";
    public static final String JMX = "JMX_SYSTEM_CONNECTOR_PORT";
    private static final CLILogger logger = CLILogger.getInstance();
    private static final LocalStringsImpl strings = new LocalStringsImpl(PortBaseHelper.class);
    private String portBase;
    private boolean checkPorts;
    private String adminPort;
    private String instancePort;
    private String httpsPort;
    private String iiopPort;
    private String iiopmPort;
    private String iiopsPort;
    private String jmsPort;
    private String jmxPort;

    public PortBaseHelper(String portbase, boolean checkports) {
        this.portBase = portbase;
        this.checkPorts = checkports;
    }

    public void verifyPortBase() throws CommandException {
        if (this.usePortBase()) {
            int portbase = this.convertPortStr(this.portBase);
            this.setOptionsWithPortBase(portbase);
        }
    }

    public String getAdminPort() {
        return this.adminPort;
    }

    public String getInstancePort() {
        return this.instancePort;
    }

    public String getHttpsPort() {
        return this.httpsPort;
    }

    public String getIiopPort() {
        return this.iiopPort;
    }

    public String getIiopsPort() {
        return this.iiopsPort;
    }

    public String getIiopmPort() {
        return this.iiopmPort;
    }

    public String getJmsPort() {
        return this.jmsPort;
    }

    public String getJmxPort() {
        return this.jmxPort;
    }

    private int convertPortStr(String port) throws CommandException {
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new CommandException(strings.get("InvalidPortNumber", new Object[]{port}));
        }
    }

    private boolean usePortBase() throws CommandException {
        return this.portBase != null;
    }

    private void setOptionsWithPortBase(int portbase) throws CommandException {
        this.verifyPortBasePortIsValid(ADMIN, portbase + 48);
        this.adminPort = String.valueOf(portbase + 48);
        this.verifyPortBasePortIsValid(HTTP, portbase + 80);
        this.instancePort = String.valueOf(portbase + 80);
        this.verifyPortBasePortIsValid(HTTPS, portbase + 81);
        this.httpsPort = String.valueOf(portbase + 81);
        this.verifyPortBasePortIsValid(IIOPS, portbase + 38);
        this.iiopsPort = String.valueOf(portbase + 38);
        this.verifyPortBasePortIsValid(IIOPM, portbase + 39);
        this.iiopmPort = String.valueOf(portbase + 39);
        this.verifyPortBasePortIsValid(JMS, portbase + 76);
        this.jmsPort = String.valueOf(portbase + 76);
        this.verifyPortBasePortIsValid(IIOP, portbase + 37);
        this.iiopPort = String.valueOf(portbase + 37);
        this.verifyPortBasePortIsValid(JMX, portbase + 86);
        this.jmxPort = String.valueOf(portbase + 86);
    }

    private void verifyPortBasePortIsValid(String portName, int portNum) throws CommandException {
        if (portNum <= 0 || portNum > 65535) {
            throw new CommandException(strings.get("InvalidPortBaseRange", new Object[]{portNum, portName}));
        }
        if (this.checkPorts && !NetUtils.isPortFree((int)portNum)) {
            throw new CommandException(strings.get("PortBasePortInUse", new Object[]{portNum, portName}));
        }
        logger.printDebugMessage("Port =" + portNum);
    }
}

