/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cluster;

import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.universal.Duration;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.cluster.Strings;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstanceInfo {
    private final String host;
    private final int port;
    private final String name;
    private final long uptime;
    private final String state;
    private final String cluster;
    private final Logger logger;
    private final int timeoutInMsec;
    private boolean running;
    private static final String NOT_RUNNING = Strings.get("ListInstances.NotRunning");
    private static final String NAME = Strings.get("ListInstances.name");
    private static final String HOST = Strings.get("ListInstances.host");
    private static final String PORT = Strings.get("ListInstances.port");
    private static final String STATE = Strings.get("ListInstances.state");
    private static final String CLUSTER = Strings.get("ListInstances.cluster");
    private static final String NO_CLUSTER = "---";

    public InstanceInfo(String name0, int port0, String host0, String cluster0, Logger logger0, int timeout0) {
        if (name0 == null || host0 == null) {
            throw new NullPointerException("null arguments");
        }
        this.name = name0;
        this.port = port0;
        this.host = host0;
        this.logger = logger0;
        this.timeoutInMsec = timeout0;
        this.uptime = this.pingInstance();
        this.state = this.uptime == -1L ? NOT_RUNNING : this.formatTime(this.uptime);
        this.cluster = !StringUtils.ok((String)cluster0) ? null : cluster0;
    }

    public final String toString() {
        String cl = "";
        if (this.cluster != null) {
            cl = ", cluster: " + this.getCluster();
        }
        return "name: " + this.getName() + ", host: " + this.getHost() + ", port: " + this.getPort() + cl + ", uptime: " + this.uptime;
    }

    public final String getDisplayCluster() {
        return this.cluster == null ? NO_CLUSTER : this.cluster;
    }

    public final String getCluster() {
        return this.cluster;
    }

    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public final String getName() {
        return this.name;
    }

    public final long getUptime() {
        return this.uptime;
    }

    public final String getState() {
        return this.state;
    }

    public final boolean isRunning() {
        return this.running;
    }

    public static String format(List<InstanceInfo> infos) {
        int i;
        int longestName = NAME.length();
        int longestHost = HOST.length();
        int longestState = STATE.length();
        int longestPort = PORT.length();
        int longestCluster = CLUSTER.length();
        for (InstanceInfo info : infos) {
            int namel = info.getName().length();
            int hostl = info.getHost().length();
            int statel = info.getState().length();
            int clusterl = info.getDisplayCluster().length();
            if (namel > longestName) {
                longestName = namel;
            }
            if (hostl > longestHost) {
                longestHost = hostl;
            }
            if (statel > longestState) {
                longestState = statel;
            }
            if (clusterl <= longestCluster) continue;
            longestCluster = clusterl;
        }
        StringBuilder sb = new StringBuilder();
        String formattedLine = "%-" + (longestName += 2) + "s %-" + (longestHost += 2) + "s %-" + (longestPort += 2) + "s %-" + (longestCluster += 2) + "s %-" + (longestState += 2) + "s";
        sb.append(String.format(formattedLine, NAME, HOST, PORT, CLUSTER, STATE));
        sb.append('\n');
        for (i = 0; i < longestName; ++i) {
            sb.append('-');
        }
        sb.append('|');
        for (i = 0; i < longestHost; ++i) {
            sb.append('-');
        }
        sb.append('|');
        for (i = 0; i < longestPort; ++i) {
            sb.append('-');
        }
        sb.append('|');
        for (i = 0; i < longestCluster; ++i) {
            sb.append('-');
        }
        sb.append('|');
        for (i = 0; i < longestState; ++i) {
            sb.append('-');
        }
        sb.append('|');
        sb.append('\n');
        boolean first = true;
        for (InstanceInfo info : infos) {
            if (first) {
                first = false;
            } else {
                sb.append('\n');
            }
            String portString = "   " + info.getPort();
            sb.append(String.format(formattedLine, info.getName(), info.getHost(), portString, " " + info.getDisplayCluster(), info.getState()));
        }
        return sb.toString();
    }

    private long pingInstance() {
        if (!this.i9()) {
            return -1L;
        }
        try {
            RemoteAdminCommand rac = new RemoteAdminCommand("uptime", this.host, this.port, false, "admin", null, this.logger);
            rac.setConnectTimeout(this.timeoutInMsec);
            ParameterMap map = new ParameterMap();
            map.set((Object)"type", (Object)"terse");
            map.set((Object)"milliseconds", (Object)"true");
            this.running = true;
            String uptimeStr = rac.executeCommand(map).trim();
            return Long.parseLong(uptimeStr);
        }
        catch (CommandException ex) {
            return -1L;
        }
    }

    private boolean i9() {
        try {
            RemoteAdminCommand rac = new RemoteAdminCommand("__locations", this.host, this.port, false, "admin", null, this.logger);
            rac.setConnectTimeout(this.timeoutInMsec);
            ParameterMap map = new ParameterMap();
            map.set((Object)"type", (Object)"terse");
            String ret = rac.executeCommand(map).trim();
            if (ret != null && ret.endsWith("/" + this.name)) {
                return true;
            }
        }
        catch (CommandException commandException) {
            // empty catch block
        }
        return false;
    }

    private String formatTime(long uptime) {
        return Strings.get("instanceinfo.uptime", new Duration(uptime));
    }

    private static String prepareFormatString() {
        return null;
    }
}

