/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.FailureDetection;
import com.sun.enterprise.config.serverbeans.GroupManagementService;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
public class GMSConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Clusters clusters;
    @Inject
    Configs configs;

    public void postConstruct() {
        this.upgradeClusterElements();
        this.upgradeGroupManagementServiceElements();
    }

    private void upgradeClusterElements() {
        try {
            List clusterList = this.clusters.getCluster();
            for (Cluster cl : clusterList) {
                ConfigSupport.apply((SingleConfigCode)new ClusterConfigCode(), (ConfigBeanProxy)cl);
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading cluster data from V2 to V3", e);
            throw new RuntimeException(e);
        }
    }

    private void upgradeGroupManagementServiceElements() {
        try {
            List lconfigs = this.configs.getConfig();
            for (Config c : lconfigs) {
                ConfigSupport.apply((SingleConfigCode)new GroupManagementServiceConfigCode(), (ConfigBeanProxy)c);
            }
        }
        catch (Throwable t) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading cluster data from V2 to V3", t);
            throw new RuntimeException(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroupManagementServiceConfigCode
    implements SingleConfigCode<Config> {
        private GroupManagementServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException, TransactionFailure {
            Property prop;
            GroupManagementService gms = config.getGroupManagementService();
            Transaction t = Transaction.getTransaction((ConfigBeanProxy)config);
            t.enroll((ConfigBeanProxy)gms);
            String value = gms.getPingProtocolTimeoutInMillis();
            if (value != null) {
                gms.setGroupDiscoveryTimeoutInMillis(value);
            }
            FailureDetection fd = gms.getFailureDetection();
            t.enroll((ConfigBeanProxy)fd);
            value = gms.getFdProtocolTimeoutInMillis();
            if (value != null) {
                fd.setHeartbeatFrequencyInMillis(value);
            }
            if ((value = gms.getFdProtocolMaxTries()) != null) {
                fd.setMaxMissedHeartbeats(value);
            }
            if ((value = gms.getVsProtocolTimeoutInMillis()) != null) {
                fd.setVerifyFailureWaittimeInMillis(value);
            }
            if ((prop = gms.getProperty("failure-detection-tcp-retransmit-timeout")) != null && prop.getValue() != null) {
                fd.setVerifyFailureConnectTimeoutInMillis(prop.getValue().trim());
                List props = gms.getProperty();
                props.remove(prop);
            }
            return config;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClusterConfigCode
    implements SingleConfigCode<Cluster> {
        private ClusterConfigCode() {
        }

        public Object run(Cluster cluster) throws PropertyVetoException, TransactionFailure {
            cluster.setGmsEnabled(cluster.getHeartbeatEnabled());
            cluster.setHeartbeatEnabled(null);
            cluster.setGmsMulticastAddress(cluster.getHeartbeatAddress());
            cluster.setHeartbeatAddress(null);
            cluster.setGmsMulticastPort(cluster.getHeartbeatPort());
            cluster.setHeartbeatPort(null);
            Property prop = cluster.getProperty("gms-bind-interface-address");
            if (prop != null && prop.getValue() != null) {
                cluster.setGmsBindInterfaceAddress(prop.getValue());
                List props = cluster.getProperty();
                props.remove(prop);
            } else {
                cluster.setGmsBindInterfaceAddress(String.format("${GMS-BIND-INTERFACE-ADDRESS-%s}", cluster.getName()));
            }
            return cluster;
        }
    }
}

