/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="update-node-ssh")
@I18n(value="update.node.ssh")
@Scoped(value=PerLookup.class)
@Cluster(value={RuntimeType.DAS})
public class UpdateNodeSshCommand
implements AdminCommand {
    @Inject
    private CommandRunner cr;
    @Inject
    Habitat habitat;
    @Inject
    private Nodes nodes;
    @Param(name="name", primary=true)
    private String name;
    @Param(name="nodehost", optional=true)
    private String nodehost;
    @Param(name="installdir", optional=true)
    private String installdir;
    @Param(name="nodedir", optional=true)
    private String nodedir;
    @Param(name="sshport", optional=true)
    private String sshport;
    @Param(name="sshuser", optional=true)
    private String sshuser;
    @Param(name="sshkeyfile", optional=true)
    private String sshkeyfile;
    @Param(name="sshpassword", optional=true, password=true)
    private String sshpassword;
    @Param(name="sshkeypassphrase", optional=true, password=true)
    private String sshkeypassphrase;
    @Param(name="force", optional=true, defaultValue="false")
    private boolean force;
    private static final String NL = System.getProperty("line.separator");
    private Logger logger = null;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        StringBuilder msg = new StringBuilder();
        SSHLauncher sshL = (SSHLauncher)this.habitat.getComponent(SSHLauncher.class);
        Node node = null;
        this.logger = context.getLogger();
        node = this.nodes.getNode(this.name);
        if (node == null) {
            String m = Strings.get("noSuchNode", node);
            this.logger.warning(m);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(m);
            return;
        }
        ParameterMap map = new ParameterMap();
        map.add((Object)"DEFAULT", (Object)this.name);
        map.add((Object)"installdir", (Object)this.installdir);
        map.add((Object)"nodehost", (Object)this.nodehost);
        map.add((Object)"nodedir", (Object)this.nodedir);
        map.add((Object)"sshport", (Object)this.sshport);
        map.add((Object)"sshuser", (Object)this.sshuser);
        map.add((Object)"sshkeyfile", (Object)this.sshkeyfile);
        map.add((Object)"sshpassword", (Object)this.sshpassword);
        map.add((Object)"sshkeypassphrase", (Object)this.sshkeypassphrase);
        map.add((Object)"type", (Object)"SSH");
        this.initFromConfig(node);
        this.setDefaults();
        ParameterMap validateMap = new ParameterMap();
        validateMap.add((Object)"installdir", (Object)this.installdir);
        validateMap.add((Object)"nodehost", (Object)this.nodehost);
        validateMap.add((Object)"nodedir", (Object)this.nodedir);
        validateMap.add((Object)"sshport", (Object)this.sshport);
        validateMap.add((Object)"sshuser", (Object)this.sshuser);
        validateMap.add((Object)"sshkeyfile", (Object)this.sshkeyfile);
        validateMap.add((Object)"sshpassword", (Object)this.sshpassword);
        validateMap.add((Object)"sshkeypassphrase", (Object)this.sshkeypassphrase);
        try {
            NodeUtils nodeUtils = new NodeUtils(this.habitat, this.logger);
            nodeUtils.validate(validateMap, sshL);
        }
        catch (CommandValidationException e) {
            String m1 = Strings.get("node.ssh.invalid.params");
            if (!this.force) {
                String m2 = Strings.get("update.node.ssh.not.updated");
                msg.append(StringUtils.cat((String)NL, (String[])new String[]{m1, m2, e.getMessage()}));
                report.setMessage(msg.toString());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            String m2 = Strings.get("update.node.ssh.continue.force");
            msg.append(StringUtils.cat((String)NL, (String[])new String[]{m1, e.getMessage(), m2}));
        }
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_update-node", report);
        ci.parameters(map);
        ci.execute();
        if (StringUtils.ok((String)report.getMessage())) {
            if (msg.length() > 0) {
                msg.append(NL);
            }
            msg.append(report.getMessage());
        }
        report.setMessage(msg.toString());
    }

    private void initFromConfig(Node node) {
        SshAuth ssha;
        SshConnector sshc;
        if (this.nodehost == null) {
            this.nodehost = node.getNodeHost();
        }
        if (this.installdir == null) {
            this.installdir = node.getInstallDir();
        }
        if (this.nodedir == null) {
            this.nodedir = node.getNodeDir();
        }
        if ((sshc = node.getSshConnector()) == null) {
            return;
        }
        if (this.sshport == null) {
            this.sshport = sshc.getSshPort();
        }
        if ((ssha = sshc.getSshAuth()) == null) {
            return;
        }
        if (this.sshuser == null) {
            this.sshuser = ssha.getUserName();
        }
        if (this.sshkeyfile == null) {
            this.sshkeyfile = ssha.getKeyfile();
        }
        if (this.sshpassword == null) {
            this.sshpassword = ssha.getPassword();
        }
        if (this.sshkeypassphrase == null) {
            this.sshkeypassphrase = ssha.getPassword();
        }
    }

    private void setDefaults() {
        if (this.sshport == null) {
            this.sshport = "22";
        }
        if (this.sshuser == null) {
            this.sshuser = "${user.name}";
        }
        if (this.installdir == null) {
            this.installdir = "${com.sun.aas.installRoot}";
        }
    }
}

