/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.connect;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.SSHCommandExecutionException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.jvnet.hk2.component.Habitat;

public class RemoteConnectHelper {
    private Habitat habitat;
    private HashMap<String, Node> nodeMap;
    private Logger logger;
    private String dasHost = null;
    private int dasPort = -1;
    int commandStatus;
    String fullCommand = null;
    SSHLauncher sshL = null;

    public RemoteConnectHelper(Habitat habitat, Node[] nodes, Logger logger, String dasHost, int dasPort) {
        this.logger = logger;
        this.habitat = habitat;
        this.nodeMap = new HashMap();
        for (int i = 0; i < nodes.length; ++i) {
            Node n = nodes[i];
            this.nodeMap.put(n.getName(), n);
        }
        this.dasHost = dasHost;
        this.dasPort = dasPort;
    }

    public boolean isLocalhost(Node nodeRef) {
        String nodeHost = nodeRef.getNodeHost();
        if (nodeRef.equals("localhost")) {
            return true;
        }
        return NetUtils.IsThisHostLocal((String)nodeHost);
    }

    public boolean isRemoteConnectRequired(String nodeRef) {
        Node node = this.nodeMap.get(nodeRef);
        if (node != null) {
            String t = node.getType();
            return t.equals("SSH");
        }
        this.logger.warning("Invalid node ref " + nodeRef);
        return false;
    }

    public String getLastCommandRun() {
        return this.fullCommand;
    }

    public int runCommand(String noderef, String cmd, ParameterMap parameters, StringBuilder outputString) throws SSHCommandExecutionException {
        try {
            Node node = this.nodeMap.get(noderef);
            if (node == null) {
                this.logger.severe("Could not find node " + noderef);
                return 1;
            }
            String nodeHome = node.getInstallDir();
            if (nodeHome == null) {
                this.logger.severe("Invalid installdir " + noderef);
                return 1;
            }
            System.out.println("install dir " + nodeHome);
            SshConnector connector = node.getSshConnector();
            if (connector != null) {
                this.sshL = (SSHLauncher)this.habitat.getComponent(SSHLauncher.class);
                this.sshL.init(node, this.logger);
                String command = new String();
                String prefix = nodeHome + File.separator + "bin" + File.separator + "asadmin " + " --host " + this.dasHost + " --port " + this.dasPort + " " + cmd;
                String unixStyleSlash = prefix.replaceAll("\\\\", "/");
                System.out.println("unix Style command" + unixStyleSlash);
                String instanceName = new String();
                for (Map.Entry entry : parameters.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)parameters.getOne((Object)key);
                    if (key.equals("DEFAULT")) {
                        instanceName = value;
                        continue;
                    }
                    if (key.equals("help")) continue;
                    command = command + " " + key + " " + value;
                }
                this.fullCommand = unixStyleSlash + command + " " + instanceName;
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                System.out.println("fullcommand " + this.fullCommand);
                this.commandStatus = this.sshL.runCommand(this.fullCommand, outStream);
                String results = outStream.toString();
                outputString.append(results);
                return this.commandStatus;
            }
        }
        catch (IOException ex) {
            String m1 = " Command execution failed. " + ex.getMessage();
            String m2 = "";
            Throwable e2 = ex.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            this.logger.severe("Command execution failed for " + cmd);
            SSHCommandExecutionException cee = new SSHCommandExecutionException(StringUtils.cat((String)":", (String[])new String[]{m1}));
            cee.setSSHSettings(this.sshL.toString());
            cee.setCommandRun(this.fullCommand);
            throw cee;
        }
        catch (InterruptedException ei) {
            ei.printStackTrace();
            String m1 = ei.getMessage();
            String m2 = "";
            Throwable e2 = ei.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            this.logger.severe("Command interrupted " + cmd);
            SSHCommandExecutionException cee = new SSHCommandExecutionException(StringUtils.cat((String)":", (String[])new String[]{m1, m2}));
            cee.setSSHSettings(this.sshL.toString());
            cee.setCommandRun(this.fullCommand);
            throw cee;
        }
        return this.commandStatus;
    }
}

