/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.util.InstanceStateService;
import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.cluster.InstanceInfo;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.InstanceState;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="list-clusters")
@Scoped(value=PerLookup.class)
@I18n(value="list.clusters.command")
public final class ListClustersCommand
implements AdminCommand,
PostConstruct {
    @Inject
    private Habitat habitat;
    @Inject
    Domain domain;
    @Inject
    InstanceStateService stateService;
    private RemoteInstanceCommandHelper helper;
    private List<InstanceInfo> infos = new LinkedList<InstanceInfo>();
    private static final String NONE = "Nothing to list.";
    private static final String EOL = "\n";
    @Param(optional=true, primary=true, defaultValue="domain")
    String whichTarget;
    @Inject
    private Clusters allClusters;
    private ActionReport report;

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.habitat);
    }

    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        Logger logger = context.getLogger();
        ActionReport.MessagePart top = this.report.getTopMessagePart();
        List clusterList = null;
        if (this.whichTarget.equals("domain")) {
            Clusters clusters = this.domain.getClusters();
            clusterList = clusters.getCluster();
        } else {
            clusterList = this.createClusterList();
            if (clusterList == null) {
                this.fail(Strings.get("list.instances.badTarget", this.whichTarget));
                return;
            }
        }
        StringBuilder sb = new StringBuilder();
        if (clusterList.size() < 1) {
            sb.append(NONE);
        }
        boolean atleastOneInstanceRunning = false;
        boolean allInstancesRunning = true;
        int timeoutInMsec = 2000;
        for (Cluster cluster : clusterList) {
            String value;
            String display;
            String clusterName = cluster.getName();
            List servers = cluster.getInstances();
            for (Server server : servers) {
                String name = server.getName();
                if (name == null) continue;
                InstanceInfo ii = new InstanceInfo(name, this.helper.getAdminPort(server), server.getAdminHost(), clusterName, logger, timeoutInMsec);
                this.infos.add(ii);
                InstanceState.StateType state = ii.isRunning() ? this.stateService.setState(name, InstanceState.StateType.RUNNING, false) : this.stateService.setState(name, InstanceState.StateType.NO_RESPONSE, false);
                allInstancesRunning &= ii.isRunning();
                if (!ii.isRunning()) continue;
                atleastOneInstanceRunning = true;
            }
            if (servers.isEmpty() || !atleastOneInstanceRunning) {
                display = InstanceState.StateType.NOT_RUNNING.getDisplayString();
                value = InstanceState.StateType.NOT_RUNNING.getDescription();
            } else if (allInstancesRunning) {
                display = InstanceState.StateType.RUNNING.getDisplayString();
                value = InstanceState.StateType.RUNNING.getDescription();
            } else {
                display = " partially running";
                value = "PARTIALLY_RUNNING";
            }
            sb.append(clusterName).append(display).append(EOL);
            top.addProperty(clusterName, value);
        }
        String output = sb.toString();
        this.report.setMessage(output.substring(0, output.length() - 1));
    }

    private List<Cluster> createClusterList() {
        if (!StringUtils.ok((String)this.whichTarget)) {
            return this.allClusters.getCluster();
        }
        ReferenceContainer rc = this.domain.getReferenceContainerNamed(this.whichTarget);
        if (rc == null) {
            return this.getClustersForNodeOrConfig();
        }
        if (rc.isServer()) {
            Server s = (Server)rc;
            LinkedList<Cluster> cl = new LinkedList<Cluster>();
            cl.add(s.getCluster());
            return cl;
        }
        if (rc.isCluster()) {
            Cluster cluster = (Cluster)rc;
            LinkedList<Cluster> cl = new LinkedList<Cluster>();
            cl.add(cluster);
            return cl;
        }
        return null;
    }

    private List<Cluster> getClustersForNodeOrConfig() {
        if (this.whichTarget == null) {
            throw new NullPointerException("impossible!");
        }
        List<Cluster> list = this.getClustersForNode();
        if (list == null) {
            list = this.getClustersForConfig();
        }
        return list;
    }

    private List<Cluster> getClustersForNode() {
        List nodeList;
        boolean foundNode = false;
        Nodes nodes = this.domain.getNodes();
        if (nodes != null && (nodeList = nodes.getNode()) != null) {
            for (Node node : nodeList) {
                if (!this.whichTarget.equals(node.getName())) continue;
                foundNode = true;
                break;
            }
        }
        if (!foundNode) {
            return null;
        }
        return this.domain.getClustersOnNode(this.whichTarget);
    }

    private List<Cluster> getClustersForConfig() {
        Config config = this.domain.getConfigNamed(this.whichTarget);
        if (config == null) {
            return null;
        }
        List rcs = this.domain.getReferenceContainersOf(config);
        LinkedList<Cluster> clusters = new LinkedList<Cluster>();
        for (ReferenceContainer rc : rcs) {
            if (!rc.isCluster()) continue;
            clusters.add((Cluster)rc);
        }
        return clusters;
    }

    private void fail(String s) {
        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        this.report.setMessage(s);
    }
}

