/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgents;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@Scoped(value=PerLookup.class)
public class NodeAgentConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Domain domain;
    @Inject
    Servers servers;

    public void postConstruct() {
        NodeAgents nodeAgents = this.domain.getNodeAgents();
        if (nodeAgents == null) {
            return;
        }
        final List agList = nodeAgents.getNodeAgent();
        if (agList.size() == 0) {
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Domain>(){

                public Object run(Domain d) throws PropertyVetoException, TransactionFailure {
                    Nodes nodes = (Nodes)d.createChild(Nodes.class);
                    Transaction t = Transaction.getTransaction((ConfigBeanProxy)d);
                    if (t == null) {
                        return null;
                    }
                    for (NodeAgent na : agList) {
                        Object host = null;
                        Node node = (Node)nodes.createChild(Node.class);
                        node.setName(na.getName());
                        node.setType("CONFIG");
                        JmxConnector jc = na.getJmxConnector();
                        if (jc != null) {
                            List agentProp = jc.getProperty();
                            for (Property p : agentProp) {
                                String name = p.getName();
                                if (!name.equals("client-hostname")) continue;
                                node.setNodeHost(p.getValue());
                                node.setInstallDir("${com.sun.aas.installRoot}");
                            }
                        }
                        nodes.getNode().add(node);
                    }
                    d.setNodes(nodes);
                    List serverList = NodeAgentConfigUpgrade.this.servers.getServer();
                    if (serverList.size() <= 0) {
                        return null;
                    }
                    for (Server s : serverList) {
                        t.enroll((ConfigBeanProxy)s);
                        s.setNode(s.getNodeAgentRef());
                    }
                    d.setNodeAgents(null);
                    return null;
                }
            }, (ConfigBeanProxy)this.domain);
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading node-agent from V2 to V3", e);
            throw new RuntimeException(e);
        }
    }
}

