/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.util.io.FileUtils;
import com.trilead.ssh2.SFTPv3FileAttributes;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.jvnet.hk2.component.Habitat;

public abstract class SecureAdminBootstrapHelper {
    private static final URI DOMAIN_XML_URI = URI.create("config/domain.xml");
    private static final URI[] SECURE_ADMIN_FILE_REL_URIS_TO_COPY = new URI[]{DOMAIN_XML_URI, URI.create("config/keystore.jks"), URI.create("config/cacerts.jks")};
    private static final URI[] SECURE_ADMIN_FILE_DIRS_TO_CREATE = new URI[]{URI.create("config")};

    public static SecureAdminBootstrapHelper getRemoteHelper(Habitat habitat, File DASInstanceDir, String remoteNodeDir, String instance, Node node, Logger logger) throws BootstrapException {
        return new RemoteHelper(habitat, DASInstanceDir, remoteNodeDir, instance, node, logger);
    }

    public static SecureAdminBootstrapHelper getLocalHelper(File existingInstanceDir, File newInstanceDir) {
        return new LocalHelper(existingInstanceDir, newInstanceDir);
    }

    protected abstract void mkdirs(URI var1) throws IOException;

    protected abstract void copyBootstrapFiles() throws FileNotFoundException, IOException;

    protected abstract void backdateInstanceDomainXML() throws BootstrapException;

    public void bootstrapInstance() throws BootstrapException {
        try {
            this.mkdirs();
            this.copyBootstrapFiles();
            this.backdateInstanceDomainXML();
        }
        catch (Exception ex) {
            throw new BootstrapException(ex);
        }
    }

    private void mkdirs() throws IOException {
        for (URI dirURI : SECURE_ADMIN_FILE_DIRS_TO_CREATE) {
            this.mkdirs(dirURI);
        }
    }

    public static class BootstrapException
    extends Exception {
        private final SSHLauncher launcher;

        public BootstrapException(SSHLauncher launcher, Exception ex) {
            super(ex);
            this.launcher = launcher;
        }

        public BootstrapException(Exception ex) {
            super(ex);
            this.launcher = null;
        }

        public String sshSettings() {
            return this.launcher != null ? this.launcher.toString() : "";
        }
    }

    private static class LocalHelper
    extends SecureAdminBootstrapHelper {
        private final URI existingInstanceDirURI;
        private final URI newInstanceDirURI;

        private LocalHelper(File existingInstanceDir, File newInstanceDir) {
            this.existingInstanceDirURI = existingInstanceDir.toURI();
            this.newInstanceDirURI = newInstanceDir.toURI();
        }

        protected void mkdirs(URI dirURI) {
            new File(this.newInstanceDirURI.resolve(dirURI)).mkdirs();
        }

        public void copyBootstrapFiles() throws IOException {
            for (URI relativeURIToFile : SECURE_ADMIN_FILE_REL_URIS_TO_COPY) {
                File origin = new File(this.existingInstanceDirURI.resolve(relativeURIToFile));
                File dest = new File(this.newInstanceDirURI.resolve(relativeURIToFile));
                FileUtils.copyFile((File)origin, (File)dest);
            }
        }

        protected void backdateInstanceDomainXML() throws BootstrapException {
            File newDomainXMLFile = new File(this.newInstanceDirURI.resolve(DOMAIN_XML_URI));
            newDomainXMLFile.setLastModified(0L);
        }
    }

    private static class RemoteHelper
    extends SecureAdminBootstrapHelper {
        private final Logger logger;
        private final SSHLauncher launcher;
        private final File dasInstanceDir;
        private final String instance;
        private final URI remoteNodeDirURI;
        private final URI remoteInstanceURI;
        private final long domainXMLTimestamp;
        private final SFTPClient ftpClient;

        private RemoteHelper(Habitat habitat, File dasInstanceDir, String remoteNodeDir, String instance, Node node, Logger logger) throws BootstrapException {
            this.dasInstanceDir = dasInstanceDir;
            this.instance = instance;
            this.logger = logger;
            remoteNodeDir = this.remoteNodeDir(node, remoteNodeDir);
            this.remoteNodeDirURI = URI.create(remoteNodeDir);
            this.remoteInstanceURI = this.remoteInstanceURI(remoteNodeDir);
            this.domainXMLTimestamp = this.dasDomainXMLTimestamp(dasInstanceDir);
            this.launcher = (SSHLauncher)habitat.getComponent(SSHLauncher.class);
            this.launcher.init(node, logger);
            try {
                this.ftpClient = this.launcher.getSFTPClient();
            }
            catch (IOException ex) {
                throw new BootstrapException(this.launcher, ex);
            }
        }

        private long dasDomainXMLTimestamp(File dasInstanceDir) {
            return new File(dasInstanceDir.toURI().resolve(DOMAIN_XML_URI)).lastModified();
        }

        private String ensureTrailingSlash(String path) {
            if (!path.endsWith("/")) {
                return path + "/";
            }
            return path;
        }

        private String remoteNodeDir(Node node, String remoteNodeDir) {
            return remoteNodeDir != null ? remoteNodeDir : this.ensureTrailingSlash(node.getInstallDir()) + "nodes/" + node.getName();
        }

        private URI remoteInstanceURI(String remoteNodeDirPath) {
            StringBuilder remoteInstancePath = new StringBuilder(remoteNodeDirPath);
            if (!remoteNodeDirPath.endsWith("/")) {
                remoteInstancePath.append("/");
            }
            remoteInstancePath.append(this.instance).append("/");
            return URI.create(remoteInstancePath.toString());
        }

        protected void mkdirs(URI dirURI) throws IOException {
            Integer instanceDirPermissions = this.ftpClient.lstat((String)this.remoteNodeDirURI.getPath()).permissions;
            URI remoteFileURI = this.remoteInstanceURI.resolve(dirURI);
            this.ftpClient.mkdirs(remoteFileURI.getPath(), instanceDirPermissions.intValue());
        }

        protected void copyBootstrapFiles() throws FileNotFoundException, IOException {
            for (URI fileRelativeURI : SECURE_ADMIN_FILE_REL_URIS_TO_COPY) {
                InputStream is = null;
                URI remoteFileURI = null;
                try {
                    is = new BufferedInputStream(new FileInputStream(new File(this.dasInstanceDir.toURI().resolve(fileRelativeURI))));
                    remoteFileURI = this.remoteInstanceURI.resolve(fileRelativeURI);
                    this.writeToFile(remoteFileURI.getPath(), is);
                    this.logger.log(Level.FINE, "Copied bootstrap file to {0}", remoteFileURI.toASCIIString());
                }
                catch (Exception ex) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "Error copying bootstrap file to " + remoteFileURI.toASCIIString(), ex);
                    }
                    throw new IOException(ex);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
        }

        protected void backdateInstanceDomainXML() throws BootstrapException {
            URI remoteDomainXMLURI = this.remoteInstanceURI.resolve(DOMAIN_XML_URI);
            try {
                this.setLastModified(remoteDomainXMLURI.getPath(), 0L);
            }
            catch (IOException ex) {
                throw new BootstrapException(this.launcher, ex);
            }
            this.logger.log(Level.FINE, "Backdated the instance's copy of domain.xml");
        }

        private void writeToFile(String path, InputStream content) throws IOException {
            int bytesRead;
            BufferedOutputStream os = new BufferedOutputStream(this.ftpClient.writeToFile(path));
            byte[] buffer = new byte[1024];
            while ((bytesRead = content.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            ((OutputStream)os).close();
        }

        private void setLastModified(String path, long when) throws IOException {
            SFTPv3FileAttributes attrs = this.ftpClient.stat(path);
            attrs.mtime = this.secondsSince_01_Jan_1970(when);
            this.ftpClient.setstat(path, attrs);
        }

        private Integer secondsSince_01_Jan_1970(long milliseconds) {
            return new Integer((int)milliseconds / 1000);
        }
    }
}

