/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.LoadBalancer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.UnknownHostException;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.loadbalancer.admin.cli.LbLogUtil;
import org.glassfish.loadbalancer.admin.cli.connection.ConnectionManager;
import org.glassfish.loadbalancer.admin.cli.helper.LbConfigHelper;
import org.glassfish.loadbalancer.admin.cli.reader.api.LoadbalancerReader;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.types.Property;

@Service(name="apply-http-lb-changes")
@Scoped(value=PerLookup.class)
@I18n(value="apply.http.lb.changes")
public class ApplyHttpLbChanges
implements AdminCommand {
    @Inject
    Domain domain;
    @Inject
    ApplicationRegistry appRegistry;
    @Param(name="ping", optional=true)
    String ping;
    @Param(name="lb-name", primary=true)
    String lbName;
    private static final String LB_UPDATE_CONTEXT_ROOT = "/lbconfigupdate";
    private static final String IS_SECURE_PROPERTY = "is-device-ssl-enabled";
    private static final String SSL_PROXY_HOST_PROPERTY = "ssl-proxy-host";
    private static final String SSL_PROXY_PORT_PROPERTY = "ssl-proxy-port";
    private static final String GET = "GET";
    private static final String POST = "POST";

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            this.process();
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Throwable t) {
            String msg = LbLogUtil.getStringManager().getString("ApplyHttpLbChangesFailed", (Object)t.getMessage());
            LbLogUtil.getLogger().log(Level.WARNING, msg);
            if (LbLogUtil.getLogger().isLoggable(Level.FINE)) {
                LbLogUtil.getLogger().log(Level.FINE, "Exception when applying http lb changes", t);
            }
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(t.getMessage());
            report.setFailureCause(t);
        }
    }

    public void process() throws Exception {
        ConnectionManager _connectionManager = null;
        LoadBalancer lb = LbConfigHelper.getLoadBalancer(this.domain, this.lbName);
        String lbHost = lb.getDeviceHost();
        String lbPort = lb.getDevicePort();
        System.out.println("Host : " + lbHost + ", port : " + lbPort);
        String lbProxyHost = null;
        String lbProxyPort = null;
        Property lbProxyHostProperty = lb.getProperty(SSL_PROXY_HOST_PROPERTY);
        if (lbProxyHostProperty != null) {
            lbProxyHost = lbProxyHostProperty.getValue();
            Property lbProxyPortProperty = lb.getProperty(SSL_PROXY_PORT_PROPERTY);
            if (lbProxyPortProperty != null) {
                lbProxyPort = lbProxyPortProperty.getValue();
            }
        }
        boolean isSec = true;
        Property isSecProperty = lb.getProperty(IS_SECURE_PROPERTY);
        if (isSecProperty != null) {
            isSec = Boolean.getBoolean(isSecProperty.getValue());
        }
        _connectionManager = new ConnectionManager(lbHost, lbPort, lbProxyHost, lbProxyPort, this.lbName, isSec);
        if (this.ping != null && Boolean.valueOf(this.ping).booleanValue()) {
            this.ping(_connectionManager);
        } else {
            this.publish(_connectionManager, this.domain, lb.getLbConfigName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void publish(ConnectionManager _connectionManager, Domain domain, String lbConfigName) throws IOException, Exception {
        block7: {
            LoadbalancerReader lbr = LbConfigHelper.getLbReader(domain, this.appRegistry, lbConfigName);
            HttpURLConnection conn = _connectionManager.getConnection(LB_UPDATE_CONTEXT_ROOT);
            OutputStream out = null;
            try {
                try {
                    conn.setDoOutput(true);
                    conn.setRequestMethod(POST);
                    conn.connect();
                    out = conn.getOutputStream();
                    LbConfigHelper.exportXml(lbr, out);
                    out.flush();
                }
                catch (UnknownHostException uhe) {
                    throw new IOException(LbLogUtil.getStringManager().getString("CannotConnectToLBHost", (Object)uhe.getMessage()), uhe);
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage(), e);
                }
                Object var9_7 = null;
                if (out == null) return;
                if (conn == null) break block7;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (out != null && conn != null) {
                    int code = conn.getResponseCode();
                    String response = conn.getResponseMessage();
                    out.close();
                    conn.disconnect();
                    out = null;
                    if (code != 200) {
                        String url = conn.getURL().toString();
                        conn = null;
                        throw new IOException(LbLogUtil.getStringManager().getString("HttpError", (Object)new Integer(code), (Object)response, (Object)url));
                    }
                    conn = null;
                }
                throw throwable;
            }
            int code = conn.getResponseCode();
            String response = conn.getResponseMessage();
            out.close();
            conn.disconnect();
            out = null;
            if (code == 200) return;
            String url = conn.getURL().toString();
            conn = null;
            throw new IOException(LbLogUtil.getStringManager().getString("HttpError", (Object)new Integer(code), (Object)response, (Object)url));
        }
    }

    public boolean ping(ConnectionManager _connectionManager) throws IOException {
        HttpURLConnection conn = _connectionManager.getConnection(LB_UPDATE_CONTEXT_ROOT);
        conn.setRequestMethod(GET);
        conn.connect();
        int code = conn.getResponseCode();
        return code == 200;
    }
}

