/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.cluster.NodeInfo;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class ListNodesHelper {
    private Servers servers;
    private static final String EOL = "\n";
    Logger logger;
    String listType;
    boolean verbose;
    boolean terse;
    List<Node> nodeList;
    List<NodeInfo> infos = new LinkedList<NodeInfo>();

    public ListNodesHelper(Logger _logger, Servers servers, Nodes nodes, String type, boolean verbose, boolean terse) {
        this.logger = _logger;
        this.listType = type;
        this.verbose = verbose;
        this.terse = terse;
        this.servers = servers;
        this.nodeList = nodes.getNode();
        this.infos = new LinkedList<NodeInfo>();
    }

    public String getNodeList() {
        StringBuilder sb = new StringBuilder();
        boolean firstNode = true;
        for (Node n : this.nodeList) {
            String name = n.getName();
            String nodeType = n.getType();
            String host = n.getNodeHost();
            String installDir = n.getInstallDir();
            if (!this.listType.equals(nodeType) && !this.listType.equals("ALL")) continue;
            if (firstNode) {
                firstNode = false;
            } else {
                sb.append(EOL);
            }
            if (this.terse) {
                sb.append(name);
            } else if (!this.verbose) {
                sb.append(name + "  " + nodeType + "  " + host);
            }
            if (!this.verbose) continue;
            List serverList = this.servers.getServer();
            String instanceList = new String();
            if (serverList.size() > 0) {
                for (Server server : serverList) {
                    if (!name.equals(server.getNode())) continue;
                    instanceList = instanceList.concat(" " + server.getName() + ",");
                }
                this.logger.warning(instanceList);
            }
            NodeInfo ni = new NodeInfo(name, host, installDir, nodeType, instanceList);
            this.infos.add(ni);
        }
        if (this.verbose) {
            return NodeInfo.format(this.infos);
        }
        return sb.toString();
    }
}

