/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import java.io.IOException;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_setup-ssh-key")
@Scoped(value=PerLookup.class)
public final class SetupSshKey
extends CLICommand {
    @Param(optional=false, password=true)
    private String sshpassword;
    @Param(optional=true)
    private String sshuser;
    @Param(optional=true)
    private int sshport;
    @Param(optional=true)
    private String sshkeyfile;
    @Param(optional=true)
    private String sshpublickeyfile;
    @Param(optional=false, primary=true, multiple=true)
    private String[] nodes;
    @Inject
    private Habitat habitat;

    protected void validate() throws CommandException {
        if (this.sshuser == null) {
            this.sshuser = System.getProperty("user.name");
        }
        if (this.sshport == 0) {
            this.sshport = 22;
        }
    }

    protected int executeCommand() throws CommandException {
        SSHLauncher sshL = (SSHLauncher)this.habitat.getComponent(SSHLauncher.class);
        Globals.setDefaultHabitat((Habitat)this.habitat);
        for (String node : this.nodes) {
            sshL.init(this.sshuser, node, this.sshport, this.sshpassword, this.sshkeyfile, "", logger);
            try {
                sshL.setupKey(node, this.sshpublickeyfile);
            }
            catch (IOException ce) {
                logger.finer("SSH key setup failed: " + ce.getMessage());
                throw new CommandException("SSH key setup failed: " + ce.getMessage());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!sshL.checkConnection()) continue;
            logger.finer("Connection SUCCEEDED!");
        }
        return 0;
    }
}

