/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.FailureDetection;
import com.sun.enterprise.config.serverbeans.GroupManagementService;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
public class GMSConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    private static final Logger logger = LogDomains.getLogger(GMSConfigUpgrade.class, (String)"javax.org.glassfish.gms");
    @Inject
    Clusters clusters;
    @Inject
    Configs configs;

    public void postConstruct() {
        this.upgradeClusterElements();
        this.upgradeGroupManagementServiceElements();
    }

    private void upgradeClusterElements() {
        try {
            List clusterList = this.clusters.getCluster();
            for (Cluster cl : clusterList) {
                ConfigSupport.apply((SingleConfigCode)new ClusterConfigCode(), (ConfigBeanProxy)cl);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "gmsupgrade.failed", e);
            throw new RuntimeException(e);
        }
    }

    private void upgradeGroupManagementServiceElements() {
        try {
            List lconfigs = this.configs.getConfig();
            for (Config c : lconfigs) {
                ConfigSupport.apply((SingleConfigCode)new GroupManagementServiceConfigCode(), (ConfigBeanProxy)c);
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "gmsupgrade.failed", t);
            throw new RuntimeException(t);
        }
    }

    private String generateHeartbeatPort() {
        long MIN_GMS_MULTICAST_PORT = 2048L;
        long MAX_GMS_MULTICAST_PORT = 32000L;
        long portInterval = 29952L;
        return new Long(Math.round(Math.random() * (double)portInterval) + 2048L).toString();
    }

    private String generateHeartbeatAddress() {
        int MAX_GMS_MULTICAST_ADDRESS_SUBRANGE = 255;
        StringBuffer heartbeatAddressBfr = new StringBuffer("228.9.");
        heartbeatAddressBfr.append(Math.round(Math.random() * 255.0)).append('.').append(Math.round(Math.random() * 255.0));
        return heartbeatAddressBfr.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroupManagementServiceConfigCode
    implements SingleConfigCode<Config> {
        private GroupManagementServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException, TransactionFailure {
            Property prop;
            GroupManagementService gms = config.getGroupManagementService();
            Transaction t = Transaction.getTransaction((ConfigBeanProxy)config);
            gms = (GroupManagementService)t.enroll((ConfigBeanProxy)gms);
            String value = gms.getPingProtocolTimeoutInMillis();
            if (value != null) {
                try {
                    gms.setGroupDiscoveryTimeoutInMillis(value);
                }
                catch (Throwable re) {
                    // empty catch block
                }
                gms.setPingProtocolTimeoutInMillis(null);
            }
            FailureDetection fd = gms.getFailureDetection();
            fd = (FailureDetection)t.enroll((ConfigBeanProxy)fd);
            value = gms.getFdProtocolTimeoutInMillis();
            if (value != null) {
                try {
                    fd.setHeartbeatFrequencyInMillis(value);
                }
                catch (Throwable re) {
                    // empty catch block
                }
                gms.setFdProtocolTimeoutInMillis(null);
            }
            if ((value = gms.getFdProtocolMaxTries()) != null) {
                try {
                    fd.setMaxMissedHeartbeats(value);
                }
                catch (Throwable re) {
                    // empty catch block
                }
                gms.setFdProtocolMaxTries(null);
            }
            if ((value = gms.getVsProtocolTimeoutInMillis()) != null) {
                try {
                    fd.setVerifyFailureWaittimeInMillis(value);
                }
                catch (Throwable re) {
                    // empty catch block
                }
                gms.setVsProtocolTimeoutInMillis(null);
            }
            if ((prop = gms.getProperty("failure-detection-tcp-retransmit-timeout")) != null && prop.getValue() != null) {
                try {
                    fd.setVerifyFailureConnectTimeoutInMillis(prop.getValue().trim());
                }
                catch (Throwable re) {
                    // empty catch block
                }
                List props = gms.getProperty();
                props.remove(prop);
            }
            if (gms.getMergeProtocolMinIntervalInMillis() != null) {
                gms.setMergeProtocolMinIntervalInMillis(null);
            }
            if (gms.getMergeProtocolMaxIntervalInMillis() != null) {
                gms.setMergeProtocolMaxIntervalInMillis(null);
            }
            return config;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClusterConfigCode
    implements SingleConfigCode<Cluster> {
        private ClusterConfigCode() {
        }

        public Object run(Cluster cluster) throws PropertyVetoException, TransactionFailure {
            Property prop;
            String value = cluster.getHeartbeatEnabled();
            if (value != null) {
                cluster.setGmsEnabled(value);
                cluster.setHeartbeatEnabled(null);
            }
            if ((value = cluster.getHeartbeatAddress()) != null) {
                try {
                    cluster.setGmsMulticastAddress(value);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                cluster.setHeartbeatAddress(null);
            }
            if (cluster.getGmsMulticastAddress() == null) {
                cluster.setGmsMulticastAddress(GMSConfigUpgrade.this.generateHeartbeatAddress());
            }
            if ((value = cluster.getHeartbeatPort()) != null) {
                try {
                    cluster.setGmsMulticastPort(value);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                cluster.setHeartbeatPort(null);
            }
            if (cluster.getGmsMulticastPort() == null) {
                cluster.setGmsMulticastPort(GMSConfigUpgrade.this.generateHeartbeatPort());
            }
            if ((prop = cluster.getProperty("gms-bind-interface-address")) != null && prop.getValue() != null) {
                cluster.setGmsBindInterfaceAddress(prop.getValue());
                List props = cluster.getProperty();
                props.remove(prop);
            } else {
                value = cluster.getGmsBindInterfaceAddress();
                if (value == null) {
                    cluster.setGmsBindInterfaceAddress(String.format("${GMS-BIND-INTERFACE-ADDRESS-%s}", cluster.getName()));
                }
            }
            return cluster;
        }
    }
}

