/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.cluster.Strings;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="setup-ssh")
@Scoped(value=PerLookup.class)
public final class SetupSshKey
extends CLICommand {
    @Param(optional=true)
    private String sshuser;
    @Param(optional=true)
    private int sshport;
    @Param(optional=true)
    private String sshkeyfile;
    @Param(optional=true)
    private String sshpublickeyfile;
    @Param(name="hosts", optional=false, primary=true, multiple=true)
    private String[] nodes;
    @Inject
    private Habitat habitat;
    private String sshpassword;
    private String sshkeypassphrase = null;
    private boolean generateKey = false;
    private boolean promptPass = false;

    protected void validate() throws CommandException {
        if (this.sshuser == null) {
            this.sshuser = System.getProperty("user.name");
        }
        if (this.sshport == 0) {
            this.sshport = 22;
        }
        if (this.sshkeyfile == null) {
            if (SSHUtil.getExistingKeyFile() == null) {
                this.sshkeyfile = SSHUtil.getDefaultKeyFile();
                if (this.promptForKeyGeneration() && this.programOpts.isInteractive()) {
                    this.generateKey = true;
                    this.sshkeypassphrase = this.getSSHPassphrase();
                }
            } else {
                this.promptPass = true;
            }
        } else {
            this.validateKeyFile(this.sshkeyfile);
        }
        if (this.sshpublickeyfile != null) {
            this.validateKeyFile(this.sshpublickeyfile);
        }
    }

    protected int executeCommand() throws CommandException {
        SSHLauncher sshL = (SSHLauncher)this.habitat.getComponent(SSHLauncher.class);
        Globals.setDefaultHabitat((Habitat)this.habitat);
        for (String node : this.nodes) {
            sshL.init(this.sshuser, node, this.sshport, this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
            if (this.generateKey || this.promptPass) {
                this.sshpassword = this.getSSHPassword();
            }
            try {
                sshL.setupKey(node, this.sshpublickeyfile, this.generateKey, this.sshpassword);
            }
            catch (IOException ce) {
                logger.fine("SSH key setup failed: " + ce.getMessage());
                throw new CommandException(Strings.get("KeySetupFailed", ce.getMessage()));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!sshL.checkConnection()) continue;
            logger.fine("Connection SUCCEEDED!");
        }
        return 0;
    }

    private void validateKeyFile(String file) {
        File f = new File(file);
        if (f.exists()) {
            this.promptPass = true;
        }
    }

    private String getSSHPassword() throws CommandException {
        String password = this.getFromPasswordFile("AS_ADMIN_SSH_PASSWORD");
        if (password == null) {
            if (this.programOpts.isInteractive()) {
                password = this.readSSHPassword(Strings.get("SSHPasswordPrompt"));
            } else {
                throw new CommandException(Strings.get("SSHPasswordNotFound"));
            }
        }
        return password;
    }

    private String getSSHPassphrase() throws CommandException {
        String passphrase = this.getFromPasswordFile("AS_ADMIN_SSH_KEYPASSPHRASE");
        if (passphrase == null) {
            passphrase = this.programOpts.isInteractive() ? this.readSSHPassword(Strings.get("SSHPassphrasePrompt")) : "";
        }
        return passphrase;
    }

    private String getFromPasswordFile(String name) throws CommandException {
        String pass = null;
        String pwfile = this.programOpts.getPasswordFile();
        if (SetupSshKey.ok((String)pwfile)) {
            this.passwords = CLIUtil.readPasswordFileOptions((String)pwfile, (boolean)true);
            logger.fine("Passwords from password file " + this.passwords);
            pass = (String)this.passwords.get(name);
        }
        return pass;
    }

    private boolean promptForKeyGeneration() {
        Console cons = System.console();
        if (cons != null) {
            String val = null;
            do {
                cons.printf("%s", Strings.get("GenerateKeyPairPrompt"));
                val = cons.readLine();
                if (val == null || !val.equalsIgnoreCase("yes") && !val.equalsIgnoreCase("y")) continue;
                logger.fine("Generate key!");
                return true;
            } while ((val == null || !val.equalsIgnoreCase("no") && !val.equalsIgnoreCase("n")) && val != null && !this.isValidAnswer(val));
        }
        return false;
    }

    private boolean isValidAnswer(String val) {
        return val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("no") || val.equalsIgnoreCase("y") || val.equalsIgnoreCase("n");
    }

    protected String readSSHPassword(String prompt) {
        String password = null;
        Console cons = System.console();
        if (cons != null) {
            char[] pc = cons.readPassword("%s", prompt);
            password = new String(pc);
        }
        return password;
    }
}

