/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.CopyConfig;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.GenericCrudCommand;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="copy-config")
@I18n(value="copy.config.command")
@Scoped(value=PerLookup.class)
public final class CopyConfigCommand
extends CopyConfig {
    @Inject
    ServerEnvironment env;
    @Inject
    ServerEnvironmentImpl envImpl;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CopyConfigCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        Object spb = null;
        if (this.configs.size() != 2) {
            report.setMessage(localStrings.getLocalString("Config.badConfigNames", "You must specify a source and destination config") + "\n" + localStrings.getLocalString("Config.copyConfigUsage", "Usage copy-config \\n[--systemproperties (name=value)[:name=value]*]\\nsource_configuration_name destination_configuration_name"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        String srcConfig = (String)this.configs.get(0);
        String destConfig = (String)this.configs.get(1);
        final Config config = this.domain.getConfigNamed(srcConfig);
        if (config == null) {
            report.setMessage(localStrings.getLocalString("Config.noSuchConfig", "Config {0} does not exist.", new Object[]{srcConfig}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Config destinationConfig = this.domain.getConfigNamed(destConfig);
        if (destinationConfig != null) {
            report.setMessage(localStrings.getLocalString("Config.configExists", "Config {0} already exists.", new Object[]{destConfig}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        final String configName = destConfig;
        try {
            Config newCopy = (Config)ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Configs>(){

                public Object run(Configs configs) throws PropertyVetoException, TransactionFailure {
                    Config destCopy = (Config)config.deepCopy((ConfigBeanProxy)configs);
                    if (CopyConfigCommand.this.systemproperties != null) {
                        Properties properties = GenericCrudCommand.convertStringToProperties((String)CopyConfigCommand.this.systemproperties, (char)':');
                        for (Object key : properties.keySet()) {
                            String propName = (String)key;
                            List sysprops = destCopy.getSystemProperty();
                            for (SystemProperty sysprop : sysprops) {
                                if (!propName.equals(sysprop.getName())) continue;
                                sysprops.remove(sysprop);
                                break;
                            }
                            SystemProperty newSysProp = (SystemProperty)destCopy.createChild(SystemProperty.class);
                            newSysProp.setName(propName);
                            newSysProp.setValue(properties.getProperty(propName));
                            destCopy.getSystemProperty().add(newSysProp);
                        }
                    }
                    destCopy.setName(configName);
                    configs.getConfig().add(destCopy);
                    CopyConfigCommand.this.copyOfConfig = destCopy;
                    return destCopy;
                }
            }, (ConfigBeanProxy)this.domain.getConfigs());
            Logger logger = context.getLogger();
            try {
                File configConfigDir = new File(this.env.getConfigDirPath(), configName);
                new File(configConfigDir, "docroot").mkdirs();
                new File(configConfigDir, "lib/ext").mkdirs();
                String rootFolder = (String)this.envImpl.getProps().get("com.sun.aas.installRoot");
                String templateDir = rootFolder + File.separator + "lib" + File.separator + "templates";
                File src = new File(templateDir, "logging.properties");
                File dest = new File(configConfigDir, "logging.properties");
                FileUtils.copy((File)src, (File)dest);
            }
            catch (Exception e) {
                logger.warning(localStrings.getLocalString("Config.copyConfigError", "CopyConfig error") + "  " + e.getLocalizedMessage());
            }
        }
        catch (TransactionFailure e) {
            e.printStackTrace();
            report.setMessage(localStrings.getLocalString("Config.copyConfigError", "CopyConfig error") + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

