/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.LoadBalancer;
import com.sun.enterprise.config.serverbeans.LoadBalancers;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.glassfish.loadbalancer.admin.cli.ConfigureLBWeightCommand;
import org.glassfish.loadbalancer.admin.cli.CreateHTTPLBRefCommand;
import org.glassfish.loadbalancer.admin.cli.LBCommandsBase;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="create-http-lb")
@Scoped(value=PerLookup.class)
@I18n(value="create.http.lb")
@TargetType(value={CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@ExecuteOn(value={RuntimeType.DAS})
public final class CreateHTTPLoadBalancerCommand
extends LBCommandsBase
implements AdminCommand {
    @Param(optional=false)
    String devicehost;
    @Param(optional=false)
    String deviceport;
    @Param(optional=true)
    String target;
    @Param(optional=true)
    String sslproxyhost;
    @Param(optional=true)
    String sslproxyport;
    @Param(optional=true)
    String lbpolicy;
    @Param(optional=true)
    String lbpolicymodule;
    @Param(optional=true, defaultValue="/")
    String healthcheckerurl;
    @Param(optional=true, defaultValue="30")
    String healthcheckerinterval;
    @Param(optional=true, defaultValue="10")
    String healthcheckertimeout;
    @Param(optional=true)
    String lbenableallinstances;
    @Param(optional=true)
    String lbenableallapplications;
    @Param(optional=true)
    String lbweight;
    @Param(optional=true, defaultValue="60")
    String responsetimeout;
    @Param(optional=true, defaultValue="false")
    Boolean httpsrouting;
    @Param(optional=true, defaultValue="60")
    String reloadinterval;
    @Param(optional=true, defaultValue="false")
    Boolean monitor;
    @Param(optional=true, defaultValue="true")
    Boolean routecookie;
    @Param(obsolete=true, optional=true)
    Boolean autoapplyenabled;
    @Param(optional=true, name="property", separator=58)
    Properties properties;
    @Param(primary=true)
    String load_balancer_name;
    @Inject
    Target tgt;
    @Inject
    Logger logger;
    @Inject
    CommandRunner runner;
    @Inject
    Applications applications;
    private ActionReport report;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateHTTPLoadBalancerCommand.class);

    public void execute(AdminCommandContext context) {
        String msg;
        LBCommandsBase command;
        this.report = context.getActionReport();
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (this.load_balancer_name == null) {
            String msg2 = localStrings.getLocalString("NullLBName", "Load balancer name cannot be null");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg2);
            return;
        }
        if (this.domain.getLoadBalancers().getLoadBalancer(this.load_balancer_name) != null) {
            String msg3 = localStrings.getLocalString("LBExists", "Load balancer {0} already exists", new Object[]{this.load_balancer_name});
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg3);
            return;
        }
        if (this.target != null && !this.tgt.isValid(this.target)) {
            String msg4 = localStrings.getLocalString("InvalidTarget", "Invalid target", new Object[]{this.target});
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg4);
            return;
        }
        boolean isCluster = this.tgt.isCluster(this.target);
        String lbConfigName = this.load_balancer_name + "_LB_CONFIG";
        if (!(isCluster || this.lbpolicy == null && this.lbpolicymodule == null)) {
            String msg5 = localStrings.getLocalString("NotCluster", "{0} not a cluster", new Object[]{this.target});
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg5);
            return;
        }
        try {
            this.createLBConfig(lbConfigName);
            if (this.target != null) {
                command = (CreateHTTPLBRefCommand)this.runner.getCommand("create-http-lb-ref", this.report, context.getLogger());
                ((CreateHTTPLBRefCommand)command).target = this.target;
                ((CreateHTTPLBRefCommand)command).config = lbConfigName;
                ((CreateHTTPLBRefCommand)command).lbpolicy = this.lbpolicy;
                ((CreateHTTPLBRefCommand)command).lbpolicymodule = this.lbpolicymodule;
                ((CreateHTTPLBRefCommand)command).healthcheckerurl = this.healthcheckerurl;
                ((CreateHTTPLBRefCommand)command).healthcheckerinterval = this.healthcheckerinterval;
                ((CreateHTTPLBRefCommand)command).healthcheckertimeout = this.healthcheckertimeout;
                ((CreateHTTPLBRefCommand)command).lbenableallinstances = this.lbenableallinstances;
                ((CreateHTTPLBRefCommand)command).lbenableallapplications = this.lbenableallapplications;
                ((CreateHTTPLBRefCommand)command).lbweight = this.lbweight;
                ((CreateHTTPLBRefCommand)command).execute(context);
                this.checkCommandStatus(context);
            }
        }
        catch (CommandException e) {
            msg = e.getLocalizedMessage();
            this.logger.warning(msg);
        }
        this.addLoadBalancer(lbConfigName);
        if (isCluster && this.lbweight != null) {
            try {
                command = (ConfigureLBWeightCommand)this.runner.getCommand("configure-lb-weight", this.report, context.getLogger());
                ((ConfigureLBWeightCommand)command).weights = this.lbweight;
                ((ConfigureLBWeightCommand)command).cluster = this.target;
                ((ConfigureLBWeightCommand)command).execute(context);
                this.checkCommandStatus(context);
            }
            catch (CommandException e) {
                msg = e.getLocalizedMessage();
                this.logger.warning(msg);
            }
        }
    }

    private void createLBConfig(String config) throws CommandException {
        CommandRunner.CommandInvocation ci = this.runner.getCommandInvocation("create-http-lb-config", this.report);
        ParameterMap map = new ParameterMap();
        map.add((Object)"responsetimeout", (Object)this.responsetimeout);
        map.add((Object)"httpsrouting", this.httpsrouting == null ? null : this.httpsrouting.toString());
        map.add((Object)"reloadinterval", (Object)this.reloadinterval);
        map.add((Object)"monitor", this.monitor == null ? null : this.monitor.toString());
        map.add((Object)"routecookie", this.routecookie == null ? null : this.routecookie.toString());
        map.add((Object)"config_name", (Object)config);
        ci.parameters(map);
        ci.execute();
    }

    private void addLoadBalancer(final String lbConfigName) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<LoadBalancers>(){

                public Object run(LoadBalancers param) throws PropertyVetoException, TransactionFailure {
                    Property newprop;
                    LoadBalancer lb = (LoadBalancer)param.createChild(LoadBalancer.class);
                    lb.setDeviceHost(CreateHTTPLoadBalancerCommand.this.devicehost);
                    lb.setDevicePort(CreateHTTPLoadBalancerCommand.this.deviceport);
                    lb.setLbConfigName(lbConfigName);
                    lb.setName(CreateHTTPLoadBalancerCommand.this.load_balancer_name);
                    if (CreateHTTPLoadBalancerCommand.this.properties != null) {
                        for (Object propname : CreateHTTPLoadBalancerCommand.this.properties.keySet()) {
                            Property newprop2 = (Property)lb.createChild(Property.class);
                            newprop2.setName((String)propname);
                            newprop2.setValue(CreateHTTPLoadBalancerCommand.this.properties.getProperty((String)propname));
                            lb.getProperty().add(newprop2);
                        }
                    }
                    if (CreateHTTPLoadBalancerCommand.this.sslproxyhost != null) {
                        newprop = (Property)lb.createChild(Property.class);
                        newprop.setName("ssl-proxy-host");
                        newprop.setValue(CreateHTTPLoadBalancerCommand.this.sslproxyhost);
                        lb.getProperty().add(newprop);
                    }
                    if (CreateHTTPLoadBalancerCommand.this.sslproxyport != null) {
                        newprop = (Property)lb.createChild(Property.class);
                        newprop.setName("ssl-proxy-port");
                        newprop.setValue(CreateHTTPLoadBalancerCommand.this.sslproxyport);
                        lb.getProperty().add(newprop);
                    }
                    param.getLoadBalancer().add(lb);
                    return Boolean.TRUE;
                }
            }, (ConfigBeanProxy)this.domain.getLoadBalancers());
        }
        catch (TransactionFailure ex) {
            String msg = localStrings.getLocalString("FailedToUpdateLB", "Failed to update load-balancers");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
    }
}

