/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.LoadBalancer;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.loadbalancer.admin.cli.LbLogUtil;
import org.glassfish.loadbalancer.admin.cli.helper.LbConfigHelper;
import org.glassfish.loadbalancer.admin.cli.reader.api.LoadbalancerReader;
import org.glassfish.loadbalancer.admin.cli.reader.impl.LoadbalancerReaderImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="export-http-lb-config")
@Scoped(value=PerLookup.class)
@I18n(value="export.http.lb.config")
public class ExportHttpLbConfig
implements AdminCommand {
    @Param(name="lbtargets", separator=44, optional=true)
    List<String> target;
    @Param(name="config", optional=true)
    String lbConfigName;
    @Param(name="lbname", optional=true)
    String lbName;
    @Param(name="file_name", optional=true, primary=true)
    String fileName;
    @Param(name="property", optional=true, separator=58)
    Properties properties;
    @Inject
    Domain domain;
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    ServerEnvironment env;
    private static final String DEFAULT_LB_XML_FILE_NAME = "loadbalancer.xml";

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            String msg = this.process();
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage(msg);
        }
        catch (Throwable t) {
            String msg = LbLogUtil.getStringManager().getString("ExportHttpLbConfigFailed", (Object)t.getMessage());
            LbLogUtil.getLogger().log(Level.WARNING, msg);
            if (LbLogUtil.getLogger().isLoggable(Level.FINE)) {
                LbLogUtil.getLogger().log(Level.FINE, "Exception when exporting http lb config", t);
            }
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(t.getMessage());
            report.setFailureCause(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process() throws Exception {
        String msg;
        File f;
        LoadbalancerReader lbr = null;
        if (this.lbName != null && this.lbConfigName == null && this.target == null) {
            LoadBalancer lb = LbConfigHelper.getLoadBalancer(this.domain, this.lbName);
            lbr = LbConfigHelper.getLbReader(this.domain, this.appRegistry, lb.getLbConfigName());
        } else if (this.lbConfigName != null && this.lbName == null && this.target == null) {
            lbr = LbConfigHelper.getLbReader(this.domain, this.appRegistry, this.lbConfigName);
        } else if (this.target != null && this.lbName == null && this.lbConfigName == null) {
            HashSet<String> clusters = new HashSet<String>();
            clusters.addAll(this.target);
            lbr = new LoadbalancerReaderImpl(this.domain, this.appRegistry, clusters, this.properties);
        } else {
            String msg2 = LbLogUtil.getStringManager().getString("ExportHttpLbConfigInvalidArgs");
            throw new Exception(msg2);
        }
        if (this.fileName == null) {
            String configName = lbr.getName();
            this.fileName = configName != null ? "loadbalancer.xml." + configName : DEFAULT_LB_XML_FILE_NAME;
        }
        if (!(f = new File(this.fileName)).isAbsolute()) {
            File generatedDir = this.env.getApplicationStubPath();
            f = new File(generatedDir, this.fileName);
        }
        if (f.exists()) {
            msg = LbLogUtil.getStringManager().getString("FileExists", (Object)f.getPath());
            throw new Exception(msg);
        }
        if (!f.getParentFile().exists()) {
            msg = LbLogUtil.getStringManager().getString("ParentFileMissing", (Object)f.getParent());
            throw new Exception(msg);
        }
        FileOutputStream fo = null;
        try {
            String msg3;
            if (!f.exists()) {
                f.createNewFile();
            }
            fo = new FileOutputStream(f);
            LbConfigHelper.exportXml(lbr, fo);
            String string = msg3 = LbLogUtil.getStringManager().getString("GeneratedFileLocation", (Object)f.getAbsolutePath());
            return string;
        }
        finally {
            if (fo != null) {
                fo.close();
                fo = null;
            }
        }
    }
}

