/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.connect;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.SystemPropertyConstants;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.admin.SSHCommandExecutionException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeRunner {
    private static final String NL = System.getProperty("line.separator");
    private Habitat habitat;
    private Logger logger;
    private String lastCommandRun = null;
    private int commandStatus;
    private SSHLauncher sshL = null;

    public NodeRunner(Habitat habitat, Logger logger) {
        this.logger = logger;
        this.habitat = habitat;
    }

    public String getLastCommandRun() {
        return this.lastCommandRun;
    }

    public boolean isSshNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (node.getType() == null) {
            return false;
        }
        return node.getType().equals("SSH");
    }

    public int runAdminCommandOnNode(Node node, StringBuilder output, List<String> args) throws SSHCommandExecutionException, ProcessManagerException, UnsupportedOperationException, IllegalArgumentException {
        return this.runAdminCommandOnNode(node, output, false, args);
    }

    public int runAdminCommandOnNode(Node node, StringBuilder output, boolean waitForReaderThreads, List<String> args) throws SSHCommandExecutionException, ProcessManagerException, UnsupportedOperationException, IllegalArgumentException {
        if (node.isLocal()) {
            return this.runAdminCommandOnLocalNode(node, output, waitForReaderThreads, args);
        }
        return this.runAdminCommandOnRemoteNode(node, output, args);
    }

    private int runAdminCommandOnLocalNode(Node node, StringBuilder output, boolean waitForReaderThreads, List<String> args) throws ProcessManagerException {
        ArrayList<String> fullcommand = new ArrayList<String>();
        String installDir = node.getInstallDirUnixStyle();
        if (!StringUtils.ok((String)installDir)) {
            throw new IllegalArgumentException("Node does not have an installDir");
        }
        File asadmin = new File(SystemPropertyConstants.getAsAdminScriptLocation((String)installDir));
        fullcommand.add(asadmin.getAbsolutePath());
        fullcommand.addAll(args);
        if (!asadmin.canExecute()) {
            throw new ProcessManagerException("asadmin is not executable!");
        }
        this.lastCommandRun = this.commandListToString(fullcommand);
        this.trace("Running command locally: " + this.lastCommandRun);
        ProcessManager pm = new ProcessManager(fullcommand);
        pm.waitForReaderThreads(waitForReaderThreads);
        pm.execute();
        String stdout = pm.getStdout();
        String stderr = pm.getStderr();
        if (output != null) {
            if (StringUtils.ok((String)stdout)) {
                output.append(stdout);
            }
            if (StringUtils.ok((String)stderr)) {
                if (output.length() > 0) {
                    output.append(NL);
                }
                output.append(stderr);
            }
        }
        return pm.getExitValue();
    }

    private int runAdminCommandOnRemoteNode(Node node, StringBuilder output, List<String> args) throws SSHCommandExecutionException, IllegalArgumentException, UnsupportedOperationException {
        if (!this.isSshNode(node)) {
            throw new UnsupportedOperationException("Node is not of type SSH");
        }
        String installDir = node.getInstallDirUnixStyle();
        if (!StringUtils.ok((String)installDir)) {
            throw new IllegalArgumentException("Node does not have an installDir");
        }
        installDir = this.encodeSpaces(installDir);
        ArrayList<String> fullcommand = new ArrayList<String>();
        fullcommand.add(installDir + "/bin/asadmin");
        fullcommand.addAll(args);
        try {
            this.lastCommandRun = this.commandListToString(fullcommand);
            this.trace("Running command on " + node.getNodeHost() + ": " + this.lastCommandRun);
            this.sshL = (SSHLauncher)this.habitat.getComponent(SSHLauncher.class);
            this.sshL.init(node, this.logger);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            this.commandStatus = this.sshL.runCommand(this.lastCommandRun, outStream);
            String results = outStream.toString();
            output.append(outStream.toString());
            return this.commandStatus;
        }
        catch (IOException ex) {
            String m1 = " Command execution failed. " + ex.getMessage();
            String m2 = "";
            Throwable e2 = ex.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            this.logger.severe("Command execution failed for " + this.lastCommandRun);
            SSHCommandExecutionException cee = new SSHCommandExecutionException(StringUtils.cat((String)":", (String[])new String[]{m1}));
            cee.setSSHSettings(this.sshL.toString());
            cee.setCommandRun(this.lastCommandRun);
            throw cee;
        }
        catch (InterruptedException ei) {
            ei.printStackTrace();
            String m1 = ei.getMessage();
            String m2 = "";
            Throwable e2 = ei.getCause();
            if (e2 != null) {
                m2 = e2.getMessage();
            }
            this.logger.severe("Command interrupted " + this.lastCommandRun);
            SSHCommandExecutionException cee = new SSHCommandExecutionException(StringUtils.cat((String)":", (String[])new String[]{m1, m2}));
            cee.setSSHSettings(this.sshL.toString());
            cee.setCommandRun(this.lastCommandRun);
            throw cee;
        }
    }

    private void trace(String s) {
        this.logger.fine(String.format("%s: %s", this.getClass().getSimpleName(), s));
    }

    private String encodeSpaces(String s) {
        return s.replaceAll(" ", "\\\\ ");
    }

    private String commandListToString(List<String> command) {
        StringBuilder fullCommand = new StringBuilder();
        for (String s : command) {
            fullCommand.append(" ");
            fullCommand.append(s);
        }
        return fullCommand.toString();
    }
}

