/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.util.io.FileListerRelative;
import com.sun.enterprise.util.zip.ZipFileException;
import com.sun.enterprise.util.zip.ZipWriter;
import com.trilead.ssh2.SCPClient;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="install-node")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public class InstallNodeCommand
extends CLICommand {
    @Param(optional=true)
    private String sshuser;
    @Param(optional=true)
    private int sshport;
    @Param(optional=true)
    private String sshkeyfile;
    @Param(name="archivedir", optional=true)
    private String archiveDir;
    @Param(optional=false, primary=true, multiple=true)
    private String[] hosts;
    @Param(name="install-location", optional=true)
    private String installLocation;
    private String sshpassword;
    private String sshkeypassphrase = null;
    private boolean promptPass = false;
    @Inject
    SSHLauncher sshLauncher;

    protected void validate() throws CommandException {
    }

    protected int executeCommand() throws CommandException {
        try {
            String baseRootValue = this.executeLocationsCommand();
            ArrayList<String> binDirFiles = new ArrayList<String>();
            File zipFile = this.createZipFile(baseRootValue, binDirFiles);
            this.copyToHosts(zipFile, baseRootValue, binDirFiles);
        }
        catch (IOException ioe) {
            throw new CommandException((Throwable)ioe);
        }
        catch (ZipFileException ze) {
            throw new CommandException((Throwable)ze);
        }
        catch (InterruptedException e) {
            throw new CommandException((Throwable)e);
        }
        return 0;
    }

    private void copyToHosts(File zipFile, String baseRootValue, ArrayList<String> binDirFiles) throws IOException, InterruptedException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        if (this.installLocation == null) {
            this.installLocation = baseRootValue;
        }
        for (String host : this.hosts) {
            this.sshLauncher.init(this.sshuser, host, this.sshport, this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
            String remoteDir = this.installLocation + "/glassfishv3/glassfish";
            SFTPClient sftpClient = this.sshLauncher.getSFTPClient();
            SCPClient scpClient = this.sshLauncher.getSCPClient();
            if (!sftpClient.exists(remoteDir)) {
                sftpClient.mkdirs(remoteDir, 493);
            }
            scpClient.put(zipFile.getAbsolutePath(), remoteDir);
            String unzipCommand = "cd " + remoteDir + "; jar -xvf glassfish.zip";
            this.sshLauncher.runCommand(unzipCommand, (OutputStream)outStream);
            sftpClient.rm(remoteDir + "/glassfish.zip");
            for (String binDirFile : binDirFiles) {
                sftpClient.chmod(remoteDir + "/" + binDirFile, 493);
            }
        }
    }

    private String executeLocationsCommand() throws CommandException {
        RemoteCommand cmd = new RemoteCommand("__locations", this.programOpts, this.env);
        Map attrs = cmd.executeAndReturnAttributes(new String[]{"__locations"});
        return (String)attrs.get("Base-Root_value");
    }

    private File createZipFile(String baseRootValue, ArrayList<String> binDirFiles) throws IOException, ZipFileException {
        File installRoot = new File(baseRootValue);
        File zipFileLocation = null;
        if (this.archiveDir != null) {
            zipFileLocation = new File(this.archiveDir);
            if (!zipFileLocation.canWrite()) {
                throw new IOException("Cannot write to " + this.archiveDir);
            }
        } else {
            zipFileLocation = installRoot.canWrite() ? installRoot : new File(System.getProperty("java.io.tmpdir"));
        }
        FileListerRelative lister = new FileListerRelative(installRoot);
        lister.keepEmptyDirectories();
        String[] files = lister.getFiles();
        List<String> resultFiles1 = Arrays.asList(files);
        ArrayList<String> resultFiles = new ArrayList<String>(resultFiles1);
        Iterator<String> iter = resultFiles.iterator();
        while (iter.hasNext()) {
            String fileName = iter.next();
            if (fileName.contains("domains") || fileName.contains("nodes")) {
                iter.remove();
                continue;
            }
            if (!fileName.startsWith("bin")) continue;
            binDirFiles.add(fileName);
        }
        File glassFishZipFile = new File(zipFileLocation, "glassfish.zip");
        if (glassFishZipFile.exists()) {
            return glassFishZipFile;
        }
        String[] filesToZip = new String[resultFiles.size()];
        filesToZip = resultFiles.toArray(filesToZip);
        ZipWriter writer = new ZipWriter(glassFishZipFile.getCanonicalPath(), installRoot.toString(), filesToZip);
        writer.safeWrite();
        return glassFishZipFile;
    }
}

