/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.cluster.Strings;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="setup-ssh")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public final class SetupSshKey
extends CLICommand {
    @Param(optional=true)
    private String sshuser;
    @Param(optional=true, defaultValue="22")
    private int sshport;
    @Param(optional=true)
    private String sshkeyfile;
    @Param(optional=true)
    private String sshpublickeyfile;
    @Param(optional=true, defaultValue="false")
    private boolean generatekey;
    @Param(name="hosts", optional=false, primary=true, multiple=true)
    private String[] nodes;
    @Inject
    private Habitat habitat;
    private String sshpassword;
    private String sshkeypassphrase = null;
    private boolean promptPass = false;

    protected void validate() throws CommandException {
        if (this.sshuser == null) {
            this.sshuser = System.getProperty("user.name");
        }
        if (this.sshkeyfile == null) {
            if (SSHUtil.getExistingKeyFile() == null) {
                this.sshkeyfile = SSHUtil.getDefaultKeyFile();
                if (this.promptForKeyGeneration()) {
                    this.generatekey = true;
                    this.sshkeypassphrase = this.getSSHPassphrase();
                }
            } else {
                this.promptPass = true;
            }
        } else {
            this.validateKeyFile(this.sshkeyfile);
        }
        if (this.sshpublickeyfile != null) {
            this.validateKeyFile(this.sshpublickeyfile);
        }
    }

    protected int executeCommand() throws CommandException {
        SSHLauncher sshL = (SSHLauncher)this.habitat.getComponent(SSHLauncher.class);
        Globals.setDefaultHabitat((Habitat)this.habitat);
        for (String node : this.nodes) {
            sshL.init(this.sshuser, node, this.sshport, this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
            if (this.generatekey || this.promptPass) {
                if ((this.sshkeyfile != null || SSHUtil.getExistingKeyFile() != null) && sshL.checkConnection()) {
                    throw new CommandException(Strings.get("SSHAlreadySetup", this.sshuser, node));
                }
                this.sshpassword = this.getSSHPassword();
            }
            try {
                sshL.setupKey(node, this.sshpublickeyfile, this.generatekey, this.sshpassword);
            }
            catch (IOException ce) {
                throw new CommandException(Strings.get("KeySetupFailed", ce.getMessage()));
            }
            catch (Exception e) {
                // empty catch block
            }
            sshL.checkConnection();
        }
        return 0;
    }

    private void validateKeyFile(String file) throws CommandException {
        File f = new File(file);
        if (!f.exists()) {
            throw new CommandException(Strings.get("KeyDoesNotExist", file));
        }
        this.promptPass = true;
    }

    private String getSSHPassword() throws CommandException {
        String password = this.getFromPasswordFile("AS_ADMIN_SSH_PASSWORD");
        if (password == null) {
            if (this.programOpts.isInteractive()) {
                password = this.readSSHPassword(Strings.get("SSHPasswordPrompt"));
            } else {
                throw new CommandException(Strings.get("SSHPasswordNotFound"));
            }
        }
        return password;
    }

    private String getSSHPassphrase() throws CommandException {
        String passphrase = this.getFromPasswordFile("AS_ADMIN_SSH_KEYPASSPHRASE");
        if (passphrase == null) {
            passphrase = this.programOpts.isInteractive() ? this.readSSHPassword(Strings.get("SSHPassphrasePrompt")) : "";
        }
        return passphrase;
    }

    private String getFromPasswordFile(String name) throws CommandException {
        String pass = null;
        String pwfile = this.programOpts.getPasswordFile();
        if (SetupSshKey.ok((String)pwfile)) {
            this.passwords = CLIUtil.readPasswordFileOptions((String)pwfile, (boolean)true);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Passwords from password file " + this.passwords);
            }
            pass = (String)this.passwords.get(name);
        }
        return pass;
    }

    private boolean promptForKeyGeneration() {
        if (this.generatekey) {
            return true;
        }
        if (!this.programOpts.isInteractive()) {
            return false;
        }
        Console cons = System.console();
        if (cons != null) {
            String val = null;
            do {
                cons.printf("%s", Strings.get("GenerateKeyPairPrompt", this.sshuser, Arrays.toString(this.nodes)));
                val = cons.readLine();
                if (val == null || !val.equalsIgnoreCase("yes") && !val.equalsIgnoreCase("y")) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Generate key!");
                }
                return true;
            } while ((val == null || !val.equalsIgnoreCase("no") && !val.equalsIgnoreCase("n")) && val != null && !this.isValidAnswer(val));
        }
        return false;
    }

    private boolean isValidAnswer(String val) {
        return val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("no") || val.equalsIgnoreCase("y") || val.equalsIgnoreCase("n");
    }

    protected String readSSHPassword(String prompt) {
        String password = null;
        Console cons = System.console();
        if (cons != null) {
            char[] pc = cons.readPassword("%s", prompt);
            password = new String(pc);
        }
        return password;
    }
}

