/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cluster;

import com.sun.enterprise.admin.util.ColumnFormatter;
import com.sun.enterprise.admin.util.InstanceCommandExecutor;
import com.sun.enterprise.admin.util.InstanceStateService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.universal.Duration;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.cluster.Strings;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.InstanceCommand;
import org.glassfish.api.admin.InstanceCommandResult;
import org.glassfish.api.admin.InstanceState;
import org.glassfish.api.admin.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InstanceInfo {
    private final String host;
    private final int port;
    private final String name;
    private long uptime = -1L;
    private String state = null;
    private final String cluster;
    private final Logger logger;
    private final int timeoutInMsec;
    private Future<InstanceCommandResult> future;
    private final ActionReport report;
    private final InstanceStateService stateService;
    private final Server svr;
    private boolean running;
    private static final String NOT_RUNNING = Strings.get("ListInstances.NotRunning");
    private static final String NAME = Strings.get("ListInstances.name");
    private static final String HOST = Strings.get("ListInstances.host");
    private static final String PORT = Strings.get("ListInstances.port");
    private static final String STATE = Strings.get("ListInstances.state");
    private static final String CLUSTER = Strings.get("ListInstances.cluster");
    private static final String NO_CLUSTER = "---";

    public InstanceInfo(Server svr, int port0, String host0, String cluster0, Logger logger0, int timeout0, ActionReport report, InstanceStateService stateService) {
        if (svr == null || host0 == null) {
            throw new NullPointerException("null arguments");
        }
        this.svr = svr;
        this.name = svr.getName();
        this.port = port0;
        this.host = host0;
        this.logger = logger0;
        this.timeoutInMsec = timeout0;
        this.report = report;
        this.stateService = stateService;
        this.cluster = !StringUtils.ok((String)cluster0) ? null : cluster0;
        this.future = this.pingInstance();
    }

    public final String toString() {
        String cl = "";
        if (this.cluster != null) {
            cl = ", cluster: " + this.getCluster();
        }
        return "name: " + this.getName() + ", host: " + this.getHost() + ", port: " + this.getPort() + cl + ", uptime: " + this.uptime;
    }

    public final String getDisplayCluster() {
        return this.cluster == null ? NO_CLUSTER : this.cluster;
    }

    public final String getCluster() {
        return this.cluster;
    }

    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public final String getName() {
        return this.name;
    }

    public final long getUptime() {
        if (this.uptime == -1L) {
            this.getFutureResult();
        }
        return this.uptime;
    }

    public final String getDisplayState() {
        InstanceState.StateType istate;
        String display = this.isRunning() ? InstanceState.StateType.RUNNING.getDisplayString() : InstanceState.StateType.NOT_RUNNING.getDisplayString();
        List failedCmds = this.stateService.getFailedCommands(this.name);
        InstanceState.StateType stateType = istate = this.isRunning() ? this.stateService.setState(this.name, InstanceState.StateType.RUNNING, false) : this.stateService.setState(this.name, InstanceState.StateType.NOT_RUNNING, false);
        if (istate == InstanceState.StateType.RESTART_REQUIRED) {
            if (this.isRunning()) {
                display = display + "; " + InstanceState.StateType.RESTART_REQUIRED.getDisplayString();
            }
            String list = "";
            for (String z : failedCmds) {
                list = list + z + "; ";
            }
            display = display + " [pending config changes are: " + list + "]";
        }
        return display;
    }

    public final String getState() {
        if (this.state == null) {
            this.getFutureResult();
        }
        return this.state;
    }

    public final boolean isRunning() {
        if (this.state == null) {
            this.getFutureResult();
        }
        return this.running;
    }

    private void getFutureResult() {
        try {
            InstanceCommandResult r = this.future.get(this.timeoutInMsec, TimeUnit.SECONDS);
            InstanceCommandExecutor res = (InstanceCommandExecutor)r.getInstanceCommand();
            String instanceLocation = res.getCommandOutput();
            String string = instanceLocation = instanceLocation == null ? "" : instanceLocation.trim();
            if (!instanceLocation.endsWith(res.getServer().getName()) || res.getReport().getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                this.uptime = -1L;
                this.state = NOT_RUNNING;
                this.running = false;
            } else {
                String uptimeStr = res.getReport().getTopMessagePart().getProps().getProperty("Uptime");
                this.uptime = new Long(uptimeStr);
                this.state = this.formatTime(this.uptime);
                this.running = true;
            }
        }
        catch (Exception e) {
            this.uptime = -1L;
            this.state = NOT_RUNNING;
            this.running = false;
        }
    }

    public static String format(List<InstanceInfo> infos) {
        String[] headings = new String[]{NAME, HOST, PORT, CLUSTER, STATE};
        ColumnFormatter cf = new ColumnFormatter(headings);
        for (InstanceInfo info : infos) {
            cf.addRow(new Object[]{info.getName(), info.getHost(), info.getPort(), info.getDisplayCluster(), info.getDisplayState()});
        }
        return cf.toString();
    }

    public static String formatBrief(List<InstanceInfo> infos) {
        ColumnFormatter cf = new ColumnFormatter();
        for (InstanceInfo info : infos) {
            cf.addRow(new Object[]{info.getName(), info.getDisplayState()});
        }
        return cf.toString();
    }

    private Future<InstanceCommandResult> pingInstance() {
        try {
            ActionReport aReport = this.report.addSubActionsReport();
            InstanceCommandResult aResult = new InstanceCommandResult();
            ParameterMap map = new ParameterMap();
            map.set((Object)"type", (Object)"terse");
            InstanceCommandExecutor ice = new InstanceCommandExecutor("__locations", FailurePolicy.Error, FailurePolicy.Error, this.svr, this.host, this.port, this.logger, map, aReport, aResult);
            return this.stateService.submitJob(this.svr, (InstanceCommand)ice, aResult);
        }
        catch (CommandException ex) {
            this.running = false;
            return null;
        }
    }

    private String formatTime(long uptime) {
        return Strings.get("instanceinfo.uptime", new Duration(uptime));
    }
}

