/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms.admin;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.gms.admin.GMSAnnounceSupplementalInfo;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.GMSAdapterService;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="_gmsAnnounceBeforeStartClusterCommand")
@Supplemental(value="start-cluster", on=Supplemental.Timing.Before, ifFailure=FailurePolicy.Warn)
@Scoped(value=PerLookup.class)
public class GMSAnnounceBeforeStartClusterCommand
implements AdminCommand {
    private static final Logger logger = LogDomains.getLogger(GMSAnnounceBeforeStartClusterCommand.class, (String)"javax.org.glassfish.gms");
    @Inject
    private ServerEnvironment env;
    @Inject
    private Habitat habitat;
    @Param(optional=false, primary=true)
    private String clusterName;
    @Inject
    private Domain domain;
    @Inject
    private CommandRunner runner;
    @Param(optional=true, defaultValue="false")
    private boolean verbose;
    @Inject
    GMSAdapterService gmsAdapterService;
    private GroupManagementService gms = null;
    private boolean gmsStartCluster = false;
    private List<String> clusterMembers = EMPTY_LIST;
    private GMSAdapter gmsadapter = null;
    private static final List<String> EMPTY_LIST = new LinkedList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            if (this.gmsAdapterService.isGmsEnabled()) {
                this.gmsadapter = this.gmsAdapterService.getGMSAdapterByName(this.clusterName);
                if (this.gmsadapter != null) {
                    this.gms = this.gmsadapter.getModule();
                    if (this.gms != null) {
                        List startedGMSMembers;
                        this.clusterMembers = this.getClusterMembers();
                        if (this.clusterMembers != null && this.clusterMembers.size() > 0 && (startedGMSMembers = this.gms.getGroupHandle().getCurrentCoreMembers()).size() == 0) {
                            try {
                                this.gms.announceGroupStartup(this.clusterName, GMSConstants.groupStartupState.INITIATED, this.clusterMembers);
                                this.gmsStartCluster = true;
                            }
                            catch (Throwable t) {
                                logger.log(Level.WARNING, "cluster.start.exception", t.getLocalizedMessage());
                            }
                        }
                    }
                }
            }
        }
        finally {
            if (this.gms != null) {
                GMSAnnounceSupplementalInfo result = new GMSAnnounceSupplementalInfo(this.clusterMembers, this.gmsStartCluster, this.gmsadapter);
                report.setResultType(GMSAnnounceSupplementalInfo.class, (Object)result);
            }
        }
    }

    private List<String> getClusterMembers() {
        List<String> clusterMembers = EMPTY_LIST;
        Cluster cluster = this.domain.getClusterNamed(this.clusterName);
        List targetServers = null;
        if (cluster != null && (targetServers = this.domain.getServersInTarget(this.clusterName)) != null) {
            clusterMembers = new ArrayList<String>(targetServers.size());
            for (Server server : targetServers) {
                clusterMembers.add(server.getName());
            }
        }
        return clusterMembers;
    }
}

