/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.util.HostAndPort;
import java.io.File;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="stop-local-instance")
@Scoped(value=PerLookup.class)
public class StopLocalInstanceCommand
extends LocalInstanceCommand {
    @Param(name="instance_name", primary=true, optional=true)
    private String userArgInstanceName;

    protected void validate() throws CommandException, CommandValidationException {
        this.instanceName = this.userArgInstanceName;
        super.validate();
    }

    protected boolean mkdirs(File f) {
        return false;
    }

    protected void initInstance() throws CommandException {
        super.initInstance();
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        File serverDir = this.getServerDirs().getServerDir();
        if (serverDir == null || !serverDir.isDirectory()) {
            return this.noSuchInstance();
        }
        if (this.getServerDirs().getLocalPassword() == null) {
            return this.instanceNotRunning();
        }
        String serverName = this.getServerDirs().getServerName();
        HostAndPort addr = this.getAdminAddress(serverName);
        this.programOpts.setHostAndPort(addr);
        logger.finer("StopInstance.stoppingMessage" + addr.getPort());
        this.programOpts.setInteractive(false);
        if (!this.isThisServer(serverDir, "Instance-Root_value")) {
            return this.instanceNotRunning();
        }
        logger.finer("It's the correct Instance");
        return this.doRemoteCommand();
    }

    protected int instanceNotRunning() throws CommandException {
        logger.warning(Strings.get("StopInstance.instanceNotRunning"));
        return 0;
    }

    private int noSuchInstance() {
        logger.warning(Strings.get("Instance.noSuchInstance"));
        return 0;
    }

    protected int doRemoteCommand() throws CommandException, CommandValidationException {
        RemoteCommand cmd = new RemoteCommand("_stop-instance", this.programOpts, this.env);
        cmd.executeAndReturnOutput(new String[]{"_stop-instance"});
        this.waitForDeath();
        return 0;
    }

    private void waitForDeath() throws CommandException {
        if (!this.programOpts.isTerse()) {
            System.out.print(Strings.get("StopInstance.waitForDeath") + " ");
        }
        long startWait = System.currentTimeMillis();
        boolean alive = true;
        int count = 0;
        while (!this.timedOut(startWait)) {
            if (!this.isRunning()) {
                alive = false;
                break;
            }
            try {
                Thread.sleep(100L);
                if (this.programOpts.isTerse() || count++ % 10 != 0) continue;
                System.out.print(".");
            }
            catch (InterruptedException ex) {}
        }
        if (!this.programOpts.isTerse()) {
            System.out.println();
        }
        if (alive) {
            throw new CommandException(Strings.get("StopInstance.instanceNotDead", 60));
        }
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 60000L;
    }
}

