/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.launcher;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.KnownHosts;
import com.trilead.ssh2.SCPClient;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.HostVerifier;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.internal.api.RelativePathResolver;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="SSHLauncher")
@Scoped(value=PerLookup.class)
public class SSHLauncher {
    private static final String SSH_DIR = ".ssh" + File.separator;
    private static final String AUTH_KEY_FILE = "authorized_keys";
    private static final int DEFAULT_TIMEOUT_MSEC = 120000;
    private static KnownHosts knownHostsDatabase = new KnownHosts();
    private String host;
    private int port;
    private String userName;
    private String keyFile;
    private Connection connection;
    private String authType;
    private String keyPassPhrase;
    private File knownHosts;
    private Logger logger;
    private String password;
    private String rawPassword = null;
    private String rawKeyPassPhrase = null;
    @Inject
    private Habitat habitat;

    public void init(Node node, Logger logger) {
        int port;
        String sshHost;
        this.logger = logger;
        SshConnector connector = node.getSshConnector();
        String host = connector.getSshHost();
        this.host = SSHUtil.checkString(host) != null ? host : node.getNodeHost();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Connecting to host " + host);
        }
        if ((sshHost = connector.getSshHost()) != null) {
            this.host = sshHost;
        }
        SshAuth sshAuth = connector.getSshAuth();
        String userName = null;
        if (sshAuth != null) {
            userName = sshAuth.getUserName();
            this.keyFile = sshAuth.getKeyfile();
            this.rawPassword = sshAuth.getPassword();
            this.rawKeyPassPhrase = sshAuth.getKeyPassphrase();
        }
        try {
            port = Integer.parseInt(connector.getSshPort());
        }
        catch (NumberFormatException nfe) {
            port = 22;
        }
        this.init(userName, this.host, port, this.rawPassword, this.keyFile, this.rawKeyPassPhrase, logger);
    }

    public void init(String userName, String host, int port, String password, String keyFile, String keyPassPhrase, Logger logger) {
        this.port = port == 0 ? 22 : port;
        this.host = host;
        this.keyFile = keyFile == null ? SSHUtil.getExistingKeyFile() : keyFile;
        this.logger = logger;
        this.userName = SSHUtil.checkString(userName) == null ? System.getProperty("user.name") : userName;
        this.rawPassword = password;
        this.password = this.expandPasswordAlias(password);
        this.rawKeyPassPhrase = keyPassPhrase;
        this.keyPassPhrase = this.expandPasswordAlias(keyPassPhrase);
        if (this.knownHosts == null) {
            File home = new File(System.getProperty("user.home"));
            this.knownHosts = new File(home, ".ssh/known_hosts");
        }
        if (this.knownHosts.exists()) {
            try {
                knownHostsDatabase.addHostkeys(this.knownHosts);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("SSH info is " + this.toString());
        }
    }

    private void openConnection() throws IOException {
        String message;
        boolean isAuthenticated;
        block18: {
            block17: {
                isAuthenticated = false;
                message = "";
                this.connection = new Connection(this.host, this.port);
                this.connection.connect(new HostVerifier(knownHostsDatabase));
                if (SSHUtil.checkString(this.keyFile) == null && SSHUtil.checkString(this.password) == null) {
                    message = message + "No key or password specified - trying default keys \n";
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("keyfile and password are null. Will try to authenticate with default key file if available");
                    }
                    File home = new File(System.getProperty("user.home"));
                    for (String keyName : Arrays.asList("id_rsa", "id_dsa", "identity")) {
                        message = message + "Tried to authenticate using " + keyName + "\n";
                        File key = new File(home, ".ssh/" + keyName);
                        if (key.exists()) {
                            isAuthenticated = this.connection.authenticateWithPublicKey(this.userName, key, null);
                        }
                        if (!isAuthenticated) continue;
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("Authentication successful using key " + keyName);
                        }
                        message = null;
                        break;
                    }
                }
                if (!isAuthenticated && SSHUtil.checkString(this.password) != null) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Authenticating with password " + this.getPrintablePassword(this.password));
                    }
                    try {
                        isAuthenticated = this.connection.authenticateWithPassword(this.userName, this.password);
                    }
                    catch (IOException iex) {
                        if (!this.logger.isLoggable(Level.FINE)) break block17;
                        this.logger.fine("Tried authenticating with password " + this.password);
                    }
                }
            }
            if (!isAuthenticated && SSHUtil.checkString(this.keyFile) != null) {
                File key;
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Specified key file is " + this.keyFile);
                }
                if ((key = new File(this.keyFile)).exists()) {
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.finer("Specified key file exists at " + key);
                    }
                    try {
                        isAuthenticated = this.connection.authenticateWithPublicKey(this.userName, key, this.keyPassPhrase);
                    }
                    catch (IOException ex) {
                        if (!this.logger.isLoggable(Level.FINE)) break block18;
                        this.logger.fine("Tried authenticating with specified key at " + key);
                    }
                }
            }
        }
        if (!isAuthenticated && !this.connection.isAuthenticationComplete()) {
            this.connection.close();
            this.connection = null;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Could not authenticate");
            }
            throw new IOException("Could not authenticate. " + message);
        }
        message = null;
        SSHUtil.register(this.connection);
    }

    public int runCommand(String command, OutputStream os) throws IOException, InterruptedException {
        command = SFTPClient.normalizePath(command);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Running command " + command + " on host: " + this.host);
        }
        this.openConnection();
        int status = this.connection.exec(command, os);
        SSHUtil.unregister(this.connection);
        this.connection = null;
        return status;
    }

    public void pingConnection() throws IOException, InterruptedException {
        this.logger.fine("Pinging connection for host: " + this.host);
        this.openConnection();
        SSHUtil.unregister(this.connection);
        this.connection = null;
    }

    public void validate(String host, int port, String userName, String password, String keyFile, String keyPassPhrase, String installDir, String landmarkPath, Logger logger) throws IOException {
        boolean validInstallDir = false;
        this.init(userName, host, port, password, keyFile, keyPassPhrase, logger);
        this.openConnection();
        logger.fine("Connection settings valid");
        String testPath = installDir;
        if (StringUtils.ok((String)testPath)) {
            SFTPClient sftpClient = new SFTPClient(this.connection);
            if (sftpClient.exists(testPath)) {
                if (StringUtils.ok((String)landmarkPath)) {
                    testPath = installDir + "/" + landmarkPath;
                }
                validInstallDir = sftpClient.exists(testPath);
            } else {
                validInstallDir = false;
            }
            SSHUtil.unregister(this.connection);
            this.connection = null;
            if (!validInstallDir) {
                String msg = "Invalid install directory: could not find " + testPath + " on " + host;
                logger.warning(msg);
                throw new FileNotFoundException(msg);
            }
            logger.fine("Node home validated");
        }
    }

    public void validate(String host, int port, String userName, String password, String keyFile, String keyPassPhrase, String installDir, Logger logger) throws IOException {
        this.validate(host, port, userName, password, keyFile, keyPassPhrase, installDir, null, logger);
    }

    public SFTPClient getSFTPClient() throws IOException {
        this.openConnection();
        SFTPClient sftpClient = new SFTPClient(this.connection);
        return sftpClient;
    }

    public SCPClient getSCPClient() throws IOException {
        this.openConnection();
        return new SCPClient(this.connection);
    }

    public String expandPasswordAlias(String alias) {
        String expandedPassword = null;
        if (alias == null) {
            return null;
        }
        try {
            expandedPassword = RelativePathResolver.getRealPasswordFromAlias((String)alias);
        }
        catch (Exception e) {
            this.logger.warning(StringUtils.cat((String)": ", (String[])new String[]{alias, e.getMessage()}));
            return null;
        }
        return expandedPassword;
    }

    public boolean isPasswordAlias(String alias) {
        String aliasName = RelativePathResolver.getAlias((String)alias);
        return aliasName != null;
    }

    private String getPrintablePassword(String p) {
        String printable = "null";
        if (p != null) {
            printable = this.isPasswordAlias(p) ? p : "<concealed>";
        }
        return printable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupKey(String node, String pubKeyFile, boolean generateKey, String passwd) throws IOException {
        boolean connected = false;
        File key = new File(this.keyFile);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Key = " + this.keyFile);
        }
        this.logger.info("keyfile " + this.keyFile);
        if (key.exists()) {
            if (this.checkConnection()) {
                throw new IOException("SSH public key authentication is already configured for " + this.userName + "@" + node);
            }
        } else if (generateKey) {
            if (!this.generateKeyPair()) {
                throw new IOException("SSH key pair generation failed. Please generate key manually.");
            }
        } else {
            throw new IOException("SSH key pair not present. Please generate a key pair manually or specify an existing one and re-run the command.");
        }
        if (passwd == null) {
            throw new IOException("SSH password is required for distributing the public key. You can specify the SSH password in a password file and pass it through --passwordfile option.");
        }
        try {
            this.logger.info("got password now connect ");
            this.connection = new Connection(node, this.port);
            this.connection.connect();
            connected = this.connection.authenticateWithPassword(this.userName, passwd);
        }
        catch (Exception ex) {
            throw new IOException("SSH password authentication failed for user " + this.userName + " on host " + node);
        }
        if (!connected) {
            throw new IOException("SSH password authentication failed for user " + this.userName + " on host " + node);
        }
        this.logger.info("Connected");
        SCPClient scp = new SCPClient(this.connection);
        if (key.exists()) {
            if (pubKeyFile == null) {
                pubKeyFile = this.keyFile + ".pub";
            }
            this.logger.info("pubKeyFile " + pubKeyFile);
            File pubKey = new File(pubKeyFile);
            if (!pubKey.exists()) {
                throw new IOException("Public key file " + pubKeyFile + " does not exist.");
            }
            ByteArrayOutputStream out = null;
            OutputStream oStream = null;
            InputStream sendFile = null;
            File f = null;
            try {
                out = new ByteArrayOutputStream();
                try {
                    scp.get(SSH_DIR + AUTH_KEY_FILE, out);
                    this.logger.info("scp.get passed");
                }
                catch (IOException io) {
                    // empty catch block
                }
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Got the remote authorized_keys file");
                }
                File home = new File(System.getProperty("user.home"));
                this.logger.info("home " + home);
                f = new File(home, SSH_DIR + AUTH_KEY_FILE + ".temp");
                this.logger.info("tmep file " + f.toString());
                oStream = new FileOutputStream(f);
                out.writeTo(oStream);
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Wrote the temp file");
                }
                this.appendPublicKey(pubKey, f);
                sendFile = new FileInputStream(f);
                byte[] theBytes = new byte[sendFile.available()];
                sendFile.read(theBytes);
                try {
                    if (this.connection.exec("test -d " + SSH_DIR, new ByteArrayOutputStream()) != 0) {
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.fine(SSH_DIR + " does not exist");
                        }
                        if (this.connection.exec("mkdir -p " + SSH_DIR, new ByteArrayOutputStream()) != 0 && this.logger.isLoggable(Level.FINER)) {
                            this.logger.finer("Created .ssh directory");
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.info("Failed to create .ssh directory on remote host:" + e.getMessage());
                    throw new IOException("Error while creating .ssh directory on remote host:" + e.getMessage());
                }
                try {
                    scp.put(theBytes, AUTH_KEY_FILE, SSH_DIR);
                }
                catch (Exception e) {
                    if (this.logger.isLoggable(Level.FINER)) {
                        e.printStackTrace();
                    }
                    throw new IOException("Failed to copy public key to remote host " + this.host + ": " + e.getMessage());
                }
                this.logger.info("Copied keyfile " + pubKeyFile + " to " + this.userName + "@" + this.host);
            }
            finally {
                f.delete();
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException io) {}
                }
                if (oStream != null) {
                    try {
                        oStream.close();
                    }
                    catch (IOException io) {}
                }
                if (sendFile != null) {
                    try {
                        sendFile.close();
                    }
                    catch (IOException io) {}
                }
            }
        }
    }

    private void appendPublicKey(File pubKey, File f) {
        try {
            int c;
            BufferedWriter out = new BufferedWriter(new FileWriter(f, true));
            FileInputStream in = new FileInputStream(pubKey);
            while ((c = ((InputStream)in).read()) != -1) {
                out.write(c);
            }
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        int len;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((len = input.read(buf)) >= 0) {
            output.write(buf, 0, len);
        }
        byte[] o = output.toByteArray();
        output.close();
        return o;
    }

    public boolean checkConnection() throws IOException {
        boolean status = false;
        Connection c = null;
        c = new Connection(this.host, this.port);
        c.connect();
        File f = new File(this.keyFile);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Checking connection...");
        }
        if (status = c.authenticateWithPublicKey(this.userName, f, this.rawKeyPassPhrase)) {
            this.logger.info("Successfully connected to " + this.userName + "@" + this.host + " using keyfile " + this.keyFile);
        }
        c.close();
        return status;
    }

    public boolean checkPasswordAuth() {
        Connection c;
        boolean status;
        block4: {
            status = false;
            c = null;
            try {
                c = new Connection(this.host, this.port);
                c.connect();
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Checking connection...");
                }
                if (status = c.authenticateWithPassword(this.userName, this.password)) {
                    this.logger.finer("Successfully connected to " + this.userName + "@" + this.host + " using password authentication");
                }
            }
            catch (IOException ioe) {
                if (!this.logger.isLoggable(Level.FINER)) break block4;
                ioe.printStackTrace();
            }
        }
        c.close();
        return status;
    }

    private boolean generateKeyPair() throws IOException {
        int exit;
        String keygenCmd = this.findSSHKeygen();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Using " + keygenCmd + " to generate key pair");
        }
        StringBuffer k = new StringBuffer();
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add(keygenCmd);
        k.append(keygenCmd);
        cmdLine.add("-t");
        k.append(" ").append("-t");
        cmdLine.add("rsa");
        k.append(" ").append("rsa");
        cmdLine.add("-N");
        k.append(" ").append("-N");
        if (this.rawKeyPassPhrase != null && this.rawKeyPassPhrase.length() > 0) {
            cmdLine.add(this.rawKeyPassPhrase);
            k.append(" ").append(this.getPrintablePassword(this.rawKeyPassPhrase));
        } else if (OS.isWindows()) {
            cmdLine.add("\"\"");
            k.append(" ").append("\"\"");
        } else {
            cmdLine.add("");
            k.append(" ").append("");
        }
        cmdLine.add("-f");
        k.append(" ").append("-f");
        cmdLine.add(this.keyFile);
        k.append(" ").append(this.keyFile);
        ProcessManager pm = new ProcessManager(cmdLine);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Command = " + k);
        }
        pm.setTimeoutMsec(120000);
        if (this.logger.isLoggable(Level.FINER)) {
            pm.setEcho(true);
        } else {
            pm.setEcho(false);
        }
        try {
            exit = pm.execute();
        }
        catch (ProcessManagerException ex) {
            this.logger.fine("Error while executing ssh-keygen: " + ex.getMessage());
            exit = 1;
        }
        if (exit == 0) {
            this.logger.info(keygenCmd + " successfully generated the identification " + this.keyFile);
        } else {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(pm.getStderr());
            }
            this.logger.info(keygenCmd + " failed");
        }
        return exit == 0;
    }

    private String findSSHKeygen() {
        ArrayList<String> cmds = new ArrayList<String>(Arrays.asList("/usr/bin/ssh-keygen", "/usr/local/bin/ssh-keygen"));
        File exe = ProcessUtils.getExe((String)"ssh-keygen");
        if (exe != null) {
            return exe.getPath();
        }
        for (String s : cmds) {
            File f = new File(s);
            if (!f.canExecute()) continue;
            return s;
        }
        return "ssh-keygen";
    }

    public String toString() {
        String knownHostsPath = "null";
        if (this.knownHosts != null) {
            try {
                knownHostsPath = this.knownHosts.getCanonicalPath();
            }
            catch (IOException e) {
                knownHostsPath = this.knownHosts.getAbsolutePath();
            }
        }
        String displayPassword = this.getPrintablePassword(this.rawPassword);
        String displayKeyPassPhrase = this.getPrintablePassword(this.rawKeyPassPhrase);
        return String.format("host=%s port=%d user=%s password=%s keyFile=%s keyPassPhrase=%s authType=%s knownHostFile=%s", this.host, this.port, this.userName, displayPassword, this.keyFile, displayKeyPassPhrase, this.authType, knownHostsPath);
    }
}

