/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.InstanceDirs;
import com.sun.enterprise.v3.admin.cluster.InstanceDirUtils;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import com.sun.enterprise.v3.admin.cluster.SecureAdminBootstrapHelper;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="create-instance")
@I18n(value="create.instance")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public class CreateInstanceCommand
implements AdminCommand {
    private static final String NL = System.getProperty("line.separator");
    @Inject
    private CommandRunner cr;
    @Inject
    Habitat habitat;
    @Inject
    Node[] nodeList;
    @Inject
    private Nodes nodes;
    @Inject
    private Servers servers;
    @Inject
    private ServerEnvironment env;
    @Inject
    private ServerContext serverContext;
    @Param(name="node", alias="nodeagent")
    String node;
    @Param(name="config", optional=true)
    @I18n(value="generic.config")
    String configRef;
    @Param(name="cluster", optional=true)
    String clusterName;
    @Param(name="lbenabled", optional=true, acceptableValues="true,false")
    private String lbEnabled;
    @Param(name="checkports", optional=true, defaultValue="true")
    private boolean checkPorts;
    @Param(optional=true, defaultValue="false")
    private boolean terse;
    @Param(name="portbase", optional=true)
    private String portBase;
    @Param(name="systemproperties", optional=true, separator=58)
    private String systemProperties;
    @Param(name="instance_name", primary=true)
    private String instance;
    private Logger logger;
    private AdminCommandContext ctx;
    private Node theNode = null;
    private String nodeHost = null;
    private String nodeDir = null;
    private String installDir = null;
    private String registerInstanceMessage = null;
    private InstanceDirUtils insDU;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.ctx = context;
        this.logger = context.logger;
        this.theNode = this.nodes.getNode(this.node);
        if (this.theNode == null) {
            String msg = Strings.get("noSuchNode", this.node);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        if (this.lbEnabled != null && this.clusterName == null) {
            String msg = Strings.get("lbenabledNotForStandaloneInstance");
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        this.nodeHost = this.theNode.getNodeHost();
        this.nodeDir = this.theNode.getNodeDir();
        this.installDir = this.theNode.getInstallDir();
        if (!StringUtils.ok((String)this.nodeHost)) {
            String msg = Strings.get("create.instance.missing.info", this.theNode.getName(), "nodehost", "create-instance", "update-node-config", "create-local-instance");
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        if (!StringUtils.ok((String)this.installDir)) {
            String msg = Strings.get("create.instance.missing.info", this.theNode.getName(), "installdir", "create-instance", "update-node-config", "create-local-instance");
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_register-instance", report);
        ParameterMap map = new ParameterMap();
        map.add((Object)"node", (Object)this.node);
        map.add((Object)"config", (Object)this.configRef);
        map.add((Object)"cluster", (Object)this.clusterName);
        if (this.lbEnabled != null) {
            map.add((Object)"lbenabled", (Object)this.lbEnabled.toString());
        }
        if (!this.checkPorts) {
            map.add((Object)"checkports", (Object)"false");
        }
        if (StringUtils.ok((String)this.portBase)) {
            map.add((Object)"portbase", (Object)this.portBase);
        }
        map.add((Object)"systemproperties", (Object)this.systemProperties);
        map.add((Object)"DEFAULT", (Object)this.instance);
        ci.parameters(map);
        ci.execute();
        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            return;
        }
        this.registerInstanceMessage = report.getMessage();
        this.createInstanceFilesystem(context);
    }

    private File getLocalInstanceDir() throws IOException {
        File nodeDirFile = this.nodeDir != null ? new File(this.nodeDir) : this.defaultLocalNodeDirFile();
        InstanceDirs instanceDirs = new InstanceDirs(nodeDirFile.toString(), this.theNode.getName(), this.instance);
        return instanceDirs.getInstanceDir();
    }

    private File defaultLocalNodeDirFile() {
        File nodeParentDir = this.installDir == null ? this.serverContext.getInstallRoot() : new File(this.installDir, "glassfish");
        return new File(nodeParentDir, "nodes");
    }

    private File getDomainInstanceDir() {
        return this.env.getInstanceRoot();
    }

    private int bootstrapSecureAdminLocally() {
        ActionReport report = this.ctx.getActionReport();
        try {
            SecureAdminBootstrapHelper bootHelper = SecureAdminBootstrapHelper.getLocalHelper(this.env.getInstanceRoot(), this.getLocalInstanceDir());
            bootHelper.bootstrapInstance();
            return 0;
        }
        catch (Exception ex) {
            String msg = Strings.get("create.instance.local.boot.failed", this.instance, this.node, this.nodeHost);
            this.logger.log(Level.SEVERE, msg, ex);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return 1;
        }
    }

    private int bootstrapSecureAdminRemotely() {
        ActionReport report = this.ctx.getActionReport();
        String thisNodeDir = null;
        if (this.nodeDir != null) {
            thisNodeDir = this.nodeDir + "/" + this.node;
        }
        try {
            SecureAdminBootstrapHelper bootHelper = SecureAdminBootstrapHelper.getRemoteHelper(this.habitat, this.getDomainInstanceDir(), thisNodeDir, this.instance, this.theNode, this.logger);
            bootHelper.bootstrapInstance();
            return 0;
        }
        catch (Exception ex) {
            String msg = Strings.get("create.instance.remote.boot.failed", this.instance, ex instanceof SecureAdminBootstrapHelper.BootstrapException ? ((SecureAdminBootstrapHelper.BootstrapException)ex).sshSettings() : null, ex.getMessage(), this.nodeHost);
            this.logger.severe(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return 1;
        }
    }

    public void createInstanceFilesystem(AdminCommandContext context) {
        ActionReport report = this.ctx.getActionReport();
        NodeUtils nodeUtils = new NodeUtils(this.habitat, this.logger);
        Server dasServer = this.servers.getServer("server");
        String dasHost = dasServer.getAdminHost();
        String dasPort = Integer.toString(dasServer.getAdminPort());
        ArrayList<String> command = new ArrayList<String>();
        String humanCommand = null;
        command.add("--host");
        command.add(dasHost);
        command.add("--port");
        command.add(dasPort);
        command.add("_create-instance-filesystem");
        if (this.nodeDir != null) {
            command.add("--nodedir");
            command.add(this.nodeDir);
        }
        command.add("--node");
        command.add(this.node);
        command.add(this.instance);
        humanCommand = this.makeCommandHuman(command);
        if (!this.theNode.isLocal() && !this.theNode.getType().equals("SSH")) {
            String msg = Strings.get("create.instance.config", this.instance, humanCommand);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            report.setMessage(msg);
            return;
        }
        String firstErrorMessage = Strings.get("create.instance.filesystem.failed", this.instance, this.node, this.nodeHost);
        StringBuilder output = new StringBuilder();
        nodeUtils.runAdminCommandOnNode(this.theNode, command, this.ctx, firstErrorMessage, humanCommand, output);
        if (report.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
            return;
        }
        String msg = Strings.get("create.instance.success", this.instance, this.nodeHost);
        if (!this.terse) {
            msg = StringUtils.cat((String)NL, (String[])new String[]{output.toString().trim(), this.registerInstanceMessage, msg});
        }
        report.setMessage(msg);
        if (this.theNode.isLocal()) {
            this.bootstrapSecureAdminLocally();
        } else {
            this.bootstrapSecureAdminRemotely();
        }
    }

    private String makeCommandHuman(List<String> command) {
        StringBuilder fullCommand = new StringBuilder();
        fullCommand.append("asadmin ");
        for (String s : command) {
            if (s.equals("_create-instance-filesystem")) {
                fullCommand.append(" ");
                fullCommand.append("create-local-instance");
                continue;
            }
            fullCommand.append(" ");
            fullCommand.append(s);
        }
        return fullCommand.toString();
    }
}

