/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.beans.PropertyVetoException;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="_update-node")
@I18n(value="update.node")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public class UpdateNodeCommand
implements AdminCommand {
    @Inject
    Nodes nodes;
    @Inject
    Domain domain;
    @Param(name="name", primary=true)
    String name;
    @Param(name="nodedir", optional=true)
    String nodedir;
    @Param(name="nodehost", optional=true)
    String nodehost;
    @Param(name="installdir", optional=true)
    String installdir;
    @Param(name="sshport", optional=true)
    String sshport;
    @Param(name="sshuser", optional=true)
    String sshuser;
    @Param(name="sshnodehost", optional=true)
    String sshnodehost;
    @Param(name="sshkeyfile", optional=true)
    String sshkeyfile;
    @Param(name="sshpassword", optional=true, password=true)
    String sshpassword;
    @Param(name="sshkeypassphrase", optional=true, password=true)
    String sshkeypassphrase;
    @Param(name="type", optional=true)
    String type;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.logger;
        Node node = this.nodes.getNode(this.name);
        if (node == null) {
            String msg = Strings.get("noSuchNode", this.name);
            logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        try {
            this.updateNodeElement(this.name);
        }
        catch (TransactionFailure e) {
            logger.warning("failed.to.update.node " + this.name);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
        }
    }

    public void updateNodeElement(final String nodeName) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode(){

            public Object run(ConfigBeanProxy param) throws PropertyVetoException, TransactionFailure {
                Transaction t = Transaction.getTransaction((ConfigBeanProxy)param);
                if (t != null) {
                    Nodes nodes = ((Domain)param).getNodes();
                    Node node = nodes.getNode(nodeName);
                    Node writeableNode = (Node)t.enroll((ConfigBeanProxy)node);
                    if (UpdateNodeCommand.this.nodedir != null) {
                        writeableNode.setNodeDir(UpdateNodeCommand.this.nodedir);
                    }
                    if (UpdateNodeCommand.this.nodehost != null) {
                        writeableNode.setNodeHost(UpdateNodeCommand.this.nodehost);
                    }
                    if (UpdateNodeCommand.this.installdir != null) {
                        writeableNode.setInstallDir(UpdateNodeCommand.this.installdir);
                    }
                    if (UpdateNodeCommand.this.type != null) {
                        writeableNode.setType(UpdateNodeCommand.this.type);
                    }
                    if (UpdateNodeCommand.this.sshport != null || UpdateNodeCommand.this.sshnodehost != null || UpdateNodeCommand.this.sshuser != null || UpdateNodeCommand.this.sshkeyfile != null) {
                        SshConnector sshC = writeableNode.getSshConnector();
                        sshC = sshC == null ? (SshConnector)writeableNode.createChild(SshConnector.class) : (SshConnector)t.enroll((ConfigBeanProxy)sshC);
                        if (UpdateNodeCommand.this.sshport != null) {
                            sshC.setSshPort(UpdateNodeCommand.this.sshport);
                        }
                        if (UpdateNodeCommand.this.sshnodehost != null) {
                            sshC.setSshHost(UpdateNodeCommand.this.sshnodehost);
                        }
                        if (UpdateNodeCommand.this.sshuser != null || UpdateNodeCommand.this.sshkeyfile != null || UpdateNodeCommand.this.sshpassword != null || UpdateNodeCommand.this.sshkeypassphrase != null) {
                            SshAuth sshA = sshC.getSshAuth();
                            sshA = sshA == null ? (SshAuth)sshC.createChild(SshAuth.class) : (SshAuth)t.enroll((ConfigBeanProxy)sshA);
                            if (UpdateNodeCommand.this.sshuser != null) {
                                sshA.setUserName(UpdateNodeCommand.this.sshuser);
                            }
                            if (UpdateNodeCommand.this.sshkeyfile != null) {
                                sshA.setKeyfile(UpdateNodeCommand.this.sshkeyfile);
                            }
                            if (UpdateNodeCommand.this.sshpassword != null) {
                                sshA.setPassword(UpdateNodeCommand.this.sshpassword);
                            }
                            if (UpdateNodeCommand.this.sshkeypassphrase != null) {
                                sshA.setKeyPassphrase(UpdateNodeCommand.this.sshkeypassphrase);
                            }
                            sshC.setSshAuth(sshA);
                        }
                        writeableNode.setSshConnector(sshC);
                    }
                }
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy)this.domain);
    }
}

