/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.config.serverbeans.LbConfigs;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-http-lb-configs")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public final class ListLBConfigsCommand
implements AdminCommand {
    @Param(primary=true, optional=true)
    String list_target;
    @Inject
    Domain domain;
    @Inject
    LbConfigs lbconfigs;
    @Inject
    Target tgt;
    @Inject
    Logger logger;
    private ActionReport report;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListLBConfigsCommand.class);

    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        ActionReport.MessagePart part = this.report.getTopMessagePart();
        boolean isCluster = this.tgt.isCluster(this.list_target);
        List lbConfigs = this.lbconfigs.getLbConfig();
        if (lbConfigs.size() == 0) {
            this.logger.fine(localStrings.getLocalString("http_lb_admin.NoLbConfigs", "No lb configs"));
            return;
        }
        if (this.list_target == null) {
            for (LbConfig lbc : lbConfigs) {
                ActionReport.MessagePart childPart = part.addChild();
                childPart.setMessage(lbc.getName());
            }
        } else if (isCluster) {
            for (LbConfig lbc : lbConfigs) {
                List refs = lbc.getRefs(ClusterRef.class);
                for (ClusterRef cRef : refs) {
                    if (!cRef.getRef().equals(this.list_target)) continue;
                    ActionReport.MessagePart childPart = part.addChild();
                    childPart.setMessage(lbc.getName());
                }
            }
        } else if (this.domain.isServer(this.list_target)) {
            for (LbConfig lbc : lbConfigs) {
                List refs = lbc.getRefs(ServerRef.class);
                for (ServerRef sRef : refs) {
                    if (!sRef.getRef().equals(this.list_target)) continue;
                    ActionReport.MessagePart childPart = part.addChild();
                    childPart.setMessage(lbc.getName());
                }
            }
        } else {
            LbConfig lbConfig = this.lbconfigs.getLbConfig(this.list_target);
            if (lbConfig != null) {
                List cRefs = lbConfig.getRefs(ClusterRef.class);
                for (ClusterRef ref : cRefs) {
                    String s = localStrings.getLocalString("ClusterPrefix", "Cluster:");
                    ActionReport.MessagePart childPart = part.addChild();
                    childPart.setMessage(s + ref.getRef());
                }
                List sRefs = lbConfig.getRefs(ServerRef.class);
                for (ServerRef ref : sRefs) {
                    String s = localStrings.getLocalString("ServerPrefix", "Server:");
                    ActionReport.MessagePart childPart = part.addChild();
                    childPart.setMessage(s + ref.getRef());
                }
            }
        }
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

