/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

public abstract class SecureAdminCommand
implements AdminCommand {
    @Inject
    protected Domain domain;
    @Inject
    protected Configs configs;

    protected abstract void updateSecureAdminSettings(SecureAdmin var1);

    protected abstract void updateAdminListenerConfig(Transaction var1, Config var2, ActionReport.MessagePart var3);

    protected abstract String transactionErrorMessageKey();

    protected void updateSecureAdminSettings(SecureAdmin secureAdmin_w, boolean newEnabledValue) {
        secureAdmin_w.setEnabled(Boolean.toString(newEnabledValue));
    }

    protected final SecureAdmin getWriteableSecureAdmin(Transaction t, Domain d) throws TransactionFailure {
        SecureAdmin secureAdmin_w;
        SecureAdmin secureAdmin = d.getSecureAdmin();
        if (secureAdmin == null) {
            secureAdmin_w = (SecureAdmin)d.createChild(SecureAdmin.class);
            d.setSecureAdmin(secureAdmin_w);
        } else {
            secureAdmin_w = (SecureAdmin)t.enroll((ConfigBeanProxy)secureAdmin);
        }
        return secureAdmin_w;
    }

    public void execute(AdminCommandContext context) {
        final ActionReport report = context.getActionReport();
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Domain>(){

                public Object run(Domain d) throws PropertyVetoException, TransactionFailure {
                    Transaction t = Transaction.getTransaction((ConfigBeanProxy)d);
                    if (t != null) {
                        try {
                            SecureAdmin secureAdmin_w = SecureAdminCommand.this.getWriteableSecureAdmin(t, d);
                            SecureAdminCommand.this.updateSecureAdminSettings(secureAdmin_w);
                            for (Config c : SecureAdminCommand.this.configs.getConfig()) {
                                ActionReport.MessagePart partForThisConfig = report.getTopMessagePart().addChild();
                                SecureAdminCommand.this.updateAdminListenerConfig(t, c, partForThisConfig);
                            }
                            t.commit();
                        }
                        catch (RetryableException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    return Boolean.TRUE;
                }
            }, (ConfigBeanProxy)this.domain);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure ex) {
            report.failure(context.getLogger(), Strings.get(this.transactionErrorMessageKey()), (Throwable)ex);
        }
    }
}

