/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="start-instance")
@CommandLock(value=CommandLock.LockType.NONE)
@Scoped(value=PerLookup.class)
@I18n(value="start.instance.command")
public class StartInstanceCommand
implements AdminCommand {
    @Inject
    Habitat habitat;
    @Inject
    private Nodes nodes;
    @Inject
    private ServerEnvironment env;
    @Inject
    private Servers servers;
    @Param(name="instance_name", primary=true)
    private String instanceName;
    @Param(optional=true, defaultValue="normal", acceptableValues="none, normal, full")
    private String sync = "normal";
    @Param(optional=true, defaultValue="false")
    private boolean debug;
    @Param(optional=true, defaultValue="false")
    private boolean terse;
    @Param(optional=true, obsolete=true)
    private String setenv;
    private Logger logger;
    private AdminCommandContext ctx;
    private Node node;
    private String noderef;
    private String nodedir;
    private String nodeHost;
    private Server instance;
    private static final String NL = System.getProperty("line.separator");

    public void execute(AdminCommandContext context) {
        String s;
        this.logger = context.getLogger();
        this.ctx = context;
        ActionReport report = this.ctx.getActionReport();
        String msg = "";
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        if (!StringUtils.ok((String)this.instanceName)) {
            msg = Strings.get("start.instance.noInstanceName");
            this.logger.severe(msg);
            report.setMessage(msg);
            return;
        }
        this.instance = this.servers.getServer(this.instanceName);
        if (this.instance == null) {
            msg = Strings.get("start.instance.noSuchInstance", this.instanceName);
            this.logger.severe(msg);
            report.setMessage(msg);
            return;
        }
        if (this.instance.isRunning()) {
            msg = Strings.get("start.instance.already.running", this.instanceName);
            this.logger.info(msg);
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            return;
        }
        this.noderef = this.instance.getNode();
        if (!StringUtils.ok((String)this.noderef)) {
            msg = Strings.get("missingNodeRef", this.instanceName);
            this.logger.severe(msg);
            report.setMessage(msg);
            return;
        }
        this.node = this.nodes.getNode(this.noderef);
        if (this.node == null) {
            msg = Strings.get("missingNode", this.noderef);
            this.logger.severe(msg);
            report.setMessage(msg);
            return;
        }
        this.nodedir = this.node.getNodeDir();
        this.nodeHost = this.node.getNodeHost();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (this.env.isDas()) {
            this.startInstance();
        } else {
            msg = Strings.get("start.instance.notAnInstanceOrDas", this.env.getRuntimeType().toString());
            this.logger.severe(msg);
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS && (s = this.pollForLife()) != null) {
            report.setMessage(s);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void startInstance() {
        NodeUtils nodeUtils = new NodeUtils(this.habitat, this.logger);
        Server dasServer = this.servers.getServer("server");
        String dasHost = dasServer.getAdminHost();
        String dasPort = Integer.toString(dasServer.getAdminPort());
        ArrayList<String> command = new ArrayList<String>();
        String humanCommand = null;
        command.add("start-local-instance");
        command.add("--node");
        command.add(this.noderef);
        if (this.nodedir != null) {
            command.add("--nodedir");
            command.add(this.nodedir);
        }
        command.add("--sync");
        command.add(this.sync);
        if (this.debug) {
            command.add("--debug");
        }
        command.add(this.instanceName);
        humanCommand = this.makeCommandHuman(command);
        String firstErrorMessage = Strings.get("start.instance.failed", this.instanceName, this.noderef, this.nodeHost);
        StringBuilder output = new StringBuilder();
        boolean waitForReaderThreads = true;
        if (OS.isWindows()) {
            waitForReaderThreads = false;
        }
        nodeUtils.runAdminCommandOnNode(this.node, command, this.ctx, firstErrorMessage, humanCommand, output, waitForReaderThreads);
        ActionReport report = this.ctx.getActionReport();
        if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
            String msg = Strings.get("start.instance.success", this.instanceName, this.nodeHost);
            if (!this.terse) {
                msg = StringUtils.cat((String)NL, (String[])new String[]{output.toString().trim(), msg});
            }
            report.setMessage(msg);
        }
    }

    private String pollForLife() {
        int counter = 0;
        while (++counter < 240) {
            if (this.instance.isRunning()) {
                return null;
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        return Strings.get("start.instance.timeout", this.instanceName);
    }

    private String makeCommandHuman(List<String> command) {
        StringBuilder fullCommand = new StringBuilder();
        fullCommand.append("asadmin ");
        for (String s : command) {
            fullCommand.append(" ");
            fullCommand.append(s);
        }
        return fullCommand.toString();
    }
}

