/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.util.io.FileListerRelative;
import com.sun.enterprise.util.zip.ZipFileException;
import com.sun.enterprise.util.zip.ZipWriter;
import com.trilead.ssh2.SCPClient;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="install-node")
@Scoped(value=PerLookup.class)
public class InstallNodeCommand
extends CLICommand {
    @Param(optional=true)
    private String sshuser;
    @Param(optional=true)
    private int sshport;
    @Param(optional=true)
    private String sshkeyfile;
    @Param(name="archivedir", optional=true)
    private String archiveDir;
    @Param(optional=false, primary=true, multiple=true)
    private String[] hosts;
    @Param(name="installdir", optional=true)
    private String installDir;
    @Param(optional=true)
    private boolean recreate;
    @Param(optional=true)
    private boolean force;
    private String sshpassword;
    private String sshkeypassphrase = null;
    private boolean promptPass = false;
    @Inject
    SSHLauncher sshLauncher;

    protected void validate() throws CommandException {
    }

    protected int executeCommand() throws CommandException {
        try {
            String baseRootValue = this.getSystemProperty("com.sun.aas.productRoot");
            ArrayList<String> binDirFiles = new ArrayList<String>();
            File zipFile = this.createZipFile(baseRootValue, binDirFiles);
            this.copyToHosts(zipFile, baseRootValue, binDirFiles);
        }
        catch (IOException ioe) {
            throw new CommandException((Throwable)ioe);
        }
        catch (ZipFileException ze) {
            throw new CommandException((Throwable)ze);
        }
        catch (InterruptedException e) {
            throw new CommandException((Throwable)e);
        }
        return 0;
    }

    private void copyToHosts(File zipFile, String baseRootValue, ArrayList<String> binDirFiles) throws IOException, InterruptedException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        if (this.installDir == null) {
            this.installDir = baseRootValue.replaceAll("\\\\", "/");
        }
        for (String host : this.hosts) {
            this.sshLauncher.init(this.sshuser, host, this.sshport, this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
            SFTPClient sftpClient = this.sshLauncher.getSFTPClient();
            SCPClient scpClient = this.sshLauncher.getSCPClient();
            try {
                if (!sftpClient.exists(this.installDir)) {
                    sftpClient.mkdirs(this.installDir, 493);
                }
            }
            catch (IOException ioe) {
                logger.info(Strings.get("mkdir.failed", this.installDir, host));
                throw new IOException(ioe);
            }
            String zip = zipFile.getCanonicalPath();
            try {
                logger.info("Copying " + zip + " (" + zipFile.length() + " bytes)" + " to " + host + ":" + this.installDir);
                scpClient.put(zipFile.getAbsolutePath(), this.installDir);
                logger.finer("Copied " + zip + " to " + host + ":" + this.installDir);
            }
            catch (IOException ex) {
                logger.info(Strings.get("cannot.copy.zip.file", zip, host));
                throw new IOException(ex);
            }
            try {
                logger.info("Installing " + zip + " into " + host + ":" + this.installDir);
                String unzipCommand = "cd " + this.installDir + "; jar -xvf glassfish.zip";
                this.sshLauncher.runCommand(unzipCommand, (OutputStream)outStream);
                logger.finer("Installed " + zip + " into " + host + ":" + this.installDir);
            }
            catch (IOException ioe) {
                logger.info(Strings.get("jar.failed", host));
                throw new IOException(ioe);
            }
            try {
                logger.info("Removing " + host + ":" + this.installDir + "/glassfish.zip");
                sftpClient.rm(this.installDir + "/glassfish.zip");
                logger.finer("Removed " + host + ":" + this.installDir + "/glassfish.zip");
            }
            catch (IOException ioe) {
                logger.info(Strings.get("remove.glassfish.failed", host, this.installDir));
                throw new IOException(ioe);
            }
            logger.info("Fixing file permissions of all files under " + host + ":" + this.installDir + "/bin");
            try {
                for (String binDirFile : binDirFiles) {
                    sftpClient.chmod(this.installDir + "/" + binDirFile, 493);
                }
                logger.finer("Fixed file permissions of all files under " + host + ":" + this.installDir + "/bin");
            }
            catch (IOException ioe) {
                logger.info(Strings.get("fix.permissions.failed", host, this.installDir));
                throw new IOException(ioe);
            }
        }
    }

    private File createZipFile(String baseRootValue, ArrayList<String> binDirFiles) throws IOException, ZipFileException {
        File installRoot = new File(baseRootValue);
        File zipFileLocation = null;
        File glassFishZipFile = null;
        if (this.archiveDir != null) {
            zipFileLocation = new File(this.archiveDir);
            glassFishZipFile = new File(zipFileLocation, "glassfish.zip");
            if (glassFishZipFile.exists() && !this.recreate) {
                logger.finer("Found " + glassFishZipFile.getCanonicalPath());
                return glassFishZipFile;
            }
            if (!zipFileLocation.canWrite()) {
                throw new IOException("Cannot write to " + this.archiveDir);
            }
        } else {
            zipFileLocation = installRoot.canWrite() ? installRoot : new File(System.getProperty("java.io.tmpdir"));
        }
        if ((glassFishZipFile = new File(zipFileLocation, "glassfish.zip")).exists() && !this.recreate) {
            logger.finer("Found " + glassFishZipFile.getCanonicalPath());
            return glassFishZipFile;
        }
        FileListerRelative lister = new FileListerRelative(installRoot);
        lister.keepEmptyDirectories();
        String[] files = lister.getFiles();
        List<String> resultFiles1 = Arrays.asList(files);
        ArrayList<String> resultFiles = new ArrayList<String>(resultFiles1);
        Iterator<String> iter = resultFiles.iterator();
        while (iter.hasNext()) {
            String fileName = iter.next();
            if (fileName.contains("domains") || fileName.contains("nodes")) {
                iter.remove();
                continue;
            }
            if (!fileName.startsWith("bin") && !fileName.startsWith("glassfish/bin")) continue;
            binDirFiles.add(fileName);
        }
        String[] filesToZip = new String[resultFiles.size()];
        filesToZip = resultFiles.toArray(filesToZip);
        ZipWriter writer = new ZipWriter(glassFishZipFile.getCanonicalPath(), installRoot.toString(), filesToZip);
        writer.safeWrite();
        logger.info("Created installation zip " + glassFishZipFile.getCanonicalPath());
        return glassFishZipFile;
    }
}

