/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli.transform;

import org.glassfish.loadbalancer.admin.cli.beans.Cluster;
import org.glassfish.loadbalancer.admin.cli.beans.WebModule;
import org.glassfish.loadbalancer.admin.cli.reader.api.BaseReader;
import org.glassfish.loadbalancer.admin.cli.reader.api.ClusterReader;
import org.glassfish.loadbalancer.admin.cli.reader.api.HealthCheckerReader;
import org.glassfish.loadbalancer.admin.cli.reader.api.InstanceReader;
import org.glassfish.loadbalancer.admin.cli.reader.api.WebModuleReader;
import org.glassfish.loadbalancer.admin.cli.transform.HealthCheckerVisitor;
import org.glassfish.loadbalancer.admin.cli.transform.InstanceVisitor;
import org.glassfish.loadbalancer.admin.cli.transform.Visitor;
import org.glassfish.loadbalancer.admin.cli.transform.WebModuleVisitor;

public class ClusterVisitor
implements Visitor {
    Cluster _c = null;

    public ClusterVisitor(Cluster c) {
        this._c = c;
    }

    public void visit(BaseReader br) throws Exception {
        WebModuleReader[] wRdrs;
        HealthCheckerReader hcRdr;
        ClusterReader cRdr = (ClusterReader)br;
        this._c.setName(cRdr.getName());
        this._c.setPolicy(cRdr.getLbPolicy());
        this._c.setPolicyModule(cRdr.getLbPolicyModule());
        InstanceReader[] iRdrs = null;
        iRdrs = cRdr.getInstances();
        if (iRdrs != null && iRdrs.length > 0) {
            int i;
            boolean[] values = new boolean[iRdrs.length];
            for (i = 0; i < iRdrs.length; ++i) {
                values[i] = true;
            }
            this._c.setInstance(values);
            for (i = 0; i < iRdrs.length; ++i) {
                iRdrs[i].accept(new InstanceVisitor(this._c, i));
            }
        }
        if ((hcRdr = cRdr.getHealthChecker()) != null) {
            hcRdr.accept(new HealthCheckerVisitor(this._c));
        }
        if ((wRdrs = cRdr.getWebModules()) != null && wRdrs.length > 0) {
            WebModule[] wMods = new WebModule[wRdrs.length];
            for (int i = 0; i < wRdrs.length; ++i) {
                wMods[i] = new WebModule();
                wRdrs[i].accept(new WebModuleVisitor(wMods[i], this._c));
            }
            this._c.setWebModule(wMods);
        }
    }
}

