/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.universal.process.Jps;
import com.sun.enterprise.util.StringUtils;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="delete-local-instance")
@Scoped(value=PerLookup.class)
public class DeleteLocalInstanceCommand
extends LocalInstanceCommand {
    @Param(name="instance_name", primary=true, optional=true)
    private String instanceName0;

    protected void initInstance() throws CommandException {
        try {
            super.initInstance();
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException(Strings.get("DeleteInstance.noInstance"));
        }
    }

    protected boolean mkdirs(File f) {
        return false;
    }

    protected void validate() throws CommandException, CommandValidationException {
        this.instanceName = this.instanceName0;
        super.validate();
        if (!StringUtils.ok((String)this.getServerDirs().getServerName())) {
            throw new CommandException(Strings.get("DeleteInstance.noInstanceName"));
        }
        File dasProperties = this.getServerDirs().getDasPropertiesFile();
        if (dasProperties.isFile()) {
            this.setDasDefaults(dasProperties);
        }
        if (!this.getServerDirs().getServerDir().isDirectory()) {
            throw new CommandException(Strings.get("DeleteInstance.noWhack", this.getServerDirs().getServerDir()));
        }
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        if (this.isRunning()) {
            int prevpid = this.getPrevPid();
            Map procs = Jps.getProcessTable();
            Set set = procs.entrySet();
            for (Map.Entry entry : set) {
            }
            throw new CommandException(Strings.get("DeleteInstance.running"));
        }
        this.doRemote();
        this.whackFilesystem();
        return 0;
    }

    private void doRemote() throws CommandException {
        try {
            RemoteCommand rc = new RemoteCommand("_unregister-instance", this.programOpts, this.env);
            rc.execute(new String[]{"_unregister-instance", "--node", this.getServerDirs().getServerParentDir().getName(), this.getServerDirs().getServerName()});
        }
        catch (CommandException ce) {
            Throwable t = ce.getCause();
            String newString = Strings.get("DeleteInstance.remoteError", ce.getLocalizedMessage());
            if (t != null) {
                throw new CommandException(newString, t);
            }
            throw new CommandException(newString);
        }
    }
}

