/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.SSHCommandsBase;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileListerRelative;
import com.sun.enterprise.util.zip.ZipFileException;
import com.sun.enterprise.util.zip.ZipWriter;
import com.trilead.ssh2.SCPClient;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="install-node")
@Scoped(value=PerLookup.class)
public class InstallNodeCommand
extends SSHCommandsBase {
    @Param(name="archive", optional=true)
    private String archive;
    @Param(name="installdir", optional=true, defaultValue="${com.sun.aas.productRoot}")
    private String installDir;
    @Param(optional=true, defaultValue="false")
    private boolean create;
    @Param(optional=true, defaultValue="false")
    private boolean save;
    @Param(name="force", optional=true, defaultValue="false")
    private boolean force;
    @Inject
    private Habitat habitat;
    @Inject
    private SSHLauncher sshLauncher;
    @Inject
    Node[] nodeList;
    private String archiveName = "glassfish.zip";

    protected void validate() throws CommandException {
        this.installDir = this.resolver.resolve(this.installDir);
        if (!this.force) {
            for (String host : this.hosts) {
                for (Node node : this.nodeList) {
                    if (!node.getNodeHost().equals(host)) continue;
                    throw new CommandException(Strings.get("node.already.configured", host));
                }
            }
        }
        this.sshuser = this.resolver.resolve(this.sshuser);
        if (this.sshkeyfile == null) {
            String existingKey = SSHUtil.getExistingKeyFile();
            if (existingKey == null) {
                this.promptPass = true;
            } else {
                this.sshkeyfile = existingKey;
            }
        } else {
            this.validateKeyFile(this.sshkeyfile);
        }
        if (this.sshkeyfile != null && this.isEncryptedKey()) {
            this.sshkeypassphrase = this.getSSHPassphrase();
        }
    }

    protected int executeCommand() throws CommandException {
        Globals.setDefaultHabitat((Habitat)this.habitat);
        try {
            String baseRootValue = this.getSystemProperty("com.sun.aas.productRoot");
            ArrayList<String> binDirFiles = new ArrayList<String>();
            File zipFile = this.createZipFileIfNeeded(baseRootValue, binDirFiles);
            this.copyToHosts(zipFile, binDirFiles);
            if (!this.save) {
                zipFile.delete();
            }
        }
        catch (IOException ioe) {
            throw new CommandException((Throwable)ioe);
        }
        catch (ZipFileException ze) {
            throw new CommandException((Throwable)ze);
        }
        catch (InterruptedException e) {
            throw new CommandException((Throwable)e);
        }
        return 0;
    }

    private void copyToHosts(File zipFile, ArrayList<String> binDirFiles) throws IOException, InterruptedException, CommandException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        for (String host : this.hosts) {
            int status;
            String cmd;
            this.sshLauncher.init(this.sshuser, host, this.sshport, this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
            if (this.sshkeyfile != null && !this.sshLauncher.checkConnection()) {
                this.promptPass = true;
            }
            if (this.promptPass) {
                this.sshpassword = this.getSSHPassword(host);
                this.sshLauncher.init(this.sshuser, host, this.sshport, this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
            }
            SFTPClient sftpClient = this.sshLauncher.getSFTPClient();
            SCPClient scpClient = this.sshLauncher.getSCPClient();
            try {
                if (!sftpClient.exists(this.installDir)) {
                    sftpClient.mkdirs(this.installDir, 493);
                }
            }
            catch (IOException ioe) {
                logger.info(Strings.get("mkdir.failed", this.installDir, host));
                throw new IOException(ioe);
            }
            try {
                String asAdmin = OS.isWindows() ? "asadmin.bat" : "asadmin";
                cmd = this.installDir + "/glassfish/bin/" + asAdmin + " version --local --terse";
                status = this.sshLauncher.runCommand(cmd, (OutputStream)outStream);
                if (status == 0) {
                    logger.finer(host + ":'" + cmd + "'" + " returned [" + outStream.toString() + "]");
                    if (!this.force) {
                        throw new CommandException(Strings.get("found.glassfish.install", host, this.installDir));
                    }
                } else {
                    logger.finer(host + ":'" + cmd + "'" + " failed [" + outStream.toString() + "]");
                }
            }
            catch (IOException ex) {
                logger.info(Strings.get("glassfish.install.check.failed", host));
                throw new IOException(ex);
            }
            try {
                this.deleteRemoteFiles(sftpClient, this.installDir);
            }
            catch (IOException ex) {
                logger.finer("Failed to remove installDir contents");
                throw new IOException(ex);
            }
            String zip = zipFile.getCanonicalPath();
            try {
                logger.info("Copying " + zip + " (" + zipFile.length() + " bytes)" + " to " + host + ":" + this.installDir);
                scpClient.put(zipFile.getAbsolutePath(), this.installDir);
                logger.finer("Copied " + zip + " to " + host + ":" + this.installDir);
            }
            catch (IOException ex) {
                logger.info(Strings.get("cannot.copy.zip.file", zip, host));
                throw new IOException(ex);
            }
            try {
                logger.info("Installing " + zip + " into " + host + ":" + this.installDir);
                String unzipCommand = "cd " + this.installDir + "; jar -xvf " + this.archiveName;
                status = this.sshLauncher.runCommand(unzipCommand, (OutputStream)outStream);
                if (status != 0) {
                    logger.info(Strings.get("jar.failed", host, outStream.toString()));
                    throw new CommandException("Remote command output: " + outStream.toString());
                }
                logger.finer("Installed " + zip + " into " + host + ":" + this.installDir);
            }
            catch (IOException ioe) {
                logger.info(Strings.get("jar.failed", host, outStream.toString()));
                throw new IOException(ioe);
            }
            try {
                String zipFileName = zip.substring(zip.lastIndexOf("/"), zip.length());
                logger.info("Removing " + host + ":" + this.installDir + "/" + zipFileName);
                sftpClient.rm(this.installDir + "/" + zipFileName);
                logger.finer("Removed " + host + ":" + this.installDir + "/" + zipFileName);
            }
            catch (IOException ioe) {
                logger.info(Strings.get("remove.glassfish.failed", host, this.installDir));
                throw new IOException(ioe);
            }
            logger.info("Fixing file permissions of all files under " + host + ":" + this.installDir + "/bin");
            try {
                if (binDirFiles.isEmpty()) {
                    cmd = "cd " + this.installDir + "/glassfish/bin; chmod 0755 *";
                    status = this.sshLauncher.runCommand(cmd, (OutputStream)outStream);
                    if (status != 0) {
                        logger.info(Strings.get("jar.failed", host, outStream.toString()));
                        throw new CommandException("Remote command output: " + outStream.toString());
                    }
                } else {
                    for (String binDirFile : binDirFiles) {
                        sftpClient.chmod(this.installDir + "/" + binDirFile, 493);
                    }
                }
                logger.finer("Fixed file permissions of all files under " + host + ":" + this.installDir + "/bin");
            }
            catch (IOException ioe) {
                logger.info(Strings.get("fix.permissions.failed", host, this.installDir));
                throw new IOException(ioe);
            }
        }
    }

    private File createZipFileIfNeeded(String baseRootValue, ArrayList<String> binDirFiles) throws IOException, ZipFileException {
        File installRoot = new File(baseRootValue);
        File zipFileLocation = null;
        File glassFishZipFile = null;
        if (this.archive != null) {
            this.archive.replaceAll("\\\\", "/");
            this.archiveName = this.archive.substring(this.archive.lastIndexOf("/") + 1, this.archive.length());
            zipFileLocation = new File(this.archive.substring(0, this.archive.lastIndexOf("/")));
            glassFishZipFile = new File(this.archive);
            if (glassFishZipFile.exists() && !this.create) {
                logger.finer("Found " + glassFishZipFile.getCanonicalPath());
                return glassFishZipFile;
            }
            if (!zipFileLocation.canWrite()) {
                throw new IOException("Cannot write to " + this.archive);
            }
        } else {
            zipFileLocation = new File(".");
            glassFishZipFile = new File(zipFileLocation, this.archiveName);
            if (glassFishZipFile.exists() && !this.create) {
                return glassFishZipFile;
            }
            if (!zipFileLocation.canWrite()) {
                glassFishZipFile = new File(new File(System.getProperty("java.io.tmpdir")), this.archiveName);
            }
        }
        if (glassFishZipFile.exists() && !this.create) {
            logger.finer("Found " + glassFishZipFile.getCanonicalPath());
            return glassFishZipFile;
        }
        FileListerRelative lister = new FileListerRelative(installRoot);
        lister.keepEmptyDirectories();
        String[] files = lister.getFiles();
        List<String> resultFiles1 = Arrays.asList(files);
        ArrayList<String> resultFiles = new ArrayList<String>(resultFiles1);
        Iterator<String> iter = resultFiles.iterator();
        while (iter.hasNext()) {
            String fileName = iter.next();
            if (fileName.contains("domains") || fileName.contains("nodes")) {
                iter.remove();
                continue;
            }
            if (!fileName.startsWith("bin") && !fileName.startsWith("glassfish/bin")) continue;
            binDirFiles.add(fileName);
        }
        String[] filesToZip = new String[resultFiles.size()];
        filesToZip = resultFiles.toArray(filesToZip);
        ZipWriter writer = new ZipWriter(glassFishZipFile.getCanonicalPath(), installRoot.toString(), filesToZip);
        writer.safeWrite();
        logger.info("Created installation zip " + glassFishZipFile.getCanonicalPath());
        return glassFishZipFile;
    }

    private void validateKeyFile(String file) throws CommandException {
        File f = new File(file);
        if (!f.exists()) {
            throw new CommandException(Strings.get("KeyDoesNotExist", file));
        }
    }
}

