/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import java.io.Console;
import java.io.IOException;
import java.util.HashMap;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.SSHUtil;

public abstract class SSHCommandsBase
extends CLICommand {
    @Param(optional=true, defaultValue="${user.name}")
    protected String sshuser;
    @Param(optional=true, defaultValue="22")
    protected int sshport;
    @Param(optional=true)
    protected String sshkeyfile;
    @Param(optional=false, primary=true, multiple=true)
    protected String[] hosts;
    protected String sshpassword;
    protected String sshkeypassphrase = null;
    protected boolean promptPass = false;
    protected TokenResolver resolver = null;

    public SSHCommandsBase() {
        HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
        this.resolver = new TokenResolver(systemPropsMap);
    }

    protected String getSSHPassword(String node) throws CommandException {
        String password = this.getFromPasswordFile("AS_ADMIN_SSH_PASSWORD");
        if (password == null) {
            if (this.programOpts.isInteractive()) {
                password = this.readSSHPassword(Strings.get("SSHPasswordPrompt", this.sshuser, node));
            } else {
                throw new CommandException(Strings.get("SSHPasswordNotFound"));
            }
        }
        return password;
    }

    protected String getSSHPassphrase() throws CommandException {
        String passphrase = this.getFromPasswordFile("AS_ADMIN_SSH_KEYPASSPHRASE");
        if (passphrase == null) {
            passphrase = this.programOpts.isInteractive() ? this.readSSHPassword(Strings.get("SSHPassphrasePrompt", this.sshkeyfile)) : "";
        }
        return passphrase;
    }

    private String getFromPasswordFile(String name) {
        return (String)this.passwords.get(name);
    }

    protected boolean isValidAnswer(String val) {
        return val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("no") || val.equalsIgnoreCase("y") || val.equalsIgnoreCase("n");
    }

    protected String readSSHPassword(String prompt) {
        String password = null;
        Console cons = System.console();
        if (cons != null) {
            char[] pc = cons.readPassword("%s", prompt);
            password = new String(pc);
        }
        return password;
    }

    protected boolean isEncryptedKey() throws CommandException {
        boolean res = false;
        try {
            res = SSHUtil.isEncryptedKey((String)this.sshkeyfile);
        }
        catch (IOException ioe) {
            throw new CommandException(Strings.get("ErrorParsingKey", this.sshkeyfile, ioe.getMessage()));
        }
        return res;
    }

    protected void deleteRemoteFiles(SFTPClient sftpClient, String dir) throws IOException {
        for (SFTPv3DirectoryEntry directoryEntry : sftpClient.ls(dir)) {
            if (directoryEntry.filename.equals(".") || directoryEntry.filename.equals("..") || directoryEntry.filename.equals("nodes")) continue;
            if (directoryEntry.attributes.isDirectory()) {
                this.deleteRemoteFiles(sftpClient, dir + "/" + directoryEntry.filename);
                sftpClient.rmdir(dir + "/" + directoryEntry.filename);
                continue;
            }
            sftpClient.rm(dir + "/" + directoryEntry.filename);
        }
    }
}

