/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="delete-node-ssh")
@I18n(value="delete.node.ssh")
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
public class DeleteNodeSshCommand
implements AdminCommand,
PostConstruct {
    private static final int DEFAULT_TIMEOUT_MSEC = 300000;
    @Inject
    Habitat habitat;
    @Inject
    Node[] nodeList;
    @Inject
    Nodes nodes;
    @Inject
    private CommandRunner cr;
    @Param(name="name", primary=true)
    String name;
    @Param(optional=true, defaultValue="false")
    boolean uninstall;
    @Param(optional=true, defaultValue="false")
    boolean force;
    private RemoteInstanceCommandHelper helper;
    private String sshpassword = null;
    private String sshkeypassphrase = null;
    private static final String NL = System.getProperty("line.separator");
    private Logger logger = null;

    public void postConstruct() {
        this.helper = new RemoteInstanceCommandHelper(this.habitat);
    }

    public void execute(AdminCommandContext context) {
        boolean s;
        ActionReport report = context.getActionReport();
        this.logger = context.logger;
        Node node = this.nodes.getNode(this.name);
        if (node == null) {
            String msg = Strings.get("noSuchNode", this.name);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        if (node.getType() != null && !node.getType().equals("SSH")) {
            String msg = Strings.get("notSshNodeType", this.name);
            this.logger.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        ParameterMap info = new ParameterMap();
        if (this.uninstall) {
            SshConnector sshC = node.getSshConnector();
            SshAuth sshAuth = sshC.getSshAuth();
            if (sshAuth.getPassword() != null) {
                info.add((Object)"sshpassword", (Object)sshAuth.getPassword());
            }
            if (sshAuth.getKeyPassphrase() != null) {
                info.add((Object)"sshkeypassphrase", (Object)sshAuth.getKeyPassphrase());
            }
            if (sshAuth.getKeyfile() != null) {
                info.add((Object)"sshkeyfile", (Object)sshAuth.getKeyfile());
            }
            info.add((Object)"installdir", (Object)node.getInstallDir());
            info.add((Object)"sshport", (Object)sshC.getSshPort());
            info.add((Object)"sshuser", (Object)sshAuth.getUserName());
            info.add((Object)"nodehost", (Object)node.getNodeHost());
        }
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_delete-node", report);
        ParameterMap map = new ParameterMap();
        map.add((Object)"DEFAULT", (Object)this.name);
        ci.parameters(map);
        ci.execute();
        if (this.uninstall && !(s = this.uninstallNode(context, info)) && !this.force) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
    }

    private boolean uninstallNode(AdminCommandContext ctx, ParameterMap map) {
        boolean res = false;
        this.sshpassword = (String)map.getOne((Object)"sshpassword");
        this.sshkeypassphrase = (String)map.getOne((Object)"sshkeypassphrase");
        ArrayList<String> command = new ArrayList<String>();
        command.add("uninstall-node");
        command.add("--installdir");
        command.add((String)map.getOne((Object)"installdir"));
        if (this.force) {
            command.add("--force");
        }
        command.add("--sshport");
        command.add((String)map.getOne((Object)"sshport"));
        command.add("--sshuser");
        command.add((String)map.getOne((Object)"sshuser"));
        String key = (String)map.getOne((Object)"sshkeyfile");
        if (key != null) {
            command.add("--sshkeyfile");
            command.add(key);
        }
        String host = (String)map.getOne((Object)"nodehost");
        command.add(host);
        String firstErrorMessage = Strings.get("delete.node.ssh.uninstall.failed", host);
        StringBuilder out = new StringBuilder();
        int exitCode = this.execCommand(command, out);
        ActionReport report = ctx.getActionReport();
        if (exitCode == 0) {
            String msg = Strings.get("delete.node.ssh.uninstall.success", host);
            report.setMessage(msg);
            res = true;
        } else {
            report.setMessage(firstErrorMessage);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execCommand(List<String> cmdLine, StringBuilder output) {
        int exit = -1;
        ArrayList<String> fullcommand = new ArrayList<String>();
        String installDir = this.nodes.getNode("localhost").getInstallDirUnixStyle() + "/glassfish";
        if (!StringUtils.ok((String)installDir)) {
            throw new IllegalArgumentException(Strings.get("create.node.ssh.no.installdir"));
        }
        File asadmin = new File(SystemPropertyConstants.getAsAdminScriptLocation((String)installDir));
        fullcommand.add(asadmin.getAbsolutePath());
        BufferedWriter out = null;
        File f = null;
        if (this.sshpassword != null) {
            try {
                f = new File(System.getProperty("java.io.tmpdir"), "pass.tmp");
                out = new BufferedWriter(new FileWriter(f));
                out.newLine();
                out.write("AS_ADMIN_SSHPASSWORD=" + this.sshpassword + "\n");
                if (this.sshkeypassphrase != null) {
                    out.write("AS_ADMIN_SSHKEYPASSPHRASE=" + this.sshkeypassphrase + "\n");
                }
            }
            catch (IOException ioe) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Failed to create password file: " + ioe.getMessage());
                }
                output.append(Strings.get("create.node.ssh.passfile.error"));
                int n = 1;
                return n;
            }
            finally {
                try {
                    if (out != null) {
                        out.flush();
                    }
                    out.close();
                }
                catch (Exception ignore) {}
            }
            fullcommand.add("--passwordfile");
            fullcommand.add(f.getAbsolutePath());
        }
        fullcommand.addAll(cmdLine);
        ProcessManager pm = new ProcessManager(fullcommand);
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Running command on DAS: " + this.commandListToString(fullcommand));
        }
        pm.setTimeoutMsec(300000);
        if (this.logger.isLoggable(Level.FINER)) {
            pm.setEcho(true);
        } else {
            pm.setEcho(false);
        }
        try {
            exit = pm.execute();
        }
        catch (ProcessManagerException ex) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Error while executing command: " + ex.getMessage());
            }
            exit = 1;
        }
        String stdout = pm.getStdout();
        String stderr = pm.getStderr();
        if (output != null) {
            if (StringUtils.ok((String)stdout)) {
                output.append(stdout);
            }
            if (StringUtils.ok((String)stderr)) {
                if (output.length() > 0) {
                    output.append(NL);
                }
                output.append(stderr);
            }
        }
        if (f != null) {
            f.delete();
        }
        return exit;
    }

    private String commandListToString(List<String> command) {
        StringBuilder fullCommand = new StringBuilder();
        for (String s : command) {
            fullCommand.append(" ");
            fullCommand.append(s);
        }
        return fullCommand.toString();
    }
}

