/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.io.DomainDirs;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import java.io.Console;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SSHCommandsBase
extends CLICommand {
    @Param(optional=true, defaultValue="${user.name}")
    protected String sshuser;
    @Param(optional=true, defaultValue="22")
    protected int sshport;
    @Param(optional=true)
    protected String sshkeyfile;
    @Param(optional=false, primary=true, multiple=true)
    protected String[] hosts;
    protected String sshpassword;
    protected String sshkeypassphrase = null;
    protected boolean promptPass = false;
    protected TokenResolver resolver = null;

    public SSHCommandsBase() {
        HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
        this.resolver = new TokenResolver(systemPropsMap);
    }

    protected String getSSHPassword(String node) throws CommandException {
        String password = this.getFromPasswordFile("AS_ADMIN_SSHPASSWORD");
        if (password == null) {
            if (this.programOpts.isInteractive()) {
                password = this.readSSHPassword(Strings.get("SSHPasswordPrompt", this.sshuser, node));
            } else {
                throw new CommandException(Strings.get("SSHPasswordNotFound"));
            }
        }
        return password;
    }

    protected String getSSHPassphrase() throws CommandException {
        String passphrase = this.getFromPasswordFile("AS_ADMIN_SSHKEYPASSPHRASE");
        if (passphrase == null) {
            passphrase = this.programOpts.isInteractive() ? this.readSSHPassword(Strings.get("SSHPassphrasePrompt", this.sshkeyfile)) : "";
        }
        return passphrase;
    }

    private String getFromPasswordFile(String name) {
        return (String)this.passwords.get(name);
    }

    protected boolean isValidAnswer(String val) {
        return val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("no") || val.equalsIgnoreCase("y") || val.equalsIgnoreCase("n");
    }

    protected String readSSHPassword(String prompt) {
        String password = null;
        Console cons = System.console();
        if (cons != null) {
            char[] pc = cons.readPassword("%s", prompt);
            password = new String(pc);
        }
        return password;
    }

    protected boolean isEncryptedKey() throws CommandException {
        boolean res = false;
        try {
            res = SSHUtil.isEncryptedKey((String)this.sshkeyfile);
        }
        catch (IOException ioe) {
            throw new CommandException(Strings.get("ErrorParsingKey", this.sshkeyfile, ioe.getMessage()));
        }
        return res;
    }

    protected void deleteRemoteFiles(SFTPClient sftpClient, List<String> dasFiles, String dir, boolean force) throws IOException {
        for (SFTPv3DirectoryEntry directoryEntry : sftpClient.ls(dir)) {
            if (directoryEntry.filename.equals(".") || directoryEntry.filename.equals("..") || directoryEntry.filename.equals("nodes")) continue;
            if (directoryEntry.attributes.isDirectory()) {
                String f1 = dir + "/" + directoryEntry.filename;
                this.deleteRemoteFiles(sftpClient, dasFiles, f1, force);
                if (force) {
                    logger.fine("Force removing directory " + f1);
                    sftpClient.rmdir(f1);
                    continue;
                }
                if (!dasFiles.contains(f1)) continue;
                sftpClient.rmdir(f1);
                continue;
            }
            String f2 = dir + "/" + directoryEntry.filename;
            if (force) {
                logger.fine("Force removing file " + f2);
                sftpClient.rm(f2);
                continue;
            }
            if (!dasFiles.contains(f2)) continue;
            sftpClient.rm(f2);
        }
    }

    protected boolean checkIfNodeExistsForHost(String host) {
        boolean result;
        block6: {
            result = false;
            try {
                File[] files;
                File domainsDirFile = DomainDirs.getDefaultDomainsDir();
                for (File file : files = domainsDirFile.listFiles(new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory();
                    }
                })) {
                    DomainDirs dir = new DomainDirs(file);
                    File domainXMLFile = dir.getServerDirs().getDomainXml();
                    logger.finer("Domain XML file = " + domainXMLFile);
                    try {
                        Habitat habitat = Globals.getStaticHabitat();
                        ConfigParser parser = new ConfigParser(habitat);
                        URL domainURL = domainXMLFile.toURI().toURL();
                        DomDocument doc = parser.parse(domainURL);
                        Dom domDomain = doc.getRoot();
                        Domain domain = (Domain)domDomain.createProxy(Domain.class);
                        Nodes nodes = domain.getNodes();
                        for (Node node : nodes.getNode()) {
                            if (!node.getNodeHost().equals(host)) continue;
                            result = true;
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.FINE)) continue;
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException ioe) {
                if (!logger.isLoggable(Level.FINE)) break block6;
                ioe.printStackTrace();
            }
        }
        return result;
    }
}

