/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_create-instance-filesystem")
@Scoped(value=PerLookup.class)
public class CreateLocalInstanceFilesystemCommand
extends LocalInstanceCommand {
    @Param(name="instance_name", primary=true)
    private String instanceName0;
    String DASHost;
    int DASPort = -1;
    String DASProtocol;
    boolean dasIsSecure;
    private File agentConfigDir;
    private File dasPropsFile;
    private Properties dasProperties;
    protected boolean setDasDefaultsOnly = false;

    protected void validate() throws CommandException {
        if (!CreateLocalInstanceFilesystemCommand.ok((String)this.instanceName0)) {
            throw new CommandException(Strings.get("Instance.badInstanceName"));
        }
        this.instanceName = this.instanceName0;
        this.isCreateInstanceFilesystem = true;
        super.validate();
        String agentPath = "agent" + File.separator + "config";
        this.agentConfigDir = new File(this.nodeDirChild, agentPath);
        this.dasPropsFile = new File(this.agentConfigDir, "das.properties");
        if (this.dasPropsFile.isFile()) {
            this.validateDasOptions(this.programOpts.getHost(), String.valueOf(this.programOpts.getPort()), String.valueOf(this.programOpts.isSecure()), this.dasPropsFile);
            this.setDasDefaults(this.dasPropsFile);
            if (!this.setDasDefaultsOnly) {
                String nodeDirChildName = this.nodeDirChild != null ? this.nodeDirChild.getName() : "";
                String nodeName = this.node != null ? this.node : nodeDirChildName;
                logger.info(Strings.get("Instance.existingDasPropertiesWarning", this.programOpts.getHost(), "" + this.programOpts.getPort(), nodeName));
            }
        }
        this.DASHost = this.programOpts.getHost();
        this.DASPort = this.programOpts.getPort();
        this.dasIsSecure = this.programOpts.isSecure();
        this.DASProtocol = "http";
    }

    protected int executeCommand() throws CommandException {
        this.checkDASCoordinates();
        return this.createDirectories();
    }

    private int createDirectories() throws CommandException {
        boolean createDirsComplete = false;
        File badfile = null;
        while (badfile == null && !createDirsComplete) {
            if (!this.agentConfigDir.isDirectory() && !this.agentConfigDir.mkdirs()) {
                badfile = this.agentConfigDir;
            }
            createDirsComplete = true;
        }
        if (badfile != null) {
            throw new CommandException(Strings.get("Instance.cannotMkDir", badfile));
        }
        this.writeProperties();
        return 0;
    }

    private void writeProperties() throws CommandException {
        String filename = "";
        try {
            filename = this.dasPropsFile.getName();
            if (!this.dasPropsFile.isFile()) {
                this.writeDasProperties();
            }
        }
        catch (IOException ex) {
            throw new CommandException(Strings.get("Instance.cantWriteProperties", filename), (Throwable)ex);
        }
    }

    private void writeDasProperties() throws IOException {
        this.dasPropsFile.createNewFile();
        this.dasProperties = new Properties();
        this.dasProperties.setProperty("agent.das.host", this.DASHost);
        this.dasProperties.setProperty("agent.das.port", String.valueOf(this.DASPort));
        this.dasProperties.setProperty("agent.das.isSecure", String.valueOf(this.dasIsSecure));
        this.dasProperties.setProperty("agent.das.protocol", this.DASProtocol);
        FileOutputStream fos = new FileOutputStream(this.dasPropsFile);
        this.dasProperties.store(fos, Strings.get("Instance.dasPropertyComment"));
        fos.close();
    }

    private void checkDASCoordinates() throws CommandException {
        try {
            InetAddress addr = InetAddress.getByName(this.DASHost);
        }
        catch (UnknownHostException e) {
            String thisHost = NetUtils.getHostName();
            String msg = Strings.get("Instance.DasHostUnknown", this.DASHost, thisHost);
            throw new CommandException(msg, (Throwable)e);
        }
        if (!NetUtils.isRunning((String)this.DASHost, (int)this.DASPort)) {
            String thisHost = NetUtils.getHostName();
            String msg = Strings.get("Instance.DasHostUnreachable", this.DASHost, Integer.toString(this.DASPort), thisHost);
            throw new CommandException(msg);
        }
    }
}

