/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.remote.RemoteAdminCommand;
import com.sun.enterprise.admin.remote.ServerRemoteAdminCommand;
import com.sun.enterprise.admin.util.InstanceStateService;
import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.ObjectAnalyzer;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="restart-instance")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="restart.instance.command")
@ExecuteOn(value={RuntimeType.DAS})
public class RestartInstanceCommand
implements AdminCommand {
    @Inject
    InstanceStateService stateSvc;
    @Inject
    private Habitat habitat;
    @Inject
    private ServerEnvironment env;
    @Param(optional=false, primary=true)
    private String instanceName;
    @Param(name="debug", optional=true)
    private String debug;
    private Logger logger;
    private RemoteInstanceCommandHelper helper;
    private ActionReport report;
    private String errorMessage = null;
    private static final long WAIT_TIME_MS = 600000L;
    private Server instance;
    private String host;
    private int port;
    private String oldPid;

    public void execute(AdminCommandContext context) {
        try {
            this.helper = new RemoteInstanceCommandHelper(this.habitat);
            this.report = context.getActionReport();
            this.logger = context.getLogger();
            this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            if (!this.env.isDas()) {
                this.setError(Strings.get("restart.instance.notDas", this.env.getRuntimeType().toString()));
            }
            this.prepare();
            this.setOldPid();
            this.logger.fine("Restart-instance old-pid = " + this.oldPid);
            this.callInstance();
            this.waitForRestart();
            String msg = Strings.get("restart.instance.success", this.instanceName);
            this.logger.info(msg);
            this.report.setMessage(msg);
        }
        catch (CommandException ex) {
            this.setError(Strings.get("restart.instance.racError", this.instanceName, ex.getLocalizedMessage()));
        }
    }

    private void prepare() {
        if (this.isError()) {
            return;
        }
        if (!StringUtils.ok((String)this.instanceName)) {
            this.setError(Strings.get("stop.instance.noInstanceName"));
            return;
        }
        this.instance = this.helper.getServer(this.instanceName);
        if (this.instance == null) {
            this.setError(Strings.get("stop.instance.noSuchInstance", this.instanceName));
            return;
        }
        this.host = this.instance.getAdminHost();
        if (this.host == null) {
            this.setError(Strings.get("stop.instance.noHost", this.instanceName));
            return;
        }
        this.port = this.helper.getAdminPort(this.instance);
        if (this.port < 0) {
            this.setError(Strings.get("stop.instance.noPort", this.instanceName));
            return;
        }
        this.logger.finer(ObjectAnalyzer.toString((Object)this));
    }

    private void callInstance() throws CommandException {
        if (this.isError()) {
            return;
        }
        String cmdName = "_restart-instance";
        RemoteAdminCommand rac = this.createRac(cmdName);
        ParameterMap map = new ParameterMap();
        if (this.debug != null) {
            map.add((Object)"debug", (Object)this.debug);
        }
        rac.executeCommand(map);
    }

    private void waitForRestart() {
        if (this.isError()) {
            return;
        }
        long deadline = System.currentTimeMillis() + 600000L;
        while (System.currentTimeMillis() < deadline) {
            try {
                String newpid = this.getPid();
                if (!StringUtils.ok((String)newpid) || newpid.equals(this.oldPid)) continue;
                this.logger.fine("Restarted instance pid = " + newpid);
                return;
            }
            catch (Exception exception) {
            }
        }
        this.setError(Strings.get("restart.instance.timeout", this.instanceName));
    }

    private RemoteAdminCommand createRac(String cmdName) throws CommandException {
        return new ServerRemoteAdminCommand(this.habitat, cmdName, this.host, this.port, false, "admin", null, this.logger);
    }

    private void setError(String s) {
        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        this.report.setMessage(s);
    }

    private boolean isError() {
        return this.report.getActionExitCode() == ActionReport.ExitCode.FAILURE;
    }

    private void setOldPid() throws CommandException {
        if (this.isError()) {
            return;
        }
        this.oldPid = this.getPid();
        if (!StringUtils.ok((String)this.oldPid)) {
            this.setError(Strings.get("restart.instance.nopid", this.instanceName));
        }
    }

    private String getPid() throws CommandException {
        String cmdName = "_get-runtime-info";
        RemoteAdminCommand rac = this.createRac(cmdName);
        rac.executeCommand(new ParameterMap());
        Map map = rac.getAttributes();
        return (String)map.get("pid_value");
    }
}

