/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.DomainDirs;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.RelativePathResolver;
import org.glassfish.security.common.MasterPassword;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SSHCommandsBase
extends CLICommand {
    @Param(optional=true, defaultValue="${user.name}")
    protected String sshuser;
    @Param(optional=true, defaultValue="22")
    protected int sshport;
    @Param(optional=true)
    protected String sshkeyfile;
    @Param(optional=false, primary=true, multiple=true)
    protected String[] hosts;
    protected String sshpassword;
    protected String sshkeypassphrase = null;
    protected boolean promptPass = false;
    protected TokenResolver resolver = null;

    public SSHCommandsBase() {
        HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
        this.resolver = new TokenResolver(systemPropsMap);
    }

    protected String getSSHPassword(String node) throws CommandException {
        String alias;
        String password = this.getFromPasswordFile("AS_ADMIN_SSHPASSWORD");
        if (password != null && (alias = RelativePathResolver.getAlias((String)password)) != null) {
            password = this.expandPasswordAlias(node, alias, true);
        }
        if (password == null) {
            if (this.programOpts.isInteractive()) {
                password = this.readPassword(Strings.get("SSHPasswordPrompt", this.sshuser, node));
            } else {
                throw new CommandException(Strings.get("SSHPasswordNotFound"));
            }
        }
        return password;
    }

    protected String getSSHPassphrase(boolean verifyConn) throws CommandException {
        String alias;
        String passphrase = this.getFromPasswordFile("AS_ADMIN_SSHKEYPASSPHRASE");
        if (passphrase != null && (alias = RelativePathResolver.getAlias((String)passphrase)) != null) {
            passphrase = this.expandPasswordAlias(null, alias, verifyConn);
        }
        if (passphrase == null) {
            passphrase = this.programOpts.isInteractive() ? this.readPassword(Strings.get("SSHPassphrasePrompt", this.sshkeyfile)) : "";
        }
        return passphrase;
    }

    String getMasterPassword(String domain) throws CommandException {
        String masterPass = this.getFromPasswordFile("AS_ADMIN_MASTERPASSWORD");
        if (masterPass == null) {
            masterPass = this.programOpts.isInteractive() ? this.readPassword(Strings.get("DomainMasterPasswordPrompt", domain)) : "changeit";
        }
        return masterPass;
    }

    private String getFromPasswordFile(String name) {
        return (String)this.passwords.get(name);
    }

    protected boolean isValidAnswer(String val) {
        return val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("no") || val.equalsIgnoreCase("y") || val.equalsIgnoreCase("n");
    }

    protected boolean isEncryptedKey() throws CommandException {
        boolean res = false;
        try {
            res = SSHUtil.isEncryptedKey((String)this.sshkeyfile);
        }
        catch (IOException ioe) {
            throw new CommandException(Strings.get("ErrorParsingKey", this.sshkeyfile, ioe.getMessage()));
        }
        return res;
    }

    protected void deleteRemoteFiles(SFTPClient sftpClient, List<String> dasFiles, String dir, boolean force) throws IOException {
        for (SFTPv3DirectoryEntry directoryEntry : sftpClient.ls(dir)) {
            if (directoryEntry.filename.equals(".") || directoryEntry.filename.equals("..") || directoryEntry.filename.equals("nodes")) continue;
            if (directoryEntry.attributes.isDirectory()) {
                String f1 = dir + "/" + directoryEntry.filename;
                this.deleteRemoteFiles(sftpClient, dasFiles, f1, force);
                if (force) {
                    logger.fine("Force removing directory " + f1);
                    sftpClient.rmdir(f1);
                    continue;
                }
                if (!dasFiles.contains(f1)) continue;
                sftpClient.rmdir(f1);
                continue;
            }
            String f2 = dir + "/" + directoryEntry.filename;
            if (force) {
                logger.fine("Force removing file " + f2);
                sftpClient.rm(f2);
                continue;
            }
            if (!dasFiles.contains(f2)) continue;
            sftpClient.rm(f2);
        }
    }

    protected boolean checkIfNodeExistsForHost(String host) {
        boolean result;
        block6: {
            result = false;
            try {
                File[] files;
                File domainsDirFile = DomainDirs.getDefaultDomainsDir();
                for (File file : files = domainsDirFile.listFiles(new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory();
                    }
                })) {
                    DomainDirs dir = new DomainDirs(file);
                    File domainXMLFile = dir.getServerDirs().getDomainXml();
                    logger.finer("Domain XML file = " + domainXMLFile);
                    try {
                        Habitat habitat = Globals.getStaticHabitat();
                        ConfigParser parser = new ConfigParser(habitat);
                        URL domainURL = domainXMLFile.toURI().toURL();
                        DomDocument doc = parser.parse(domainURL);
                        Dom domDomain = doc.getRoot();
                        Domain domain = (Domain)domDomain.createProxy(Domain.class);
                        Nodes nodes = domain.getNodes();
                        for (Node node : nodes.getNode()) {
                            if (!node.getNodeHost().equals(host)) continue;
                            result = true;
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.FINE)) continue;
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException ioe) {
                if (!logger.isLoggable(Level.FINE)) break block6;
                ioe.printStackTrace();
            }
        }
        return result;
    }

    protected String expandPasswordAlias(String host, String alias, boolean verifyConn) {
        String expandedPassword;
        block13: {
            expandedPassword = null;
            boolean connStatus = false;
            try {
                File[] files;
                File domainsDirFile = DomainDirs.getDefaultDomainsDir();
                for (File f : files = domainsDirFile.listFiles(new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory();
                    }
                })) {
                    block12: {
                        System.setProperty("com.sun.aas.instanceRoot", f.getAbsolutePath());
                        try {
                            MasterPassword masterPasswordHelper = (MasterPassword)Globals.getDefaultHabitat().getComponent(MasterPassword.class, "Security SSL Password Provider Service");
                            PasswordAdapter pa = masterPasswordHelper.getMasterPasswordAdapter();
                            boolean exists = pa.aliasExists(alias);
                            if (!exists) break block12;
                            String mPass = this.getMasterPassword(f.getName());
                            masterPasswordHelper.setMasterPassword(mPass.toCharArray());
                            expandedPassword = masterPasswordHelper.getMasterPasswordAdapter().getPasswordForAlias(alias);
                        }
                        catch (Exception e) {
                            if (logger.isLoggable(Level.FINER)) {
                                logger.finer(StringUtils.cat((String)": ", (String[])new String[]{alias, e.getMessage()}));
                            }
                            logger.warning(Strings.get("GetPasswordFailure", f.getName()));
                            continue;
                        }
                    }
                    if (expandedPassword == null) continue;
                    SSHLauncher sshL = new SSHLauncher();
                    if (host != null) {
                        this.sshpassword = expandedPassword;
                        sshL.init(this.sshuser, host, this.sshport, this.sshpassword, null, null, logger);
                        connStatus = sshL.checkPasswordAuth();
                        if (!connStatus) {
                            logger.warning(Strings.get("PasswordAuthFailure", f.getName()));
                        }
                    } else {
                        this.sshkeypassphrase = expandedPassword;
                        if (verifyConn) {
                            sshL.init(this.sshuser, this.hosts[0], this.sshport, this.sshpassword, this.sshkeyfile, this.sshkeypassphrase, logger);
                            connStatus = sshL.checkConnection();
                            if (!connStatus) {
                                logger.warning(Strings.get("PasswordAuthFailure", f.getName()));
                            }
                        }
                    }
                    if (!connStatus) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ioe) {
                if (!logger.isLoggable(Level.FINER)) break block13;
                logger.finer(ioe.getMessage());
            }
        }
        return expandedPassword;
    }
}

