/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loadbalancer.admin.cli;

import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HealthChecker;
import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.config.serverbeans.LbConfigs;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="create-http-health-checker")
@Scoped(value=PerLookup.class)
@TargetType(value={CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@ExecuteOn(value={RuntimeType.DAS})
public final class CreateHTTPHealthCheckerCommand
implements AdminCommand {
    @Param(optional=true, defaultValue="10")
    String timeout;
    @Param(optional=true, defaultValue="30")
    String interval;
    @Param(optional=true, defaultValue="/")
    String url;
    @Param(optional=true)
    String config;
    @Param(primary=true)
    String target;
    @Inject
    Domain domain;
    @Inject
    LbConfigs lbconfigs;
    @Inject
    Target tgt;
    @Inject
    Logger logger;
    private ActionReport report;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateHTTPHealthCheckerCommand.class);

    public void execute(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (this.config != null) {
            LbConfig lbConfig = this.lbconfigs.getLbConfig(this.config);
            this.createHealthCheckerInternal(this.url, this.interval, this.timeout, lbConfig, this.config, this.target);
        } else {
            List lbConfigs = this.lbconfigs.getLbConfig();
            if (lbConfigs.size() == 0) {
                String msg = localStrings.getLocalString("NoLbConfigsElement", "No LB configs defined");
                this.logger.warning(msg);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            List<LbConfig> match = null;
            match = this.matchLbConfigToTarget(lbConfigs, this.target);
            if (match == null || match.size() == 0) {
                String msg = localStrings.getLocalString("UnassociatedTarget", "No LB config references target {0}", new Object[]{this.target});
                this.logger.warning(msg);
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            for (LbConfig lc : match) {
                this.createHealthCheckerInternal(this.url, this.interval, this.timeout, lc, lc.getName(), this.target);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createHealthCheckerInternal(String url, String interval, String timeout, LbConfig lbConfig, String lbConfigName, String target) {
        if (lbConfigName == null) {
            String msg = localStrings.getLocalString("InvalidLbConfigName", "Invalid LB configuration.");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        lbConfigName = lbConfig.getName();
        this.logger.fine("[LB-ADMIN] createHealthChecker called - URL " + url + ", Interval " + interval + ", Time out " + timeout + ", LB Config  " + lbConfigName + ", Target " + target);
        if (target == null) {
            String msg = localStrings.getLocalString("Nulltarget", "Null target");
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        if (this.tgt.isCluster(target)) {
            ClusterRef cRef = (ClusterRef)lbConfig.getRefByRef(ClusterRef.class, target);
            if (cRef == null) {
                String msg = localStrings.getLocalString("UnassociatedCluster", "Load balancer configuration [{0}] does not have a reference to the given cluster [{1}].", new Object[]{lbConfigName, target});
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            if (cRef != null && cRef.getHealthChecker() == null) {
                try {
                    this.addHealthChecker(cRef);
                }
                catch (TransactionFailure ex) {
                    String msg = localStrings.getLocalString("FailedToAddHC", "Failed to add health checker");
                    this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    this.report.setMessage(msg);
                    this.report.setFailureCause((Throwable)ex);
                    return;
                }
                this.logger.info("http_lb_admin.HealthCheckerCreated" + target);
                return;
            }
            String msg = localStrings.getLocalString("HealthCheckerExists", "Health checker server/cluster [{0}] already exists.", new Object[]{target});
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        if (this.domain.isServer(target)) {
            ServerRef sRef = (ServerRef)lbConfig.getRefByRef(ServerRef.class, target);
            if (sRef == null) {
                String msg = localStrings.getLocalString("UnassociatedServer", "Load balancer configuration [{0}] does not have a reference to the given server [{1}].", new Object[]{lbConfigName, target});
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(msg);
                return;
            }
            if (sRef != null && sRef.getHealthChecker() == null) {
                try {
                    this.addHealthChecker(sRef);
                }
                catch (TransactionFailure ex) {
                    String msg = localStrings.getLocalString("FailedToAddHC", "Failed to add health checker");
                    this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    this.report.setMessage(msg);
                    this.report.setFailureCause((Throwable)ex);
                    return;
                }
                this.logger.info(localStrings.getLocalString("http_lb_admin.HealthCheckerCreated", "Health checker created for target {0}", new Object[]{target}));
                return;
            }
            String msg = localStrings.getLocalString("HealthCheckerExists", "Health checker server/cluster [{0}] already exists.", new Object[]{target});
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return;
        }
        String msg = localStrings.getLocalString("InvalidTarget", "Invalid target", new Object[]{target});
        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        this.report.setMessage(msg);
    }

    private void addHealthChecker(ClusterRef ref) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ClusterRef>(){

            public Object run(ClusterRef param) throws PropertyVetoException, TransactionFailure {
                HealthChecker hc = (HealthChecker)param.createChild(HealthChecker.class);
                if (CreateHTTPHealthCheckerCommand.this.url != null) {
                    hc.setUrl(CreateHTTPHealthCheckerCommand.this.url);
                }
                if (CreateHTTPHealthCheckerCommand.this.interval != null) {
                    hc.setIntervalInSeconds(CreateHTTPHealthCheckerCommand.this.interval);
                }
                if (CreateHTTPHealthCheckerCommand.this.timeout != null) {
                    hc.setTimeoutInSeconds(CreateHTTPHealthCheckerCommand.this.timeout);
                }
                param.setHealthChecker(hc);
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy)ref);
    }

    private void addHealthChecker(ServerRef ref) throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ServerRef>(){

            public Object run(ServerRef param) throws PropertyVetoException, TransactionFailure {
                HealthChecker hc = (HealthChecker)param.createChild(HealthChecker.class);
                if (CreateHTTPHealthCheckerCommand.this.url != null) {
                    hc.setUrl(CreateHTTPHealthCheckerCommand.this.url);
                }
                if (CreateHTTPHealthCheckerCommand.this.interval != null) {
                    hc.setIntervalInSeconds(CreateHTTPHealthCheckerCommand.this.interval);
                }
                if (CreateHTTPHealthCheckerCommand.this.timeout != null) {
                    hc.setTimeoutInSeconds(CreateHTTPHealthCheckerCommand.this.timeout);
                }
                param.setHealthChecker(hc);
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy)ref);
    }

    private List<LbConfig> matchLbConfigToTarget(List<LbConfig> lbConfigs, String target) {
        ArrayList<LbConfig> list = null;
        if (target == null) {
            String msg = localStrings.getLocalString("Nulltarget", "Null target");
            this.logger.warning(msg);
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(msg);
            return null;
        }
        if (!lbConfigs.isEmpty()) {
            list = new ArrayList<LbConfig>();
            for (int i = 0; i < lbConfigs.size(); ++i) {
                ServerRef sRef;
                if (this.tgt.isCluster(target)) {
                    ClusterRef cRef = (ClusterRef)lbConfigs.get(i).getRefByRef(ClusterRef.class, target);
                    if (cRef == null) continue;
                    list.add(lbConfigs.get(i));
                    continue;
                }
                if (!this.domain.isServer(target) || (sRef = (ServerRef)lbConfigs.get(i).getRefByRef(ServerRef.class, target)) == null) continue;
                list.add(lbConfigs.get(i));
            }
        }
        return list;
    }
}

