/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.util;

import com.sun.enterprise.util.io.FileUtils;
import com.trilead.ssh2.Connection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SSHUtil {
    private static final List<Connection> activeConnections = new ArrayList<Connection>();
    private static final String NL = System.getProperty("line.separator");

    public static synchronized void register(Connection connection) {
        if (!activeConnections.contains(connection)) {
            activeConnections.add(connection);
        }
    }

    public static synchronized void unregister(Connection connection) {
        connection.close();
        activeConnections.remove(connection);
    }

    public static String checkString(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        return s;
    }

    public static String getExistingKeyFile() {
        String key = null;
        for (String keyName : Arrays.asList("id_rsa", "id_dsa", "identity")) {
            String h = System.getProperty("user.home") + File.separator;
            File f = new File(h + ".ssh" + File.separator + keyName);
            if (!f.exists()) continue;
            key = h + ".ssh" + File.separator + keyName;
            break;
        }
        return key;
    }

    public static String getDefaultKeyFile() {
        String k = System.getProperty("user.home") + File.separator + ".ssh" + File.separator + "id_rsa";
        return k;
    }

    public static boolean isEncryptedKey(String sshkeyfile) throws IOException {
        boolean result = false;
        String f = FileUtils.readSmallFile((String)sshkeyfile);
        if (f.startsWith("-----BEGIN ") && f.contains("ENCRYPTED") && f.endsWith(" PRIVATE KEY-----" + NL)) {
            result = true;
        }
        return result;
    }
}

