/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms.admin;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.gms.tools.MulticastTester;
import java.util.ArrayList;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="validate-multicast")
@Scoped(value=PerLookup.class)
public final class ValidateMulticastCommand
extends CLICommand {
    @Param(name="multicastport", optional=true)
    private String port;
    @Param(name="multicastaddress", optional=true)
    private String address;
    @Param(name="bindaddress", optional=true)
    private String bindInterface;
    @Param(name="sendperiod", optional=true)
    private String period;
    @Param(name="timeout", optional=true)
    private String timeout;
    @Param(name="timetolive", optional=true)
    private String ttl;
    @Param(optional=true, shortName="v", defaultValue="false")
    private boolean verbose;

    protected int executeCommand() throws CommandException {
        MulticastTester mt = new MulticastTester();
        return mt.run(this.createArgs());
    }

    private String[] createArgs() {
        ArrayList<String> argList = new ArrayList<String>();
        if (this.port != null && !this.port.isEmpty()) {
            argList.add(MulticastTester.PORT_OPTION);
            argList.add(this.port);
        }
        if (this.address != null && !this.address.isEmpty()) {
            argList.add(MulticastTester.ADDRESS_OPTION);
            argList.add(this.address);
        }
        if (this.bindInterface != null && !this.bindInterface.isEmpty()) {
            argList.add(MulticastTester.BIND_OPTION);
            argList.add(this.bindInterface);
        }
        if (this.period != null && !this.period.isEmpty()) {
            argList.add(MulticastTester.WAIT_PERIOD_OPTION);
            argList.add(this.period);
        }
        if (this.timeout != null && !this.timeout.isEmpty()) {
            argList.add(MulticastTester.TIMEOUT_OPTION);
            argList.add(this.timeout);
        }
        if (this.ttl != null && !this.ttl.isEmpty()) {
            argList.add(MulticastTester.TTL_OPTION);
            argList.add(this.ttl);
        }
        if (this.verbose) {
            argList.add(MulticastTester.DEBUG_OPTION);
        }
        return argList.toArray(new String[argList.size()]);
    }
}

