/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.StartServerCommand;
import com.sun.enterprise.admin.cli.StartServerHelper;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.cluster.SynchronizeInstanceCommand;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.ObjectAnalyzer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="start-local-instance")
@ExecuteOn(value={RuntimeType.DAS})
@Scoped(value=PerLookup.class)
public class StartLocalInstanceCommand
extends SynchronizeInstanceCommand
implements StartServerCommand {
    @Param(optional=true, defaultValue="false")
    private boolean verbose;
    @Param(optional=true, defaultValue="false")
    private boolean debug;
    private StartServerHelper helper;
    private String localPassword;
    private GFLauncherInfo info;
    private GFLauncher launcher;

    public RuntimeType getType() {
        return RuntimeType.INSTANCE;
    }

    protected boolean mkdirs(File f) {
        return false;
    }

    protected void validate() throws CommandException {
        super.validate();
        File dir = this.getServerDirs().getServerDir();
        if (!dir.isDirectory()) {
            throw new CommandException(Strings.get("Instance.noSuchInstance"));
        }
    }

    protected int executeCommand() throws CommandException {
        logger.finer(this.toString());
        if (this.sync.equals("none")) {
            logger.info(Strings.get("Instance.nosync"));
        } else if (!this.synchronizeInstance()) {
            File domainXml = new File(new File(this.instanceDir, "config"), "domain.xml");
            if (!domainXml.exists()) {
                logger.info(Strings.get("Instance.nodomainxml"));
                return 1;
            }
            logger.info(Strings.get("Instance.syncFailed"));
        }
        try {
            this.createLauncher();
            String mpv = this.getMasterPassword();
            this.helper = new StartServerHelper(logger, this.programOpts.isTerse(), this.getServerDirs(), this.launcher, mpv, this.debug);
            if (!this.helper.prepareForLaunch()) {
                return 1;
            }
            this.launcher.launch();
            if (this.verbose) {
                while (true) {
                    int returnValue = this.launcher.getExitValue();
                    switch (returnValue) {
                        case 10: {
                            logger.info(Strings.get("restart"));
                            break;
                        }
                        case 11: {
                            logger.info(Strings.get("restartChangeDebug", "on"));
                            this.info.setDebug(true);
                            break;
                        }
                        case 12: {
                            logger.info(Strings.get("restartChangeDebug", "off"));
                            this.info.setDebug(false);
                            break;
                        }
                        default: {
                            return returnValue;
                        }
                    }
                    if (CLIConstants.debugMode) {
                        System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
                    }
                    this.launcher.relaunch();
                }
            }
            this.helper.waitForServer();
            this.helper.report();
            return 0;
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
        catch (MiniXmlParserException me) {
            throw new CommandException((Throwable)me);
        }
    }

    public void createLauncher() throws GFLauncherException, MiniXmlParserException {
        this.launcher = GFLauncherFactory.getInstance((RuntimeType)this.getType());
        this.info = this.launcher.getInfo();
        this.info.setInstanceName(this.instanceName);
        this.info.setInstanceRootDir(this.instanceDir);
        this.info.setVerbose(this.verbose);
        this.info.setDebug(this.debug);
        this.info.setRespawnInfo(this.programOpts.getClassName(), this.programOpts.getClassPath(), this.respawnArgs());
        this.launcher.setup();
    }

    private String[] respawnArgs() {
        ArrayList<String> args = new ArrayList<String>(15);
        args.addAll(Arrays.asList(this.programOpts.getProgramArguments()));
        args.add(this.getName());
        args.add("--verbose=" + String.valueOf(this.verbose));
        args.add("--debug=" + String.valueOf(this.debug));
        if (StartLocalInstanceCommand.ok((String)this.nodeDir)) {
            args.add("--nodedir");
            args.add(this.nodeDir);
        }
        if (StartLocalInstanceCommand.ok((String)this.node)) {
            args.add("--node");
            args.add(this.node);
        }
        if (StartLocalInstanceCommand.ok((String)this.instanceName)) {
            args.add(this.instanceName);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Respawn args: " + ((Object)args).toString());
        }
        String[] a = new String[args.size()];
        args.toArray(a);
        return a;
    }

    public String toString() {
        return ObjectAnalyzer.toStringWithSuper((Object)((Object)this));
    }
}

