/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BaseProperty;
import org.netbeans.modules.schema2beans.Bean;
import org.netbeans.modules.schema2beans.BeanProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.DDFactory;
import org.netbeans.modules.schema2beans.DDLogFlags;
import org.netbeans.modules.schema2beans.DOMBinding;
import org.netbeans.modules.schema2beans.NodeFactory;
import org.netbeans.modules.schema2beans.NullEntityResolver;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.Schema2BeansNestedException;
import org.netbeans.modules.schema2beans.Schema2BeansRuntimeException;
import org.netbeans.modules.schema2beans.TraceLogger;
import org.netbeans.modules.schema2beans.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GraphManager {
    Document document = null;
    NodeFactory factory = null;
    HashMap bindingsMap = new HashMap();
    BaseBean root;
    private boolean writeCData = false;
    private Factory docFactory;
    private Writer docWriter;
    private String docTypePublic;
    private String docTypeSystem;
    static Map factoryMap = Collections.synchronizedMap(new HashMap(2));
    static Map writerMap = Collections.synchronizedMap(new HashMap(2));

    public GraphManager(BaseBean baseBean) {
        this.root = baseBean;
    }

    public static void setFactory(InputStream inputStream, Factory factory) throws Schema2BeansException {
        GraphManager.setFactory(inputStream, factory, null);
    }

    public static void setFactory(InputStream inputStream, Factory factory, Writer writer) throws Schema2BeansException {
        if (inputStream == null) {
            throw new Schema2BeansException(Common.getMessage("InputStreamCantBeNull_msg"));
        }
        if (factory != null) {
            factoryMap.put(inputStream, factory);
        } else {
            factoryMap.remove(inputStream);
        }
        if (writer != null) {
            writerMap.put(inputStream, writer);
        } else {
            writerMap.remove(inputStream);
        }
    }

    public void setWriter(Writer writer) {
        this.docWriter = writer;
    }

    public void setWriteCData(boolean bl) {
        this.writeCData = bl;
    }

    public static Node createRootElementNode(String string) throws Schema2BeansRuntimeException {
        String string2 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<" + string + "/>";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        Document document = GraphManager.createXmlDocument(byteArrayInputStream, false);
        NodeList nodeList = document.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof DocumentType)) continue;
            document.removeChild(node);
            --n;
        }
        return document;
    }

    public void setXmlDocument(Node node) throws Schema2BeansRuntimeException {
        if (node instanceof Document) {
            this.document = (Document)node;
            this.setNodeFactory((Document)node);
            Object v = factoryMap.get(node);
            if (v != null) {
                this.docFactory = (Factory)v;
                factoryMap.remove(node);
            }
            if ((v = writerMap.get(node)) != null) {
                this.docWriter = (Writer)v;
                writerMap.remove(node);
            }
        } else {
            throw new Schema2BeansRuntimeException(Common.getMessage("CantFindFactory_msg"));
        }
    }

    public Document getXmlDocument() {
        return this.document;
    }

    public void setDoctype(String string, String string2) {
        this.docTypePublic = string;
        this.docTypeSystem = string2;
    }

    public static Node getElementNode(String string, Node node) {
        Node node2;
        for (node2 = node.getFirstChild(); !(node2 == null || node2.getNodeType() == 1 && node2.getNodeName().equals(string)); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    public void createRootBinding(BaseBean baseBean, BeanProp beanProp, Node node) throws Schema2BeansException {
        beanProp.registerDomNode(node, null, baseBean);
        if (node != null) {
            this.bindingsMap.put(node, baseBean.binding);
        }
    }

    public void completeRootBinding(BaseBean baseBean, Node node) {
        this.bindingsMap.put(node, baseBean.binding);
        baseBean.binding.setNode(node);
    }

    public void setNodeFactory(Document document) {
        this.factory = new NodeFactory(document);
    }

    public NodeFactory getNodeFactory() {
        return this.factory;
    }

    public BaseBean getBeanRoot() {
        return this.root;
    }

    void write(OutputStream outputStream) throws IOException, Schema2BeansException {
        if (this.document == null) {
            throw new Schema2BeansException(Common.getMessage("CantGetDocument_msg"));
        }
        if (this.docWriter != null) {
            this.docWriter.write(outputStream, this.document);
        } else {
            XMLUtil.DOMWriter dOMWriter = this.getDOMWriter();
            dOMWriter.write(outputStream, this.document);
        }
    }

    protected void write(OutputStream outputStream, String string) throws IOException {
        XMLUtil.DOMWriter dOMWriter = this.getDOMWriter();
        dOMWriter.write(outputStream, string, this.document);
    }

    protected void write(java.io.Writer writer) throws IOException {
        XMLUtil.DOMWriter dOMWriter = this.getDOMWriter();
        dOMWriter.setWriter(writer);
        dOMWriter.write(this.document);
    }

    protected void write(java.io.Writer writer, String string) throws IOException {
        XMLUtil.DOMWriter dOMWriter = this.getDOMWriter();
        dOMWriter.setWriter(writer);
        dOMWriter.write(this.document, string);
    }

    public void write(java.io.Writer writer, Node node) throws IOException, Schema2BeansException {
        XMLUtil.DOMWriter dOMWriter = this.getDOMWriter();
        dOMWriter.setWriter(writer);
        dOMWriter.write(node);
    }

    protected XMLUtil.DOMWriter getDOMWriter() {
        XMLUtil.DOMWriter dOMWriter = new XMLUtil.DOMWriter();
        dOMWriter.setDocTypePublic(this.docTypePublic);
        dOMWriter.setDocTypeSystem(this.docTypeSystem);
        dOMWriter.setWriteCData(this.writeCData);
        return dOMWriter;
    }

    public void reindent(String string) {
        XMLUtil.reindent(this.document, string);
    }

    protected static void printLevel(java.io.Writer writer, int n, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        GraphManager.printLevel(stringBuffer, n, string);
        writer.write(stringBuffer.toString());
    }

    protected static void printLevel(StringBuffer stringBuffer, int n, String string) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
    }

    protected static void printLevel(java.io.Writer writer, int n, String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        GraphManager.printLevel(stringBuffer, n, string, string2);
        writer.write(stringBuffer.toString());
    }

    protected static void printLevel(OutputStream outputStream, int n, String string, String string2) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        GraphManager.printLevel(outputStreamWriter, n, string, string2);
        outputStreamWriter.flush();
    }

    protected static void printLevel(StringBuffer stringBuffer, int n, String string, String string2) {
        GraphManager.printLevel(stringBuffer, n, string);
        stringBuffer.append(string2);
    }

    public static Document createXmlDocument(InputStream inputStream, boolean bl) throws Schema2BeansRuntimeException {
        return GraphManager.createXmlDocument(inputStream, bl, null);
    }

    private static InputStream tee(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while ((n = inputStream.read(byArray, 0, 4096)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
            n2 += n;
        }
        System.out.println("schema2beans: in (length=" + n2 + "):");
        System.out.println(byteArrayOutputStream.toString());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return byteArrayInputStream;
    }

    public static Document createXmlDocument(InputStream inputStream, boolean bl, EntityResolver entityResolver) throws Schema2BeansRuntimeException {
        if (inputStream == null) {
            throw new IllegalArgumentException("in == null");
        }
        try {
            Object v;
            if (DDLogFlags.debug) {
                inputStream = GraphManager.tee(inputStream);
            }
            if ((v = factoryMap.get(inputStream)) != null) {
                Factory factory = (Factory)v;
                Document document = factory.createDocument(inputStream, bl);
                factoryMap.remove(inputStream);
                factoryMap.put(document, v);
                Object v2 = writerMap.get(inputStream);
                if (v2 != null) {
                    writerMap.remove(inputStream);
                    writerMap.put(document, v2);
                }
                return document;
            }
            return GraphManager.createXmlDocument(new InputSource(inputStream), bl, entityResolver, null);
        }
        catch (Schema2BeansException schema2BeansException) {
            throw new Schema2BeansRuntimeException(schema2BeansException);
        }
        catch (IOException iOException) {
            throw new Schema2BeansRuntimeException(iOException);
        }
    }

    public static Document createXmlDocument(InputSource inputSource, boolean bl) throws Schema2BeansException {
        return GraphManager.createXmlDocument(inputSource, bl, null, null);
    }

    public static Document createXmlDocument(InputSource inputSource, boolean bl, EntityResolver entityResolver, ErrorHandler errorHandler) throws Schema2BeansException {
        if (inputSource == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (!bl && entityResolver == null) {
            entityResolver = NullEntityResolver.newInstance();
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (entityResolver != null) {
                documentBuilder.setEntityResolver(entityResolver);
            }
            if (errorHandler != null) {
                documentBuilder.setErrorHandler(errorHandler);
            }
            if (DDLogFlags.debug) {
                System.out.println("createXmlDocument: validate=" + bl + " dbf=" + documentBuilderFactory + " db=" + documentBuilder + " er=" + entityResolver);
            }
            return documentBuilder.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Schema2BeansNestedException(Common.getMessage("CantCreateXMLDOMDocument_msg"), parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new Schema2BeansNestedException(Common.getMessage("CantCreateXMLDOMDocument_msg"), sAXException);
        }
        catch (IOException iOException) {
            throw new Schema2BeansNestedException(Common.getMessage("CantCreateXMLDOMDocument_msg"), iOException);
        }
    }

    public void fillProperties(BeanProp[] beanPropArray, Node node) throws Schema2BeansException {
        Object object;
        if (beanPropArray == null || node == null) {
            return;
        }
        if (this.bindingsMap.get(node) == null) {
            throw new Schema2BeansException(Common.getMessage("CurrentNodeHasNoBinding_msg", new Integer(node.hashCode())));
        }
        HashMap<Object, BeanProp> hashMap = new HashMap<Object, BeanProp>();
        HashMap<Object, ArrayList<BeanProp>> hashMap2 = new HashMap<Object, ArrayList<BeanProp>>();
        for (int i = 0; i < beanPropArray.length; ++i) {
            object = beanPropArray[i].dtdName;
            if (hashMap.containsKey(object)) {
                ArrayList<BeanProp> arrayList = (ArrayList<BeanProp>)hashMap2.get(object);
                if (arrayList == null) {
                    arrayList = new ArrayList<BeanProp>();
                    hashMap2.put(object, arrayList);
                }
                arrayList.add(beanPropArray[i]);
                continue;
            }
            hashMap.put(object, beanPropArray[i]);
        }
        HashMap hashMap3 = new HashMap();
        for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
            Object object2;
            if (object.getNodeType() == 1) {
                String string = object.getNodeName();
                object2 = (BeanProp)hashMap.get(string);
                if (object2 != null) {
                    DOMBinding dOMBinding;
                    Iterator iterator;
                    List list = (List)hashMap2.get(string);
                    if (list != null && !Common.isArray(((BeanProp)object2).type)) {
                        iterator = (Iterator)hashMap3.get(string);
                        if (iterator == null) {
                            iterator = list.iterator();
                            hashMap3.put(string, iterator);
                        } else if (iterator.hasNext()) {
                            object2 = (BeanProp)iterator.next();
                        }
                    }
                    DOMBinding dOMBinding2 = (DOMBinding)this.bindingsMap.get(object);
                    if (DDLogFlags.debug) {
                        iterator = string + " N(" + object.hashCode() + ") - " + (dOMBinding2 == null ? "new node" : "already bound B(" + dOMBinding2.hashCode() + ")");
                        TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 9, iterator);
                    }
                    if ((dOMBinding = ((BeanProp)object2).registerDomNode((Node)object, dOMBinding2, null)) == null) continue;
                    BaseBean baseBean = Common.isBean(((BeanProp)object2).type) ? (BaseBean)dOMBinding.getBean((BeanProp)object2) : null;
                    if (DDLogFlags.debug) {
                        iterator = "B(" + dOMBinding.hashCode() + ") - " + ((BeanProp)object2).getPropClass().getName();
                        TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 10, iterator);
                    }
                    if (baseBean == null) continue;
                    if (dOMBinding2 == null) {
                        this.bindingsMap.put(object, dOMBinding);
                    }
                    baseBean.createBean((Node)object, this);
                    continue;
                }
                if (!DDLogFlags.debug) continue;
                TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 11, string);
                continue;
            }
            short s = object.getNodeType();
            object2 = object.getNodeValue();
            if (!DDLogFlags.debug) continue;
            TraceLogger.put(TraceLogger.DEBUG, TraceLogger.SVC_DD, 13, 1, 12, DDFactory.typeToString(s) + " = " + Common.dumpHex((String)object2));
        }
    }

    public BaseBean getPropertyParent(String string) {
        return (BaseBean)GraphManager.getPropertyParent(this.root, string);
    }

    public static Bean getPropertyParent(Bean bean, String string) {
        String[] stringArray = string.split("/", -1);
        int n = stringArray.length;
        if (n < 2 || stringArray[0].length() > 0) {
            throw new IllegalArgumentException(Common.getMessage("NameShouldStartWithSlash_msg", string));
        }
        if (n == 2) {
            return null;
        }
        Bean bean2 = bean;
        for (int i = 2; i < n - 1; ++i) {
            int n2;
            String[] stringArray2 = stringArray[i].split("[.]", 2);
            String string2 = stringArray2[0];
            if (stringArray2.length == 1) {
                n2 = 0;
            } else {
                String string3 = stringArray2[1];
                if (string3.indexOf(105) != -1) {
                    throw new IllegalStateException(Common.getMessage("CantFindBeanBecausePartOfNameRemoved_msg", string2, string));
                }
                n2 = Integer.parseInt(string3, 16);
            }
            bean2 = bean2.propertyById(string2, n2);
            if (bean2 != null) continue;
            throw new IllegalStateException(Common.getMessage("CantFindBeanMayHaveBeenRemoved_msg", string2, string));
        }
        return bean2;
    }

    public String getKeyPropertyName(String string, String[] stringArray, String[] stringArray2) {
        return this.getKeyPropertyName(string, stringArray, stringArray2, false);
    }

    public String getKeyPropertyName(String string) {
        return this.getKeyPropertyName(string, null, null, true);
    }

    public String getKeyPropertyName(String string, String[] stringArray, String[] stringArray2, boolean bl) {
        return GraphManager.getKeyPropertyName(this.root, string, stringArray, stringArray2, bl);
    }

    public static String getKeyPropertyName(Bean bean, String string, String[] stringArray, String[] stringArray2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Bean bean2 = bean;
        String string2 = string;
        if (string2.charAt(0) == '/') {
            string2 = string2.substring(1);
        }
        do {
            Object object;
            String string3;
            String string4;
            int n;
            if ((n = string2.indexOf(47)) != -1) {
                string4 = string2.substring(0, n);
                string2 = string2.substring(n + 1);
            } else {
                string4 = string2;
                string2 = null;
            }
            n = string4.indexOf(46);
            if (n != -1) {
                string3 = string4.substring(n + 1);
                string4 = string4.substring(0, n);
                if (string3.indexOf(105) != -1) {
                    throw new IllegalStateException(Common.getMessage("CantFindBeanBecausePartOfNameRemoved_msg", string4, string));
                }
            } else {
                string3 = "0";
            }
            bean2 = bean.hasName(string4) ? bean : (bean2.getProperty(string4).isBean() ? bean2.propertyById(string4, Integer.parseInt(string3, 16)) : null);
            stringBuffer.append(string4);
            if (stringArray != null && bean2 != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    if (!stringArray[n].equals(string4)) continue;
                    stringBuffer.append(".");
                    stringBuffer.append(stringArray2[n]);
                    stringBuffer.append("=");
                    object = (String)bean2.getValue(stringArray2[n], 0);
                    if (object == null) break;
                    stringBuffer.append((String)object);
                    break;
                }
            } else if (bl && bean2 != null) {
                object = bean2.listProperties();
                for (n = 0; n < ((BaseProperty[])object).length; ++n) {
                    String string5 = object[n].getName();
                    if (string5.toLowerCase().indexOf("name") == -1) continue;
                    stringBuffer.append(".");
                    stringBuffer.append(string5);
                    stringBuffer.append("=");
                    String string6 = (String)bean2.getValue(string5, 0);
                    if (string6 == null) break;
                    stringBuffer.append(string6);
                    break;
                }
            }
            if (string2 == null) continue;
            stringBuffer.append("/");
        } while (string2 != null && bean2 != null);
        return stringBuffer.toString();
    }

    public static String trimPropertyName(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        do {
            if ((n = string.indexOf(46, n2)) == -1) {
                stringBuffer.append(string.substring(n2));
                continue;
            }
            stringBuffer.append(string.substring(n2, n));
            n2 = string.indexOf(47, n);
        } while (n != -1 && n2 != -1);
        return stringBuffer.toString();
    }

    public static String getPropertyParentName(String string) {
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.lastIndexOf(47)) != -1) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(46)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String getPropertyName(String string) {
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(46)) != -1) {
            string = string.substring(0, n);
        }
        if ((n = string.lastIndexOf(58)) != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public String getAttributeName(String string) {
        int n = string.lastIndexOf(58);
        string = n != -1 ? string.substring(n + 1) : null;
        return string;
    }

    public boolean isAttribute(String string) {
        int n = string.lastIndexOf(58);
        return n != -1;
    }

    private static String extractPropertyIndex(String string) {
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(46)) != -1) {
            if ((n = (string = string.substring(n + 1)).lastIndexOf(58)) != -1) {
                string = string.substring(0, n);
            }
        } else {
            string = null;
        }
        return string;
    }

    public int getPropertyIndex(String string) {
        return GraphManager.getPropertyIndex(this.root, string);
    }

    public static int getPropertyIndex(Bean bean, String string) {
        String string2 = GraphManager.extractPropertyIndex(string);
        if (string2 != null) {
            BeanProp beanProp;
            int n = string2.lastIndexOf(105);
            if (n != -1) {
                return Integer.parseInt(string2.substring(n + 1));
            }
            Bean bean2 = GraphManager.getPropertyParent(bean, string);
            if (bean2 != null && (beanProp = bean2.beanProp(GraphManager.getPropertyName(string))) != null) {
                return beanProp.idToIndex(Integer.parseInt(string2, 16));
            }
        }
        return -1;
    }

    public static void debug(boolean bl) {
        DDLogFlags.debug = bl;
    }

    public Object defaultScalarValue(int n) {
        switch (n & 0xFF00) {
            case 256: {
                return "";
            }
            case 768: {
                return Boolean.FALSE;
            }
            case 1024: {
                return new Byte(0);
            }
            case 1280: {
                return new Character('\u0000');
            }
            case 1536: {
                return new Short(0);
            }
            case 1792: {
                return new Integer(0);
            }
            case 2048: {
                return new Long(0L);
            }
            case 2304: {
                return new Float(0.0);
            }
            case 2560: {
                return new Double(0.0);
            }
        }
        throw new IllegalArgumentException(Common.getMessage("UnknownType", n));
    }

    public static interface Factory {
        public Document createDocument(InputStream var1, boolean var2);
    }

    public static interface Writer {
        public void write(OutputStream var1, Document var2);
    }
}

