/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility.database;

import com.sun.jdo.spi.persistence.utility.LogHelperUtility;
import com.sun.jdo.spi.persistence.utility.PropertyHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DBVendorTypeHelper {
    public static final int OTHER_ENUM = -1;
    public static final int DEFAULT_DB_ENUM = 0;
    public static final int ORACLE_ENUM = 1;
    public static final int POINTBASE_ENUM = 2;
    public static final int MSSQL_ENUM = 3;
    public static final int SYBASE_ENUM = 4;
    public static final int DB2_ENUM = 5;
    public static final int MYSQL_ENUM = 6;
    public static final int INFORMIX_ENUM = 7;
    public static final int INGRES_ENUM = 8;
    public static final int DERBY_ENUM = 9;
    public static final int MAX_KNOWN_DB = 10;
    private static final String[] enumToStringMapping = new String[]{"SQL92", "ORACLE", "POINTBASE", "MSSQL", "SYBASE", "DB2", "MYSQL", "INFORMIX", "INGRES", "DERBY"};
    public static final String DEFAULT_DB = enumToStringMapping[0];
    public static final String ORACLE = enumToStringMapping[1];
    public static final String POINTBASE = enumToStringMapping[2];
    public static final String MSSQL = enumToStringMapping[3];
    public static final String SYBASE = enumToStringMapping[4];
    public static final String DB2 = enumToStringMapping[5];
    public static final String MYSQL = enumToStringMapping[6];
    public static final String INFORMIX = enumToStringMapping[7];
    public static final String INGRES = enumToStringMapping[8];
    public static final String DERBY = enumToStringMapping[9];
    private static final String PROPERTY_PATH = "com/sun/jdo/spi/persistence/utility/database/";
    private static final String VENDOR_NAME_TO_TYPE_PROPERTY = "com.sun.jdo.spi.persistence.utility.database.VENDOR_NAME_TO_TYPE";
    private static final String VENDOR_NAME_TO_TYPE_RESOURCE_PROPERTY = "com.sun.jdo.spi.persistence.utility.database.VENDOR_NAME_TO_TYPE_RESOURCE";
    private static final String VENDOR_NAME_TO_TYPE_RESOURCE_DEFAULT_NAME = "com/sun/jdo/spi/persistence/utility/database/VendorNameToTypeMapping.properties";
    private static final Logger logger = LogHelperUtility.getLogger();
    private static Properties _nameToVendorType = DBVendorTypeHelper.initializeNameToVendorType();

    public static String getDBType(String vendorName) {
        int i;
        boolean debug = logger.isLoggable();
        if (debug) {
            logger.fine("utility.database.DBVendorTypeHelper.inputVendorName", vendorName);
        }
        String detectedDbType = DEFAULT_DB;
        if (vendorName != null && (detectedDbType = DBVendorTypeHelper.matchVendorNameInProperties(vendorName, _nameToVendorType)) == null && (i = (detectedDbType = vendorName.toUpperCase()).indexOf(47)) > -1) {
            detectedDbType = detectedDbType.substring(0, i);
        }
        if (debug) {
            logger.fine("utility.database.DBVendorTypeHelper.detectedVendorType", detectedDbType);
        }
        return detectedDbType;
    }

    public static int getEnumDBType(DatabaseMetaData metaData) throws SQLException {
        String dbType = DBVendorTypeHelper.getDBType(metaData.getDatabaseProductName());
        return DBVendorTypeHelper.getEnumDBType(dbType);
    }

    public static int getEnumDBType(String dbType) {
        int enumDBType = -1;
        for (int i = 0; i < 9 && enumDBType == -1; ++i) {
            if (!enumToStringMapping[i].equals(dbType)) continue;
            enumDBType = i;
        }
        return enumDBType;
    }

    public static boolean requireUpperCaseSchema(DatabaseMetaData dmd) throws SQLException {
        int vendorTypeEnum = DBVendorTypeHelper.getEnumDBType(dmd);
        return 1 == vendorTypeEnum || 2 == vendorTypeEnum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties initializeNameToVendorType() {
        Class<DBVendorTypeHelper> clazz = DBVendorTypeHelper.class;
        synchronized (DBVendorTypeHelper.class) {
            if (_nameToVendorType == null) {
                block6: {
                    _nameToVendorType = new Properties();
                    String resourceName = System.getProperty(VENDOR_NAME_TO_TYPE_RESOURCE_PROPERTY, VENDOR_NAME_TO_TYPE_RESOURCE_DEFAULT_NAME);
                    try {
                        PropertyHelper.loadFromResource(_nameToVendorType, resourceName, DBVendorTypeHelper.class.getClassLoader());
                    }
                    catch (IOException e) {
                        if (!logger.isLoggable()) break block6;
                        logger.fine("utility.database.DBVendorTypeHelper.couldNotLoadResource", resourceName, e);
                    }
                }
                DBVendorTypeHelper.overrideWithSystemProperties(_nameToVendorType);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _nameToVendorType;
        }
    }

    private static String matchVendorNameInProperties(String vendorName, Properties nameToVendorType) {
        String dbType = null;
        Iterator<Map.Entry<Object, Object>> iterator = nameToVendorType.entrySet().iterator();
        while (dbType == null && iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String regExpr = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (logger.isLoggable(300)) {
                logger.finest("utility.database.DBVendorTypeHelper.regExprDbType", regExpr, value);
            }
            if (!DBVendorTypeHelper.matchPattern(regExpr, vendorName)) continue;
            dbType = value;
        }
        return dbType;
    }

    private static boolean matchPattern(String regExp, String target) {
        boolean matches = false;
        try {
            matches = Pattern.matches(regExp, target);
        }
        catch (PatternSyntaxException e) {
            logger.fine("utility.database.DBVendorTypeHelper.patternSyntaxException", e);
        }
        return matches;
    }

    private static void overrideWithSystemProperties(Properties nameToVendorType) {
        String vendorNameToType = null;
        boolean debug = logger.isLoggable();
        int counter = 1;
        do {
            String vendorNameToTypeProperty;
            if ((vendorNameToType = System.getProperty(vendorNameToTypeProperty = VENDOR_NAME_TO_TYPE_PROPERTY + counter++)) == null) continue;
            String[] parsedProperty = vendorNameToType.split("=", 2);
            if (parsedProperty.length >= 2) {
                String suggestedDbType = parsedProperty[0];
                String regExp = parsedProperty[1];
                if (debug) {
                    logger.fine("utility.database.DBVendorTypeHelper.traceVendorNameToTypeProperty", vendorNameToTypeProperty, regExp, suggestedDbType);
                }
                nameToVendorType.put(regExp, suggestedDbType);
                continue;
            }
            if (!debug) continue;
            logger.fine("utility.database.DBVendorTypeHelper.errorParsingVendorNameToTypeProperty", vendorNameToTypeProperty, vendorNameToType);
        } while (vendorNameToType != null);
    }
}

