/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.mapping.ejb;

import com.sun.jdo.api.persistence.mapping.ejb.beans.CmpFieldMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.CmrFieldMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.EntityMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMappings;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.GraphManager;

public class SunCmpMappingsUtils {
    private static ResourceBundle bundle = ResourceBundle.getBundle("com.sun.jdo.api.persistence.mapping.ejb.Bundle");

    private SunCmpMappingsUtils() {
    }

    public static SunCmpMapping getFirstSunCmpMapping(SunCmpMappings scms, boolean addEmpty) {
        SunCmpMapping retVal = null;
        if (0 < scms.sizeSunCmpMapping()) {
            retVal = scms.getSunCmpMapping(0);
        }
        if (null == retVal && addEmpty) {
            retVal = new SunCmpMapping();
            scms.addSunCmpMapping(retVal);
        }
        return retVal;
    }

    public static EntityMapping findEntityMapping(SunCmpMappings scms, String bname, boolean addEmpty) throws IllegalArgumentException {
        EntityMapping retVal = (EntityMapping)SunCmpMappingsUtils.findSingleCompatibleBean("scms", scms, "bname", bname, "ejb-name", EntityMapping.class);
        if (null == retVal && addEmpty) {
            retVal = new EntityMapping();
            retVal.setEjbName(bname);
            SunCmpMapping scm = SunCmpMappingsUtils.getFirstSunCmpMapping(scms, addEmpty);
            scm.addEntityMapping(retVal);
        }
        return retVal;
    }

    public static CmrFieldMapping findCmrFieldMapping(EntityMapping em, String fname, boolean addEmpty) throws IllegalArgumentException {
        CmrFieldMapping retVal = (CmrFieldMapping)SunCmpMappingsUtils.findSingleCompatibleBean("em", em, "fname", fname, "cmr-field-name", CmrFieldMapping.class);
        if (null == retVal && addEmpty) {
            retVal = new CmrFieldMapping();
            retVal.setCmrFieldName(fname);
            em.addCmrFieldMapping(retVal);
        }
        return retVal;
    }

    public static CmpFieldMapping findCmpFieldMapping(EntityMapping em, String fname, boolean addEmpty) throws IllegalArgumentException {
        CmpFieldMapping retVal = (CmpFieldMapping)SunCmpMappingsUtils.findSingleCompatibleBean("em", em, "fname", fname, "field-name", CmpFieldMapping.class);
        if (null == retVal && addEmpty) {
            retVal = new CmpFieldMapping();
            retVal.setFieldName(fname);
            em.addCmpFieldMapping(retVal);
        }
        return retVal;
    }

    private static BaseBean findSingleCompatibleBean(String argOneName, BaseBean argOne, String argTwoName, String argTwo, String propName, Class type) {
        BaseBean retVal = null;
        if (null == argTwo || argTwo.length() < 1) {
            throw new IllegalArgumentException(argTwoName);
        }
        List l = SunCmpMappingsUtils.findCompatibleBeansWithValue(argOne, propName, argTwo, type);
        if (null != l) {
            if (l.size() == 1) {
                retVal = (BaseBean)l.get(0);
            } else if (l.size() > 1) {
                throw new IllegalArgumentException(argOneName);
            }
        }
        return retVal;
    }

    protected static List findCompatibleBeansWithValue(BaseBean root, String propName, String propVal, Class type) throws IllegalArgumentException {
        ArrayList<BaseBean> retVal = null;
        GraphManager gm = root.graphManager();
        if (null == gm) {
            throw new IllegalArgumentException(bundle.getString("ERR_DISCONNECTED_NOT_SUPPORTED"));
        }
        String[] props = root.findPropertyValue(propName, propVal);
        int len = 0;
        if (null != props) {
            len = props.length;
        }
        if (len > 0) {
            retVal = new ArrayList<BaseBean>();
        }
        for (int i = 0; i < len; ++i) {
            BaseBean candidate = gm.getPropertyParent(props[i]);
            if (!type.isInstance(candidate)) continue;
            retVal.add(candidate);
        }
        return retVal;
    }
}

