/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.database;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOFatalUserException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.api.persistence.support.SpecialDBOperation;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.database.BaseSpecialDBOperation;
import com.sun.jdo.spi.persistence.utility.PropertyHelper;
import com.sun.jdo.spi.persistence.utility.database.DBVendorTypeHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class DBVendorType {
    private HashMap dbMap;
    private SpecialDBOperation specialDBOperation;
    private static final SpecialDBOperation DEFAULT_SPECIAL_DB_OPERATION = new BaseSpecialDBOperation();
    private String vendorType;
    private int enumVendorType;
    private static final Logger logger;
    private static final ResourceBundle messages;
    private static Properties defaultProperties;
    private static final String EXT = ".properties";
    private static final String SPACE = " ";
    private static final String NONE = "";
    private static final String PATH = "com/sun/jdo/spi/persistence/support/sqlstore/database/";
    private static final String PROPERTY_OVERRIDE_FILE = ".tpersistence.properties";
    private static final String FOR_UPDATE = "FOR_UPDATE";
    private static final String HOLDLOCK = "HOLDLOCK";
    private static final String SUPPORTS_UPDATE_LOCK = "SUPPORTS_UPDATE_LOCK";
    private static final String SUPPORTS_LOCK_COLUMN_LIST = "SUPPORTS_LOCK_COLUMN_LIST";
    private static final String SUPPORTS_DISTINCT_WITH_UPDATE_LOCK = "SUPPORTS_DISTINCT_WITH_UPDATE_LOCK";
    private static final String NATIVE_OUTER_JOIN = "NATIVE_OUTER_JOIN";
    private static final String LEFT_JOIN = "LEFT_JOIN";
    private static final String LEFT_JOIN_APPEND = "LEFT_JOIN_APPEND";
    private static final String RIGHT_JOIN = "RIGHT_JOIN";
    private static final String RIGHT_JOIN_PRE = "RIGHT_JOIN_PRE";
    private static final String IS_NULL = "IS_NULL";
    private static final String IS_NOT_NULL = "IS_NOT_NULL";
    private static final String ANSI_TRIM = "ANSI_TRIM";
    private static final String RTRIM = "RTRIM";
    private static final String RTRIM_POST = "RTRIM_POST";
    private static final String TABLE_LIST_START = "TABLE_LIST_START";
    private static final String TABLE_LIST_END = "TABLE_LIST_END";
    private static final String STRING_CONCAT = "STRING_CONCAT";
    private static final String QUOTE_CHAR_START = "QUOTE_CHAR_START";
    private static final String QUOTE_CHAR_END = "QUOTE_CHAR_END";
    private static final String QUOTE_SPECIAL_ONLY = "QUOTE_SPECIAL_ONLY";
    private static final String CHAR_LENGTH = "CHAR_LENGTH";
    private static final String SQRT = "SQRT";
    private static final String ABS = "ABS";
    private static final String SUBSTRING = "SUBSTRING";
    private static final String SUBSTRING_FROM = "SUBSTRING_FROM";
    private static final String SUBSTRING_FOR = "SUBSTRING_FOR";
    private static final String POSITION = "POSITION";
    private static final String POSITION_SEP = "POSITION_SEP";
    private static final String POSITION_SEARCH_SOURCE = "POSITION_SEARCH_SOURCE";
    private static final String POSITION_THREE_ARGS = "POSITION_THREE_ARGS";
    private static final String MAP_EMPTY_STRING_TO_NULL = "MAP_EMPTY_STRING_TO_NULL";
    private static final String SPECIAL_DB_OPERATION = "SPECIAL_DB_OPERATION";
    private static final String SUPPORTS_LIKE_ESCAPE = "SUPPORTS_LIKE_ESCAPE";
    private static final String LEFT_LIKE_ESCAPE = "LEFT_LIKE_ESCAPE";
    private static final String RIGHT_LIKE_ESCAPE = "RIGHT_LIKE_ESCAPE";
    private static final String NULL_COMPARISON_FUNCTION_NAME = "NULL_COMPARISON_FUNCTION_NAME";
    private static final String MOD_FUNCTION_NAME = "MOD_FUNCTION_NAME";
    private static final String CONCAT_CAST = "CONCAT_CAST";
    private static final String PARAMETER_CAST = "PARAMETER_CAST";
    private static final String INLINE_NUMERIC = "INLINE_NUMERIC";
    private static final String[] props;

    public DBVendorType(DatabaseMetaData databaseMetaData, String identifier) throws SQLException {
        String vendorName = databaseMetaData.getDatabaseProductName();
        String vendorType = DBVendorTypeHelper.getDBType((String)vendorName);
        if (logger.isLoggable()) {
            Object[] items = new Object[]{vendorName, vendorType};
            logger.fine("sqlstore.database.dbvendor.vendorname", items);
        }
        this.vendorType = vendorType;
        this.enumVendorType = DBVendorTypeHelper.getEnumDBType((String)vendorType);
        this.dbMap = DBVendorType.getDBPropertiesMap(vendorType, vendorName);
        this.specialDBOperation = this.newSpecialDBOperationInstance((String)this.dbMap.get(SPECIAL_DB_OPERATION), databaseMetaData, identifier);
    }

    private static HashMap getDBPropertiesMap(String vendorType, String vendorName) {
        HashMap<Object, Object> dbHashMap = new HashMap<Object, Object>(defaultProperties);
        Properties dbProperties = DBVendorType.loadDBProperties(vendorType, vendorName);
        dbHashMap.putAll(dbProperties);
        return dbHashMap;
    }

    private static Properties initializeDefaultProperties() {
        if (defaultProperties == null) {
            defaultProperties = new Properties();
            try {
                DBVendorType.loadFromResource(DBVendorTypeHelper.DEFAULT_DB, defaultProperties);
            }
            catch (IOException e) {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"sqlstore.database.dbvendor.cantloadDefaultProperties"), e);
            }
        }
        return defaultProperties;
    }

    private static Properties loadDBProperties(String vendorType, String vendorName) {
        Properties dbProperties;
        block3: {
            dbProperties = new Properties();
            if (!vendorType.equals(DBVendorTypeHelper.DEFAULT_DB)) {
                try {
                    DBVendorType.loadFromResource(vendorType, dbProperties);
                }
                catch (IOException e) {
                    if (!logger.isLoggable()) break block3;
                    logger.fine("sqlstore.database.dbvendor.init.default", (Object)vendorType);
                }
            }
        }
        DBVendorType.overrideProperties(dbProperties, vendorName);
        return dbProperties;
    }

    private static void overrideProperties(Properties dbProperties, String vendorName) {
        boolean debug = logger.isLoggable();
        Properties overridingProperties = new Properties();
        try {
            PropertyHelper.loadFromFile((Properties)overridingProperties, (String)PROPERTY_OVERRIDE_FILE);
        }
        catch (Exception e) {
            if (debug) {
                logger.fine("sqlstore.database.dbvendor.overrideproperties");
            }
            return;
        }
        String cleanVendorName = vendorName.toLowerCase().replace(' ', '_');
        cleanVendorName = cleanVendorName.replace('/', '_');
        String propertyPrefix = "database." + cleanVendorName + ".";
        for (int i = 0; i < props.length; ++i) {
            String o = overridingProperties.getProperty(propertyPrefix + props[i]);
            if (o == null) continue;
            if (debug) {
                Object[] items = new Object[]{props[i], o};
                logger.fine("sqlstore.database.dbvendor.overrideproperties.with", items);
            }
            dbProperties.setProperty(props[i], o);
        }
    }

    private static void loadFromResource(String resourceName, Properties properties) throws IOException {
        String fullResourceName = PATH + resourceName + EXT;
        PropertyHelper.loadFromResource((Properties)properties, (String)fullResourceName, (ClassLoader)DBVendorType.class.getClassLoader());
    }

    private SpecialDBOperation newSpecialDBOperationInstance(String specialDBOpClassName, DatabaseMetaData databaseMetaData, String identifier) {
        ClassLoader loader;
        Class clz;
        SpecialDBOperation retInstance = null;
        if (specialDBOpClassName != null && (clz = (Class)AccessController.doPrivileged(new PrivilegedAction(loader = DBVendorType.class.getClassLoader(), specialDBOpClassName){
            final /* synthetic */ ClassLoader val$loader;
            final /* synthetic */ String val$specialDBOpClassName;
            {
                this.val$loader = classLoader;
                this.val$specialDBOpClassName = string;
            }

            public Object run() {
                try {
                    if (this.val$loader != null) {
                        return Class.forName(this.val$specialDBOpClassName, true, this.val$loader);
                    }
                    return Class.forName(this.val$specialDBOpClassName);
                }
                catch (Exception ex) {
                    if (logger.isLoggable()) {
                        logger.log(800, "core.configuration.cantloadclass", (Object)this.val$specialDBOpClassName);
                    }
                    return null;
                }
            }
        })) != null) {
            try {
                retInstance = (SpecialDBOperation)clz.newInstance();
                retInstance.initialize(databaseMetaData, identifier);
            }
            catch (Exception ex) {
                throw new JDOFatalUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"sqlstore.database.dbvendor.cantinstantiateclass", (String)specialDBOpClassName), ex);
            }
        }
        return retInstance != null ? retInstance : DEFAULT_SPECIAL_DB_OPERATION;
    }

    public String getLeftJoin() {
        String s = (String)this.dbMap.get(LEFT_JOIN);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getleftjoin", (Object)s);
        }
        return SPACE + s;
    }

    public boolean isUpdateLockSupported() {
        String s = (String)this.dbMap.get(SUPPORTS_UPDATE_LOCK);
        Boolean b = Boolean.valueOf(s);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.isupdatelocksupported", (Object)b);
        }
        return b;
    }

    public boolean isLockColumnListSupported() {
        String s = (String)this.dbMap.get(SUPPORTS_LOCK_COLUMN_LIST);
        Boolean b = Boolean.valueOf(s);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.islockcolumnlistsupported", (Object)b);
        }
        return b;
    }

    public boolean isDistinctSupportedWithUpdateLock() {
        String s = (String)this.dbMap.get(SUPPORTS_DISTINCT_WITH_UPDATE_LOCK);
        Boolean b = Boolean.valueOf(s);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.isdistinctupdatelocksupported", (Object)b);
        }
        return b;
    }

    public String getHoldlock() {
        String s = (String)this.dbMap.get(HOLDLOCK);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getholdlock", (Object)s);
        }
        return SPACE + s;
    }

    public boolean isNativeOuterJoin() {
        String s = (String)this.dbMap.get(NATIVE_OUTER_JOIN);
        Boolean b = Boolean.valueOf(s);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.isNativeOuterJoin", (Object)b);
        }
        return b;
    }

    public String getLeftJoinPost() {
        String s = (String)this.dbMap.get(LEFT_JOIN_APPEND);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getleftjoinpost", (Object)s);
        }
        return SPACE + s;
    }

    public String getRightJoin() {
        String s = (String)this.dbMap.get(RIGHT_JOIN);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getrightjoin", (Object)s);
        }
        return SPACE + s;
    }

    public String getRightJoinPre() {
        String s = (String)this.dbMap.get(RIGHT_JOIN_PRE);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getrightjoinipre", (Object)s);
        }
        return SPACE + s;
    }

    public String getIsNull() {
        String s = (String)this.dbMap.get(IS_NULL);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getisnull", (Object)s);
        }
        return SPACE + s;
    }

    public String getIsNotNull() {
        String s = (String)this.dbMap.get(IS_NOT_NULL);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getisnotnull", (Object)s);
        }
        return SPACE + s;
    }

    public boolean isAnsiTrim() {
        String s = (String)this.dbMap.get(ANSI_TRIM);
        Boolean b = Boolean.valueOf(s);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.isAnsiTrim", (Object)b);
        }
        return b;
    }

    public String getRtrim() {
        String s = (String)this.dbMap.get(RTRIM);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getrtrim", (Object)s);
        }
        return SPACE + s;
    }

    public String getRtrimPost() {
        String s = (String)this.dbMap.get(RTRIM_POST);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getrtrimpost", (Object)s);
        }
        return SPACE + s;
    }

    public String getCharLength() {
        String s = (String)this.dbMap.get(CHAR_LENGTH);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getcharlength", (Object)s);
        }
        return SPACE + s;
    }

    public String getSqrt() {
        String s = (String)this.dbMap.get(SQRT);
        if (s == null) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalop", (String)"Sqrt"));
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getsqrt", (Object)s);
        }
        return SPACE + s;
    }

    public String getAbs() {
        String s = (String)this.dbMap.get(ABS);
        if (s == null) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalop", (String)"Abs"));
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getabs", (Object)s);
        }
        return SPACE + s;
    }

    public String getForUpdate() {
        String s = (String)this.dbMap.get(FOR_UPDATE);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getforupdate", (Object)s);
        }
        return SPACE + s;
    }

    public String getTableListStart() {
        String s = (String)this.dbMap.get(TABLE_LIST_START);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.gettableliststart", (Object)s);
        }
        return SPACE + s;
    }

    public String getTableListEnd() {
        String s = (String)this.dbMap.get(TABLE_LIST_END);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.gettablelistend", (Object)s);
        }
        return SPACE + s;
    }

    public String getStringConcat() {
        String s = (String)this.dbMap.get(STRING_CONCAT);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getstringconcat", (Object)s);
        }
        return SPACE + s + SPACE;
    }

    public String getQuoteCharStart() {
        String s = (String)this.dbMap.get(QUOTE_CHAR_START);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getquotecharstart", (Object)s);
        }
        return s;
    }

    public String getQuoteCharEnd() {
        String s = (String)this.dbMap.get(QUOTE_CHAR_END);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getquotecharend", (Object)s);
        }
        return s;
    }

    public boolean getQuoteSpecialOnly() {
        String s = (String)this.dbMap.get(QUOTE_SPECIAL_ONLY);
        Boolean b = Boolean.valueOf(s);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getquotespecialonly", (Object)b);
        }
        return b;
    }

    public String getSubstring() {
        String s = (String)this.dbMap.get(SUBSTRING);
        if (s == null) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalop", (String)"substring"));
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getsubstring", (Object)s);
        }
        return SPACE + s;
    }

    public String getSubstringFrom() {
        String s = (String)this.dbMap.get(SUBSTRING_FROM);
        if (s == null) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalop", (String)"from part of substring"));
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getsubstringfrom", (Object)s);
        }
        return SPACE + s + SPACE;
    }

    public String getSubstringFor() {
        String s = (String)this.dbMap.get(SUBSTRING_FOR);
        if (s == null) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalop", (String)"for part of substring"));
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getsubstringfor", (Object)s);
        }
        return SPACE + s + SPACE;
    }

    public String getPosition() {
        String s = (String)this.dbMap.get(POSITION);
        if (s == null) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalop", (String)"position"));
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getposition", (Object)s);
        }
        return SPACE + s;
    }

    public String getPositionSep() {
        String s = (String)this.dbMap.get(POSITION_SEP);
        if (s == null) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalop", (String)"in part of position"));
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getpositionin", (Object)s);
        }
        return SPACE + s;
    }

    public boolean isPositionSearchSource() {
        String s = (String)this.dbMap.get(POSITION_SEARCH_SOURCE);
        Boolean b = Boolean.valueOf(s);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getpositionsrchsrc", (Object)b);
        }
        return b;
    }

    public boolean isPositionThreeArgs() {
        String s = (String)this.dbMap.get(POSITION_THREE_ARGS);
        Boolean b = Boolean.valueOf(s);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getposition3args", (Object)b);
        }
        return b;
    }

    public boolean mapEmptyStringToNull() {
        String s = (String)this.dbMap.get(MAP_EMPTY_STRING_TO_NULL);
        Boolean b = Boolean.valueOf(s);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.mapemptystrtonull", (Object)b);
        }
        return b;
    }

    public boolean supportsLikeEscape() {
        String s = (String)this.dbMap.get(SUPPORTS_LIKE_ESCAPE);
        Boolean b = Boolean.valueOf(s);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.supportslikeescape", (Object)b);
        }
        return b;
    }

    public String getLeftLikeEscape() {
        String s = (String)this.dbMap.get(LEFT_LIKE_ESCAPE);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getleftlikeescape", (Object)s);
        }
        return SPACE + s;
    }

    public String getRightLikeEscape() {
        String s = (String)this.dbMap.get(RIGHT_LIKE_ESCAPE);
        if (s == null) {
            s = NONE;
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getrightlikeescape", (Object)s);
        }
        return SPACE + s;
    }

    public String getNullComparisonFunctionName() {
        String s = (String)this.dbMap.get(NULL_COMPARISON_FUNCTION_NAME);
        s = s == null ? NONE : s.trim();
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getNullComparisonFunctionName", (Object)s);
        }
        return s;
    }

    public boolean isModOperationUsingFunction() {
        return this.getModFunctionName().length() != 0;
    }

    public String getModFunctionName() {
        String s = (String)this.dbMap.get(MOD_FUNCTION_NAME);
        if (s == null) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"core.constraint.illegalop", (String)" % "));
        }
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getModFunctionName", (Object)s);
        }
        return s;
    }

    public String getConcatCast() {
        String s = (String)this.dbMap.get(CONCAT_CAST);
        s = s == null ? NONE : s.trim();
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getConcatCast", (Object)s);
        }
        return s;
    }

    public boolean isParameterCast() {
        String s = (String)this.dbMap.get(PARAMETER_CAST);
        Boolean b = Boolean.valueOf(s);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.isParameterCast", (Object)b);
        }
        return b;
    }

    public boolean isInlineNumeric() {
        String s = (String)this.dbMap.get(INLINE_NUMERIC);
        Boolean b = Boolean.valueOf(s);
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.isInlineNumeric", (Object)b);
        }
        return b;
    }

    public String getName() {
        return this.vendorType;
    }

    public SpecialDBOperation getSpecialDBOperation() {
        if (logger.isLoggable()) {
            logger.fine("sqlstore.database.dbvendor.getSpecialDBOperation", (Object)this.specialDBOperation);
        }
        return this.specialDBOperation;
    }

    public String getParameterMarker(int type) {
        String castType;
        String paramMarker = "?";
        if (this.isParameterCast() && (castType = DBVendorType.getCastType(type)) != null) {
            paramMarker = "CAST (? AS " + castType + ")";
        }
        return paramMarker;
    }

    private static String getCastType(int type) {
        String castType = null;
        switch (type) {
            case 1: 
            case 11: {
                castType = "SMALLINT";
                break;
            }
            case 2: 
            case 12: 
            case 21: {
                castType = "VARCHAR(32672)";
                break;
            }
            case 3: 
            case 13: {
                castType = "SMALLINT";
                break;
            }
            case 4: 
            case 14: {
                castType = "SMALLINT";
                break;
            }
            case 5: 
            case 15: {
                castType = "INTEGER";
                break;
            }
            case 6: 
            case 16: {
                castType = "BIGINT";
                break;
            }
            case 7: 
            case 17: {
                castType = "REAL";
                break;
            }
            case 8: 
            case 18: {
                castType = "DOUBLE";
                break;
            }
            case 22: 
            case 25: {
                castType = "TIMESTAMP";
                break;
            }
            case 23: {
                castType = "DATE";
                break;
            }
            case 24: {
                castType = "TIME";
            }
        }
        return castType;
    }

    static {
        props = new String[]{FOR_UPDATE, HOLDLOCK, SUPPORTS_UPDATE_LOCK, SUPPORTS_LOCK_COLUMN_LIST, SUPPORTS_DISTINCT_WITH_UPDATE_LOCK, NATIVE_OUTER_JOIN, LEFT_JOIN, LEFT_JOIN_APPEND, RIGHT_JOIN, RIGHT_JOIN_PRE, IS_NULL, IS_NOT_NULL, ANSI_TRIM, RTRIM, RTRIM_POST, TABLE_LIST_START, TABLE_LIST_END, QUOTE_CHAR_START, QUOTE_CHAR_END, QUOTE_SPECIAL_ONLY, STRING_CONCAT, CHAR_LENGTH, SQRT, ABS, SUBSTRING, SUBSTRING_FROM, SUBSTRING_FOR, POSITION, POSITION_SEP, POSITION_SEARCH_SOURCE, POSITION_THREE_ARGS, MAP_EMPTY_STRING_TO_NULL, SPECIAL_DB_OPERATION, SUPPORTS_LIKE_ESCAPE, LEFT_LIKE_ESCAPE, RIGHT_LIKE_ESCAPE, NULL_COMPARISON_FUNCTION_NAME, MOD_FUNCTION_NAME, CONCAT_CAST, PARAMETER_CAST, INLINE_NUMERIC};
        logger = LogHelperSQLStore.getLogger();
        messages = I18NHelper.loadBundle((String)"com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (ClassLoader)DBVendorType.class.getClassLoader());
        defaultProperties = DBVendorType.initializeDefaultProperties();
    }
}

